/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.msgresource;

import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Properties;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.msgresource.MessageInput;
import jp.ossc.nimbus.service.msgresource.MessageResourceDefine;
import jp.ossc.nimbus.util.CsvArrayList;

public class FileMessageInput
implements MessageInput,
MessageResourceDefine {
    private String[] mPayloadArray = null;
    private Properties[] mPropertiesArray = null;
    private int mCurrentline = 0;
    private int mRecordNum = 0;
    private final String SEP = ":";

    public FileMessageInput(String filename) {
        ArrayList<String> payloadDefs = new ArrayList<String>();
        ArrayList<Properties> propertyDefs = new ArrayList<Properties>();
        try {
            LineNumberReader reader = new LineNumberReader(new FileReader(filename));
            String line = null;
            this.mRecordNum = 0;
            String payloadStr = "";
            String propStr = "";
            while ((line = reader.readLine()) != null) {
                if (line.equals("") || line.charAt(0) == '#') continue;
                int pos = line.indexOf(":");
                if (pos == -1) {
                    throw new ServiceException("MESSAGERESOURCESERVICE901", "line no." + reader.getLineNumber() + " is invalid. filename is " + filename + ".");
                }
                if (pos == 0) {
                    propStr = "";
                    payloadStr = line.substring(1);
                } else if (pos == line.length() - 1) {
                    propStr = line.substring(0, pos);
                    payloadStr = "";
                } else {
                    propStr = line.substring(0, pos);
                    payloadStr = line.substring(pos + 1);
                }
                Properties jmsProp = new Properties();
                CsvArrayList props = new CsvArrayList();
                props.split(propStr);
                if (!propStr.equals("")) {
                    for (int rCnt = 0; rCnt < props.size(); ++rCnt) {
                        String keyAndVal = (String)props.get(rCnt);
                        int separatePos = keyAndVal.indexOf("=");
                        if (separatePos <= 0 || separatePos >= keyAndVal.length() - 1) {
                            throw new ServiceException("MESSAGERESOURCESERVICE902", "line no." + reader.getLineNumber() + " has invalid property definition. " + filename + ".");
                        }
                        String key = keyAndVal.substring(0, separatePos);
                        String val = keyAndVal.substring(separatePos + 1);
                        jmsProp.put(key, val);
                    }
                }
                propertyDefs.add(jmsProp);
                payloadDefs.add(payloadStr);
                ++this.mRecordNum;
            }
        }
        catch (Exception e) {
            throw new ServiceException("MESSAGERESOURCESERVICE900", "Exception were thrown while reading " + filename + " .", e);
        }
        this.mPayloadArray = new String[this.mRecordNum];
        this.mPropertiesArray = new Properties[this.mRecordNum];
        for (int rCnt = 0; rCnt < this.mRecordNum; ++rCnt) {
            this.mPayloadArray[rCnt] = (String)payloadDefs.get(rCnt);
            this.mPropertiesArray[rCnt] = (Properties)propertyDefs.get(rCnt);
        }
    }

    @Override
    public void nextLine() {
        this.mCurrentline = this.mRecordNum - 1 > this.mCurrentline ? ++this.mCurrentline : 0;
    }

    @Override
    public String getInputString() {
        return this.mPayloadArray[this.mCurrentline];
    }

    @Override
    public Properties getMessageHeadProp() {
        return this.mPropertiesArray[this.mCurrentline];
    }
}

