/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.proxy.invoker;

import java.io.Serializable;
import java.rmi.RemoteException;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.Invoker;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.keepalive.KeepAliveListener;
import jp.ossc.nimbus.service.proxy.RemoteServerInvoker;
import jp.ossc.nimbus.service.proxy.RemoteServiceCallException;
import jp.ossc.nimbus.service.proxy.invoker.KeepAliveCheckInvoker;
import jp.ossc.nimbus.service.proxy.invoker.RemoteClientMethodCallInvokerServiceMBean;
import jp.ossc.nimbus.service.repository.Repository;

public class RemoteClientMethodCallInvokerService
extends ServiceBase
implements Invoker,
KeepAliveCheckInvoker,
Serializable,
RemoteClientMethodCallInvokerServiceMBean {
    private static final long serialVersionUID = -4617039048036524665L;
    private ServiceName jndiFinderServiceName;
    private JndiFinder jndiFinder;
    private ServiceName jndiRepositoryServiceName;
    private Repository jndiRepository;
    private String jndiName;
    private ServiceName remoteServiceName;

    @Override
    public void setJndiFinderServiceName(ServiceName name) {
        this.jndiFinderServiceName = name;
    }

    @Override
    public ServiceName getJndiFinderServiceName() {
        return this.jndiFinderServiceName;
    }

    @Override
    public void setJndiRepositoryServiceName(ServiceName name) {
        this.jndiRepositoryServiceName = name;
    }

    @Override
    public ServiceName getJndiRepositoryServiceName() {
        return this.jndiRepositoryServiceName;
    }

    @Override
    public void setRemoteServerJndiName(String name) {
        this.jndiName = name;
    }

    @Override
    public String getRemoteServerJndiName() {
        return this.jndiName;
    }

    @Override
    public void setRemoteServiceName(ServiceName name) {
        this.remoteServiceName = name;
    }

    @Override
    public ServiceName getRemoteServiceName() {
        return this.remoteServiceName;
    }

    public void setJndiFinder(JndiFinder jndiFinder) {
        this.jndiFinder = jndiFinder;
    }

    public void setJndiRepository(Repository jndiRepository) {
        this.jndiRepository = jndiRepository;
    }

    @Override
    public void startService() throws Exception {
        if (this.jndiFinderServiceName != null) {
            this.jndiFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.jndiFinderServiceName);
        }
        if (this.jndiRepositoryServiceName != null) {
            this.jndiRepository = (Repository)ServiceManagerFactory.getServiceObject(this.jndiRepositoryServiceName);
        }
        if (this.jndiFinder == null && this.jndiRepository == null) {
            throw new IllegalArgumentException("JndiFinder or JndiRepository must be specified.");
        }
    }

    @Override
    public Object invoke(InvocationContext context) throws Throwable {
        MethodInvocationContext methodContext = (MethodInvocationContext)context;
        try {
            Object target;
            ServiceName serviceName = this.remoteServiceName;
            if (serviceName == null && (target = methodContext.getTargetObject()) != null && target instanceof ServiceName) {
                serviceName = (ServiceName)target;
            }
            if (serviceName != null) {
                methodContext.setTargetObject(serviceName);
            }
            return this.lookupRemoteServerInvoker(serviceName).invoke(context);
        }
        catch (NamingException e) {
            throw new RemoteServiceCallException(e);
        }
        catch (RemoteException e) {
            throw new RemoteServiceCallException(e);
        }
    }

    private RemoteServerInvoker lookupRemoteServerInvoker(ServiceName serviceName) throws NamingException {
        String name = this.jndiName;
        if (name == null && serviceName != null) {
            name = serviceName.getServiceManagerName() + '/' + serviceName.getServiceName();
        }
        if (name == null) {
            throw new IllegalArgumentException("RemoteServerJndiName and RemoteServiceName is null.");
        }
        if (this.jndiFinder != null) {
            return (RemoteServerInvoker)this.jndiFinder.lookup(name);
        }
        return (RemoteServerInvoker)this.jndiRepository.get(name);
    }

    @Override
    public boolean isAlive() {
        try {
            return this.lookupRemoteServerInvoker(this.remoteServiceName).isAlive(this.remoteServiceName);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void addKeepAliveListener(KeepAliveListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeKeepAliveListener(KeepAliveListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearKeepAliveListener() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Comparable getResourceUsage() {
        try {
            return this.lookupRemoteServerInvoker(this.remoteServiceName).getResourceUsage();
        }
        catch (Exception e) {
            return null;
        }
    }
}

