/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler;

import java.util.Date;
import java.util.List;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceBaseSupport;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.ioc.Command;
import jp.ossc.nimbus.ioc.FacadeValue;
import jp.ossc.nimbus.ioc.FacadeValueAccess;
import jp.ossc.nimbus.ioc.UnitOfWork;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.ioccall.FacadeCaller;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.service.scheduler.QueueEntrySchdulerServiceMBean;
import jp.ossc.nimbus.service.sequence.Sequence;

public class QueueEntrySchdulerService
extends ServiceBase
implements QueueEntrySchdulerServiceMBean,
DaemonRunnable {
    private static final long serialVersionUID = -4014975977474880347L;
    private static final String C_REQUEST_ID = "REQUEST_ID";
    private static final String C_USER_ID = "USER_ID";
    private Daemon mSchedulerDaemon = null;
    private ServiceName mFacadeCallServiceName = null;
    private FacadeCaller mFacadeCaller = null;
    private Date mTimerSecounds = new Date();
    private Date mSystemSecounds = null;
    private long mInterval = 60000L;
    private ServiceName mLoggerServiceName = null;
    private Logger mLogger = null;
    private String mFlowKey = null;
    private static final String C_CONSUME_OK = "1";
    private static final String C_CONSUME_NG = "0";
    private ServiceName mSequenceServiceName = null;
    private Sequence mSequence = null;
    private String mUserId = null;

    public QueueEntrySchdulerService() {
    }

    public QueueEntrySchdulerService(ServiceBaseSupport support) {
        super(support);
    }

    @Override
    public void startService() {
        if (this.mFacadeCallServiceName != null) {
            this.mFacadeCaller = (FacadeCaller)ServiceManagerFactory.getServiceObject(this.mFacadeCallServiceName);
        }
        if (this.mFlowKey == null || this.mFlowKey.length() == 0) {
            throw new ServiceException("QueueEntrySchdulerService", "FlowKey is Empty");
        }
        if (this.mLoggerServiceName != null) {
            this.mLogger = (Logger)ServiceManagerFactory.getServiceObject(this.mLoggerServiceName);
        }
        if (this.mSequenceServiceName != null) {
            this.mSequence = (Sequence)ServiceManagerFactory.getServiceObject(this.mSequenceServiceName);
        }
        this.mSchedulerDaemon = new Daemon(this);
        this.mSchedulerDaemon.setDaemon(true);
        this.mSchedulerDaemon.start();
    }

    @Override
    public void stopService() {
        this.mSchedulerDaemon.stop();
        this.mSchedulerDaemon = null;
        this.mFacadeCaller = null;
    }

    @Override
    public void setFacadeServiceName(ServiceName name) {
        this.mFacadeCallServiceName = name;
    }

    @Override
    public ServiceName getFacadeServiceName() {
        return this.mFacadeCallServiceName;
    }

    @Override
    public void setInterval(long msecs) {
        this.mInterval = msecs;
    }

    @Override
    public long getInterval() {
        return this.mInterval;
    }

    @Override
    public void setGetTaskFlowKey(String name) {
        this.mFlowKey = name;
    }

    @Override
    public String getGetTaskFlowKey() {
        return this.mFlowKey;
    }

    @Override
    public void setLogServiceName(ServiceName name) {
        this.mLoggerServiceName = name;
    }

    @Override
    public boolean onStop() {
        return true;
    }

    @Override
    public boolean onSuspend() {
        return true;
    }

    @Override
    public boolean onResume() {
        return true;
    }

    @Override
    public Object provide(DaemonControl ctrl) throws Exception {
        String procFlg = null;
        this.mSystemSecounds = new Date();
        if (this.dateOver(this.mInterval)) {
            procFlg = C_CONSUME_NG;
            try {
                if (this.mLogger != null) {
                    this.mLogger.write("SCH0000200202", (Object)String.valueOf(this.mInterval));
                }
                Thread.sleep(this.mInterval);
            }
            catch (InterruptedException e) {
                return null;
            }
        } else {
            procFlg = C_CONSUME_OK;
            if (this.mLogger != null) {
                this.mLogger.write("SCH0000200202", (Object)String.valueOf(this.mInterval));
            }
        }
        return procFlg;
    }

    private boolean dateOver(long interval) {
        long lngdt2;
        boolean ret = false;
        long lngdt1 = this.mTimerSecounds.getTime() / interval;
        ret = lngdt1 > (lngdt2 = this.mSystemSecounds.getTime() / interval);
        return ret;
    }

    @Override
    public void consume(Object paramObj, DaemonControl ctrl) throws Exception {
        String procFlg;
        if (paramObj == null) {
            return;
        }
        if (this.mLogger != null) {
            this.mLogger.write("SCH0000200301");
        }
        if ((procFlg = (String)paramObj).equals(C_CONSUME_OK)) {
            try {
                if (this.mLogger != null) {
                    this.mLogger.write("SCH0000200302");
                }
                FacadeValue val = FacadeValueAccess.createCommandsValue();
                Command cmd = FacadeValueAccess.createCommand(this.mFlowKey, this.mTimerSecounds);
                val.addCommand(cmd);
                if (this.mUserId != null) {
                    val.putHeader(C_USER_ID, this.mUserId);
                }
                if (this.mSequence != null) {
                    val.putHeader(C_REQUEST_ID, this.mSequence.increment());
                }
                FacadeValue ret = null;
                this.mTimerSecounds = new Date(this.mTimerSecounds.getTime() + this.mInterval);
                ret = this.mFacadeCaller.syncFacadeCall(val);
                Command retcmd = (Command)ret.getCommand(0);
                List ary = (List)retcmd.getOutputObject();
                val = FacadeValueAccess.createCommandsValue();
                if (this.mUserId != null) {
                    val.putHeader(C_USER_ID, this.mUserId);
                }
                if (this.mSequence != null) {
                    val.putHeader(C_REQUEST_ID, this.mSequence.increment());
                }
                for (Command info : ary) {
                    UnitOfWork uw = FacadeValueAccess.createUnitOfWork();
                    uw.addCommand(info);
                    val.addUnitOfWork(uw);
                    if (this.mLogger == null) continue;
                    this.mLogger.write("SCH0000200303", (Object)info.getFlowKey());
                }
                if (val.size() > 0) {
                    this.mFacadeCaller.unsyncFacadeCall(val);
                    if (this.mLogger != null) {
                        this.mLogger.write("SCH0000200304");
                    }
                } else if (this.mLogger != null) {
                    this.mLogger.write("SCH0000200305");
                }
            }
            catch (Exception e) {
                this.mLogger.write("SCH0000200306", e);
                throw e;
            }
        }
    }

    @Override
    public void garbage() {
    }

    @Override
    public boolean onStart() {
        return true;
    }

    @Override
    public ServiceName getSequenceServiceName() {
        return this.mSequenceServiceName;
    }

    @Override
    public String getUserId() {
        return this.mUserId;
    }

    @Override
    public void setSequenceServiceName(ServiceName name) {
        this.mSequenceServiceName = name;
    }

    @Override
    public void setUserId(String string) {
        this.mUserId = string;
    }

    public void setFacadeCaller(FacadeCaller facadeCaller) {
        this.mFacadeCaller = facadeCaller;
    }

    @Override
    public void setLogger(Logger logger) {
        this.mLogger = logger;
    }

    public void setSequence(Sequence sequence) {
        this.mSequence = sequence;
    }
}

