/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler2;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jp.ossc.nimbus.io.CSVReader;
import jp.ossc.nimbus.service.scheduler2.AbstractScheduleExecutorService;
import jp.ossc.nimbus.service.scheduler2.CommandScheduleExecutorServiceMBean;
import jp.ossc.nimbus.service.scheduler2.Schedule;
import jp.ossc.nimbus.service.scheduler2.ScheduleStateControlException;

public class CommandScheduleExecutorService
extends AbstractScheduleExecutorService
implements CommandScheduleExecutorServiceMBean {
    private static final long serialVersionUID = -3986953305707553467L;
    protected String workDirectoryPath;
    protected String[] environmentVariables;
    protected Map threadMap;

    public CommandScheduleExecutorService() {
        this.type = "COMMAND";
    }

    @Override
    public void setWorkDirectory(String path) {
        this.workDirectoryPath = path;
    }

    @Override
    public String getWorkDirectory() {
        return this.workDirectoryPath;
    }

    @Override
    public void setEnvironmentVariables(String[] env) {
        this.environmentVariables = env;
    }

    @Override
    public String[] getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Override
    public void createService() throws Exception {
        this.threadMap = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public void destroyService() throws Exception {
        this.threadMap = null;
    }

    @Override
    protected void checkPreExecute(Schedule schedule) throws Exception {
        Object input = schedule.getInput();
        if (input == null) {
            throw new IllegalArgumentException("Command is null.");
        }
        if (!(input instanceof String)) {
            throw new IllegalArgumentException("Input is not String. type=" + input.getClass().getName());
        }
        if (((String)input).length() == 0) {
            throw new IllegalArgumentException("Command is empty.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Schedule executeInternal(Schedule schedule) throws Throwable {
        block13: {
            this.threadMap.put(schedule.getId(), Thread.currentThread());
            String[] commands = CSVReader.toArray((String)schedule.getInput(), ',', '\\', '\"', "", null, true, false, true, false);
            boolean isWait = true;
            if (commands.length > 1 && "&".equals(commands[commands.length - 1])) {
                isWait = false;
                String[] tmpCommands = new String[commands.length - 1];
                System.arraycopy(commands, 0, tmpCommands, 0, tmpCommands.length);
                commands = tmpCommands;
            }
            Runtime runtime = Runtime.getRuntime();
            Process proc = runtime.exec(commands, this.environmentVariables, this.workDirectoryPath == null ? null : new File(this.workDirectoryPath));
            if (!isWait) break block13;
            InputStreamThread stdStreamThread = new InputStreamThread(proc.getInputStream());
            InputStreamThread errStreamThread = new InputStreamThread(proc.getErrorStream());
            stdStreamThread.start();
            errStreamThread.start();
            int exitCode = 0;
            try {
                exitCode = proc.waitFor();
                stdStreamThread.join();
                errStreamThread.join();
            }
            catch (InterruptedException e) {
                schedule.setState(5);
                schedule.setOutput("Waiting for a response of command, it is interrupted.");
                Schedule schedule2 = schedule;
                return schedule2;
            }
            finally {
                this.threadMap.remove(schedule.getId());
            }
            if (exitCode == 0) {
                schedule.setOutput(stdStreamThread.getResult());
                break block13;
            }
            schedule.setState(5);
            StringBuffer buf = new StringBuffer();
            buf.append("ExitCode=").append(exitCode);
            if (errStreamThread.getResult() != null) {
                buf.append(", err=").append(errStreamThread.getResult());
            }
            if (stdStreamThread.getResult() != null) {
                buf.append(", std=").append(stdStreamThread.getResult());
            }
            schedule.setOutput(buf.toString());
            break block13;
            finally {
                this.threadMap.remove(schedule.getId());
            }
        }
        return schedule;
    }

    @Override
    public boolean controlState(String id, int cntrolState) throws ScheduleStateControlException {
        Thread thread;
        if (cntrolState == 4 && (thread = (Thread)this.threadMap.get(id)) != null) {
            thread.interrupt();
            return true;
        }
        return false;
    }

    private class InputStreamThread
    extends Thread {
        private BufferedReader br;
        private String result;

        public InputStreamThread(InputStream is) {
            this.br = new BufferedReader(new InputStreamReader(is));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                String line = null;
                while ((line = this.br.readLine()) != null) {
                    pw.println(line);
                }
                this.result = sw.toString();
            }
            catch (IOException e) {
            }
            finally {
                try {
                    this.br.close();
                    this.br = null;
                }
                catch (IOException e) {}
            }
        }

        public String getResult() {
            return this.result;
        }
    }
}

