/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.ConnectionFactoryException;
import jp.ossc.nimbus.service.keepalive.ClusterService;
import jp.ossc.nimbus.service.scheduler2.DatabaseScheduleManagerServiceMBean;
import jp.ossc.nimbus.service.scheduler2.DefaultSchedule;
import jp.ossc.nimbus.service.scheduler2.DefaultScheduleMakerService;
import jp.ossc.nimbus.service.scheduler2.DefaultScheduleMaster;
import jp.ossc.nimbus.service.scheduler2.Schedule;
import jp.ossc.nimbus.service.scheduler2.ScheduleControlListener;
import jp.ossc.nimbus.service.scheduler2.ScheduleMakeException;
import jp.ossc.nimbus.service.scheduler2.ScheduleMaker;
import jp.ossc.nimbus.service.scheduler2.ScheduleManageException;
import jp.ossc.nimbus.service.scheduler2.ScheduleManager;
import jp.ossc.nimbus.service.scheduler2.ScheduleMaster;
import jp.ossc.nimbus.service.scheduler2.ScheduleStateControlException;
import jp.ossc.nimbus.service.sequence.Sequence;

public class DatabaseScheduleManagerService
extends ServiceBase
implements ScheduleManager,
DatabaseScheduleManagerServiceMBean {
    private static final long serialVersionUID = -768179222440496616L;
    protected Properties scheduleMakerTypeMapping;
    protected Map addedScheduleMakerMap;
    protected Map scheduleMakerMap;
    protected boolean isScheduleMakerTypeRegexEnabled;
    protected ServiceName defaultScheduleMakerServiceName;
    protected ScheduleMaker defaultScheduleMaker;
    protected ServiceName connectionFactoryServiceName;
    protected ConnectionFactory connectionFactory;
    protected ScheduleMasterTableSchema scheduleMasterTableSchema = new ScheduleMasterTableSchema();
    protected ScheduleDependsMasterTableSchema scheduleDependsMasterTableSchema = new ScheduleDependsMasterTableSchema();
    protected ScheduleTableSchema scheduleTableSchema = new ScheduleTableSchema();
    protected ScheduleDependsTableSchema scheduleDependsTableSchema = new ScheduleDependsTableSchema();
    protected String nextScheduleIdSelectQuery;
    protected String dateFormat = "yyyyMMdd";
    protected String timeFormat = "HHmmssSSS";
    protected String updateUserId;
    protected Set scheduleControlListeners;
    protected boolean isMakeScheduleOnStart = true;
    protected long controlStateCheckInterval = 1000L;
    protected Daemon controlStateChecker;
    protected long timeoverCheckInterval = 1000L;
    protected Daemon timeoverChecker;
    protected boolean isLockForFindExecutable;
    protected ServiceName clusterServiceName;
    protected ClusterService cluster;
    protected ClusterListener clusterListener;
    protected ServiceName sequenceServiceName;
    protected Sequence sequence;
    protected boolean isUseConcatFunction;

    @Override
    public void setDefaultScheduleMakerServiceName(ServiceName name) {
        this.defaultScheduleMakerServiceName = name;
    }

    @Override
    public ServiceName getDefaultScheduleMakerServiceName() {
        return this.defaultScheduleMakerServiceName;
    }

    @Override
    public void setScheduleMakerTypeMapping(Properties mapping) {
        this.scheduleMakerTypeMapping = mapping;
    }

    @Override
    public Properties getScheduleMakerTypeMapping() {
        return this.scheduleMakerTypeMapping;
    }

    @Override
    public void setScheduleMakerTypeRegexEnabled(boolean isEnable) {
        this.isScheduleMakerTypeRegexEnabled = isEnable;
    }

    @Override
    public boolean isScheduleMakerTypeRegexEnabled() {
        return this.isScheduleMakerTypeRegexEnabled;
    }

    @Override
    public void setConnectionFactoryServiceName(ServiceName name) {
        this.connectionFactoryServiceName = name;
    }

    @Override
    public ServiceName getConnectionFactoryServiceName() {
        return this.connectionFactoryServiceName;
    }

    @Override
    public void setDateFormat(String format) {
        this.dateFormat = format;
    }

    @Override
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public void setTimeFormat(String format) {
        this.timeFormat = format;
    }

    @Override
    public String getTimeFormat() {
        return this.timeFormat;
    }

    @Override
    public void setUpdateUserId(String id) {
        this.updateUserId = id;
    }

    @Override
    public String getUpdateUserId() {
        return this.updateUserId;
    }

    @Override
    public ScheduleMasterTableSchema getScheduleMasterTableSchema() {
        return this.scheduleMasterTableSchema;
    }

    @Override
    public void setScheduleMasterTableSchema(ScheduleMasterTableSchema schema) {
        this.scheduleMasterTableSchema = schema;
    }

    @Override
    public ScheduleDependsMasterTableSchema getScheduleDependsMasterTableSchema() {
        return this.scheduleDependsMasterTableSchema;
    }

    @Override
    public void setScheduleDependsMasterTableSchema(ScheduleDependsMasterTableSchema schema) {
        this.scheduleDependsMasterTableSchema = schema;
    }

    @Override
    public ScheduleTableSchema getScheduleTableSchema() {
        return this.scheduleTableSchema;
    }

    @Override
    public void setScheduleTableSchema(ScheduleTableSchema schema) {
        this.scheduleTableSchema = schema;
    }

    @Override
    public ScheduleDependsTableSchema getScheduleDependsTableSchema() {
        return this.scheduleDependsTableSchema;
    }

    @Override
    public void setScheduleDependsTableSchema(ScheduleDependsTableSchema schema) {
        this.scheduleDependsTableSchema = schema;
    }

    @Override
    public void setNextScheduleIdSelectQuery(String query) {
        this.nextScheduleIdSelectQuery = query;
    }

    @Override
    public String getNextScheduleIdSelectQuery() {
        return this.nextScheduleIdSelectQuery;
    }

    @Override
    public void setMakeScheduleOnStart(boolean isMake) {
        this.isMakeScheduleOnStart = isMake;
    }

    @Override
    public boolean isMakeScheduleOnStart() {
        return this.isMakeScheduleOnStart;
    }

    @Override
    public void setControlStateCheckInterval(long interval) {
        this.controlStateCheckInterval = interval;
    }

    @Override
    public long getControlStateCheckInterval() {
        return this.controlStateCheckInterval;
    }

    @Override
    public void setTimeoverCheckInterval(long interval) {
        this.timeoverCheckInterval = interval;
    }

    @Override
    public long getTimeoverCheckInterval() {
        return this.timeoverCheckInterval;
    }

    @Override
    public void setLockForFindExecutable(boolean isLock) {
        this.isLockForFindExecutable = isLock;
    }

    @Override
    public boolean isLockForFindExecutable() {
        return this.isLockForFindExecutable;
    }

    @Override
    public void setClusterServiceName(ServiceName name) {
        this.clusterServiceName = name;
    }

    @Override
    public ServiceName getClusterServiceName() {
        return this.clusterServiceName;
    }

    @Override
    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    @Override
    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    @Override
    public void setUseConcatFunction(boolean isUse) {
        this.isUseConcatFunction = isUse;
    }

    @Override
    public boolean isUseConcatFunction() {
        return this.isUseConcatFunction;
    }

    @Override
    public void createService() throws Exception {
        this.scheduleMakerMap = new HashMap();
        this.addedScheduleMakerMap = null;
        this.scheduleControlListeners = Collections.synchronizedSet(new LinkedHashSet());
    }

    @Override
    public void startService() throws Exception {
        Date now;
        List oldScheduleList;
        if (this.scheduleMakerTypeMapping != null && this.scheduleMakerTypeMapping.size() != 0) {
            ServiceNameEditor editor = new ServiceNameEditor();
            editor.setServiceManagerName(this.getServiceManagerName());
            for (Map.Entry<Object, Object> entry : this.scheduleMakerTypeMapping.entrySet()) {
                editor.setAsText((String)entry.getValue());
                ServiceName scheduleMakerServiceName = (ServiceName)editor.getValue();
                ScheduleMaker scheduleMaker = (ScheduleMaker)ServiceManagerFactory.getServiceObject(scheduleMakerServiceName);
                if (this.scheduleMakerMap.containsKey(entry.getKey())) {
                    throw new IllegalArgumentException("Dupulicate scheduleMakerTypeMapping : " + entry.getKey());
                }
                this.scheduleMakerMap.put(entry.getKey(), scheduleMaker);
            }
        }
        if (this.defaultScheduleMakerServiceName != null) {
            this.defaultScheduleMaker = (ScheduleMaker)ServiceManagerFactory.getServiceObject(this.defaultScheduleMakerServiceName);
        }
        if (this.defaultScheduleMaker == null) {
            DefaultScheduleMakerService defaultScheduleMakerService = new DefaultScheduleMakerService();
            defaultScheduleMakerService.create();
            defaultScheduleMakerService.start();
            this.defaultScheduleMaker = defaultScheduleMakerService;
        }
        if (this.connectionFactoryServiceName != null) {
            this.connectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(this.connectionFactoryServiceName);
        }
        if (this.connectionFactory == null) {
            throw new IllegalArgumentException("ConnectionFactory is null.");
        }
        if (this.sequenceServiceName != null) {
            this.sequence = (Sequence)ServiceManagerFactory.getServiceObject(this.sequenceServiceName);
        }
        if (this.updateUserId == null) {
            this.updateUserId = InetAddress.getLocalHost().getHostName();
        }
        SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
        format.applyPattern(this.timeFormat);
        if (this.isMakeScheduleOnStart && ((oldScheduleList = this.findSchedules(now = new Date())) == null || oldScheduleList.size() == 0)) {
            this.makeSchedule(now);
        }
        if (this.controlStateCheckInterval > 0L && this.scheduleControlListeners != null && this.scheduleControlListeners.size() != 0) {
            this.controlStateChecker = new Daemon(new ControlStateChecker());
            this.controlStateChecker.setName("Nimbus SchedulerManagerControlStateChecker " + this.getServiceNameObject());
            this.controlStateChecker.suspend();
            this.controlStateChecker.start();
        }
        if (this.timeoverCheckInterval > 0L) {
            this.timeoverChecker = new Daemon(new TimeoverChecker());
            this.timeoverChecker.setName("Nimbus SchedulerManagerTimeoverChecker " + this.getServiceNameObject());
            this.timeoverChecker.suspend();
            this.timeoverChecker.start();
        }
        if (this.clusterServiceName != null && (this.controlStateChecker != null || this.timeoverChecker != null)) {
            this.cluster = (ClusterService)ServiceManagerFactory.getServiceObject(this.clusterServiceName);
            this.clusterListener = new ClusterListener();
            this.cluster.addClusterListener(this.clusterListener);
        } else {
            if (this.controlStateChecker != null) {
                this.controlStateChecker.resume();
            }
            if (this.timeoverChecker != null) {
                this.timeoverChecker.resume();
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.controlStateChecker != null) {
            this.controlStateChecker.stop();
        }
        if (this.timeoverChecker != null) {
            this.timeoverChecker.stop();
        }
        if (this.cluster != null) {
            this.cluster.removeClusterListener(this.clusterListener);
            this.clusterListener = null;
            this.cluster = null;
        }
        if (this.scheduleMakerMap != null) {
            this.scheduleMakerMap.clear();
        }
    }

    @Override
    public void destroyService() throws Exception {
        this.scheduleMakerMap = null;
        this.addedScheduleMakerMap = null;
        this.scheduleControlListeners = null;
    }

    @Override
    public void makeSchedule(Date date) throws ScheduleMakeException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleMakeException(e);
        }
        Statement st1 = null;
        Statement st2 = null;
        Statement ps1 = null;
        Statement ps2 = null;
        ResultSet rs = null;
        try {
            Set dependsIdSet;
            HashMap<String, HashSet<String>> dependsMasterMap = new HashMap<String, HashSet<String>>();
            st1 = con.createStatement();
            rs = st1.executeQuery("select * from " + this.scheduleDependsMasterTableSchema.table);
            while (rs.next()) {
                String id = rs.getString(this.scheduleDependsMasterTableSchema.id);
                dependsIdSet = (HashSet<String>)dependsMasterMap.get(id);
                if (dependsIdSet == null) {
                    dependsIdSet = new HashSet<String>();
                    dependsMasterMap.put(id, (HashSet<String>)dependsIdSet);
                }
                dependsIdSet.add(rs.getString(this.scheduleDependsMasterTableSchema.dependsId));
            }
            rs.close();
            rs = null;
            rs = st1.executeQuery("select * from " + this.scheduleMasterTableSchema.table);
            st2 = con.createStatement();
            ps1 = con.prepareStatement("insert into " + this.scheduleTableSchema.table + " (" + this.scheduleTableSchema.id + ',' + this.scheduleTableSchema.masterId + ',' + this.scheduleTableSchema.date + ',' + this.scheduleTableSchema.time + ',' + this.scheduleTableSchema.taskName + ',' + this.scheduleTableSchema.input + ',' + this.scheduleTableSchema.output + ',' + this.scheduleTableSchema.initialDate + ',' + this.scheduleTableSchema.initialTime + ',' + this.scheduleTableSchema.retryInterval + ',' + this.scheduleTableSchema.retryEndTime + ',' + this.scheduleTableSchema.maxDelayTime + ',' + this.scheduleTableSchema.state + ',' + this.scheduleTableSchema.controlState + ',' + this.scheduleTableSchema.checkState + ',' + this.scheduleTableSchema.executorKey + ',' + this.scheduleTableSchema.executorType + ',' + this.scheduleTableSchema.executeStartTime + ',' + this.scheduleTableSchema.executeEndTime + ',' + this.scheduleTableSchema.rowVersion + ',' + this.scheduleTableSchema.updateUserId + ',' + this.scheduleTableSchema.updateTime + ") values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,'0','" + this.updateUserId + "',?)");
            ps2 = con.prepareStatement("insert into " + this.scheduleDependsTableSchema.table + " (" + this.scheduleDependsTableSchema.id + ',' + this.scheduleDependsTableSchema.dependsId + ',' + this.scheduleDependsTableSchema.rowVersion + ',' + this.scheduleDependsTableSchema.updateUserId + ',' + this.scheduleDependsTableSchema.updateTime + ") values(?,?,'0','" + this.updateUserId + "',?)");
            while (rs.next()) {
                Schedule[] schedules;
                DefaultScheduleMaster scheduleMaster = this.createScheduleMaster(rs);
                dependsIdSet = (Set)dependsMasterMap.get(scheduleMaster.getId());
                if (dependsIdSet != null) {
                    scheduleMaster.setDepends(dependsIdSet.toArray(new String[dependsIdSet.size()]));
                }
                ScheduleMaker maker = this.getScheduleMaker(scheduleMaster.getScheduleType());
                if (!scheduleMaster.isEnabled() || (schedules = maker.makeSchedule(date, scheduleMaster)) == null || schedules.length == 0) continue;
                for (int i = 0; i < schedules.length; ++i) {
                    this.addSchedule(st2, (PreparedStatement)ps1, (PreparedStatement)ps2, schedules[i]);
                }
            }
        }
        catch (ScheduleManageException e) {
            throw new ScheduleMakeException(e);
        }
        catch (ParseException e) {
            throw new ScheduleMakeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ScheduleMakeException(e);
        }
        catch (IOException e) {
            throw new ScheduleMakeException(e);
        }
        catch (SQLException e) {
            throw new ScheduleMakeException(e);
        }
        finally {
            if (st1 != null) {
                try {
                    st1.close();
                }
                catch (SQLException e) {}
            }
            if (st2 != null) {
                try {
                    st2.close();
                }
                catch (SQLException e) {}
            }
            if (ps1 != null) {
                try {
                    ps1.close();
                }
                catch (SQLException e) {}
            }
            if (ps2 != null) {
                try {
                    ps2.close();
                }
                catch (SQLException e) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    protected void addSchedule(Schedule schedule, boolean isCreateId) throws ScheduleManageException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        Statement ps1 = null;
        Statement ps2 = null;
        try {
            if (isCreateId) {
                st = con.createStatement();
            }
            ps1 = con.prepareStatement("insert into " + this.scheduleTableSchema.table + " (" + this.scheduleTableSchema.id + ',' + this.scheduleTableSchema.masterId + ',' + this.scheduleTableSchema.date + ',' + this.scheduleTableSchema.time + ',' + this.scheduleTableSchema.taskName + ',' + this.scheduleTableSchema.input + ',' + this.scheduleTableSchema.output + ',' + this.scheduleTableSchema.initialDate + ',' + this.scheduleTableSchema.initialTime + ',' + this.scheduleTableSchema.retryInterval + ',' + this.scheduleTableSchema.retryEndTime + ',' + this.scheduleTableSchema.maxDelayTime + ',' + this.scheduleTableSchema.state + ',' + this.scheduleTableSchema.controlState + ',' + this.scheduleTableSchema.checkState + ',' + this.scheduleTableSchema.executorKey + ',' + this.scheduleTableSchema.executorType + ',' + this.scheduleTableSchema.executeStartTime + ',' + this.scheduleTableSchema.executeEndTime + ',' + this.scheduleTableSchema.rowVersion + ',' + this.scheduleTableSchema.updateUserId + ',' + this.scheduleTableSchema.updateTime + ") values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,'0','" + this.updateUserId + "',?)");
            ps2 = con.prepareStatement("insert into " + this.scheduleDependsTableSchema.table + " (" + this.scheduleDependsTableSchema.id + ',' + this.scheduleDependsTableSchema.dependsId + ',' + this.scheduleDependsTableSchema.rowVersion + ',' + this.scheduleDependsTableSchema.updateUserId + ',' + this.scheduleDependsTableSchema.updateTime + ") values(?,?,'0','" + this.updateUserId + "',?)");
            this.addSchedule(st, (PreparedStatement)ps1, (PreparedStatement)ps2, schedule);
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
            if (ps1 != null) {
                try {
                    ps1.close();
                }
                catch (SQLException e) {}
            }
            if (ps2 != null) {
                try {
                    ps2.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    protected void addSchedule(Statement nextScheduleIdStatement, PreparedStatement scheduleInsertStatement, PreparedStatement scheduleDependsInsertStatement, Schedule schedule) throws ScheduleManageException {
        ResultSet rs = null;
        try {
            Date initialTime;
            if (this.nextScheduleIdSelectQuery != null) {
                rs = nextScheduleIdStatement.executeQuery(this.nextScheduleIdSelectQuery);
                rs.next();
                schedule.setId(rs.getObject(1).toString());
                rs.close();
                rs = null;
            } else if (this.sequence != null) {
                schedule.setId(this.sequence.increment());
            }
            scheduleInsertStatement.setString(1, schedule.getId());
            scheduleInsertStatement.setString(2, schedule.getMasterId());
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
            if (schedule.getTime() == null) {
                scheduleInsertStatement.setNull(3, 1);
            } else {
                scheduleInsertStatement.setString(3, format.format(schedule.getTime()));
            }
            format.applyPattern(this.timeFormat);
            if (schedule.getTime() == null) {
                scheduleInsertStatement.setNull(4, 1);
            } else {
                scheduleInsertStatement.setString(4, format.format(schedule.getTime()));
            }
            scheduleInsertStatement.setString(5, schedule.getTaskName());
            if (schedule.getInput() == null) {
                scheduleInsertStatement.setNull(6, 12);
            } else {
                this.scheduleTableSchema.setInputObject(6, scheduleInsertStatement, schedule.getInput());
            }
            if (schedule.getOutput() == null) {
                scheduleInsertStatement.setNull(7, 12);
            } else {
                this.scheduleTableSchema.setOutputObject(7, scheduleInsertStatement, schedule.getOutput());
            }
            format.applyPattern(this.dateFormat);
            Date date = initialTime = schedule.getInitialTime() == null ? schedule.getTime() : schedule.getInitialTime();
            if (initialTime == null) {
                scheduleInsertStatement.setNull(8, 1);
            } else {
                scheduleInsertStatement.setString(8, format.format(initialTime));
            }
            format.applyPattern(this.timeFormat);
            if (initialTime == null) {
                scheduleInsertStatement.setNull(9, 1);
            } else {
                scheduleInsertStatement.setString(9, format.format(initialTime));
            }
            if (schedule.getRetryInterval() > 0L) {
                scheduleInsertStatement.setLong(10, schedule.getRetryInterval());
            } else {
                scheduleInsertStatement.setNull(10, 3);
            }
            format.applyPattern(this.dateFormat + this.timeFormat);
            if (schedule.getRetryEndTime() == null) {
                scheduleInsertStatement.setNull(11, 1);
            } else {
                scheduleInsertStatement.setString(11, format.format(schedule.getRetryEndTime()));
            }
            if (schedule.getMaxDelayTime() > 0L) {
                scheduleInsertStatement.setLong(12, schedule.getMaxDelayTime());
            } else {
                scheduleInsertStatement.setNull(12, 3);
            }
            scheduleInsertStatement.setString(13, this.scheduleTableSchema.getStateString(schedule.getState()));
            scheduleInsertStatement.setString(14, this.scheduleTableSchema.getControlStateString(schedule.getControlState()));
            scheduleInsertStatement.setString(15, this.scheduleTableSchema.getCheckStateString(schedule.getCheckState()));
            if (schedule.getExecutorKey() == null) {
                scheduleInsertStatement.setNull(16, 12);
            } else {
                scheduleInsertStatement.setString(16, schedule.getExecutorKey());
            }
            if (schedule.getExecutorType() == null) {
                scheduleInsertStatement.setNull(17, 12);
            } else {
                scheduleInsertStatement.setString(17, schedule.getExecutorType());
            }
            if (schedule.getExecuteStartTime() == null) {
                scheduleInsertStatement.setNull(18, 1);
            } else {
                scheduleInsertStatement.setString(18, format.format(schedule.getExecuteStartTime()));
            }
            if (schedule.getExecuteEndTime() == null) {
                scheduleInsertStatement.setNull(19, 1);
            } else {
                scheduleInsertStatement.setString(19, format.format(schedule.getExecuteEndTime()));
            }
            Timestamp now = new Timestamp(System.currentTimeMillis());
            scheduleInsertStatement.setTimestamp(20, now);
            scheduleInsertStatement.executeUpdate();
            String[] depends = schedule.getDepends();
            if (depends != null && depends.length != 0) {
                if (scheduleDependsInsertStatement == null) {
                    throw new ScheduleManageException("ScheduleDependsInsertQuery is null.");
                }
                for (int i = 0; i < depends.length; ++i) {
                    scheduleDependsInsertStatement.setString(1, schedule.getId());
                    scheduleDependsInsertStatement.setString(2, depends[i]);
                    scheduleDependsInsertStatement.setTimestamp(3, now);
                    scheduleDependsInsertStatement.executeUpdate();
                }
            }
        }
        catch (IOException e) {
            throw new ScheduleManageException(e);
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    public void setScheduleMaker(String scheduleType, ScheduleMaker maker) throws IllegalArgumentException {
        if (this.addedScheduleMakerMap == null) {
            this.addedScheduleMakerMap = new HashMap();
        }
        if (this.addedScheduleMakerMap.containsKey(scheduleType)) {
            throw new IllegalArgumentException("Dupulicate scheduleType : " + scheduleType);
        }
        this.addedScheduleMakerMap.put(scheduleType, maker);
    }

    @Override
    public ScheduleMaker getScheduleMaker(String scheduleType) {
        ScheduleMaker maker = (ScheduleMaker)this.scheduleMakerMap.get(scheduleType);
        if (this.isScheduleMakerTypeRegexEnabled && maker == null) {
            for (Map.Entry entry : this.scheduleMakerMap.entrySet()) {
                String key = (String)entry.getKey();
                try {
                    if (!Pattern.matches(key, scheduleType)) continue;
                    maker = (ScheduleMaker)entry.getValue();
                    break;
                }
                catch (PatternSyntaxException e) {
                }
            }
        }
        if (maker == null) {
            maker = this.defaultScheduleMaker;
        }
        return maker;
    }

    @Override
    public void setDefaultScheduleMaker(ScheduleMaker maker) {
        this.defaultScheduleMaker = maker;
    }

    @Override
    public ScheduleMaker getDefaultScheduleMaker() {
        return this.defaultScheduleMaker;
    }

    @Override
    public List findAllScheduleMasters() throws ScheduleManageException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        Statement ps1 = null;
        Statement ps2 = null;
        ResultSet rs = null;
        ArrayList<DefaultScheduleMaster> result = new ArrayList<DefaultScheduleMaster>();
        try {
            Set dependsIdSet;
            HashMap<String, HashSet<String>> dependsMasterMap = new HashMap<String, HashSet<String>>();
            st = con.createStatement();
            rs = st.executeQuery("select * from " + this.scheduleDependsMasterTableSchema.table);
            while (rs.next()) {
                String id = rs.getString(this.scheduleDependsMasterTableSchema.id);
                dependsIdSet = (HashSet<String>)dependsMasterMap.get(id);
                if (dependsIdSet == null) {
                    dependsIdSet = new HashSet<String>();
                    dependsMasterMap.put(id, (HashSet<String>)dependsIdSet);
                }
                dependsIdSet.add(rs.getString(this.scheduleDependsMasterTableSchema.dependsId));
            }
            rs.close();
            rs = null;
            rs = st.executeQuery("select * from " + this.scheduleMasterTableSchema.table);
            while (rs.next()) {
                DefaultScheduleMaster scheduleMaster = this.createScheduleMaster(rs);
                dependsIdSet = (Set)dependsMasterMap.get(scheduleMaster.getId());
                if (dependsIdSet != null) {
                    scheduleMaster.setDepends(dependsIdSet.toArray(new String[dependsIdSet.size()]));
                }
                result.add(scheduleMaster);
            }
        }
        catch (ScheduleManageException e) {
            throw new ScheduleMakeException(e);
        }
        catch (ParseException e) {
            throw new ScheduleMakeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ScheduleMakeException(e);
        }
        catch (IOException e) {
            throw new ScheduleMakeException(e);
        }
        catch (SQLException e) {
            throw new ScheduleMakeException(e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
            if (ps1 != null) {
                try {
                    ps1.close();
                }
                catch (SQLException e) {}
            }
            if (ps2 != null) {
                try {
                    ps2.close();
                }
                catch (SQLException e) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
        return result;
    }

    @Override
    public ScheduleMaster findScheduleMaster(String id) throws ScheduleManageException {
        ScheduleMaster scheduleMaster;
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement("select * from " + this.scheduleMasterTableSchema.table + " where " + this.scheduleMasterTableSchema.id + "=?");
            st.setString(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                ScheduleMaster scheduleMaster2 = null;
                return scheduleMaster2;
            }
            scheduleMaster = this.setDependsOnScheduleMaster(con, this.createScheduleMaster(rs));
        }
        catch (ParseException e) {
            throw new ScheduleManageException(e);
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        catch (IOException e) {
            throw new ScheduleManageException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
        return scheduleMaster;
    }

    protected DefaultScheduleMaster createScheduleMaster(ResultSet rs) throws SQLException, ParseException, IOException, ClassNotFoundException {
        SimpleDateFormat timeFormatter = new SimpleDateFormat(this.timeFormat);
        DefaultScheduleMaster scheduleMaster = new DefaultScheduleMaster();
        scheduleMaster.setId(rs.getString(this.scheduleMasterTableSchema.id));
        scheduleMaster.setTaskName(rs.getString(this.scheduleMasterTableSchema.taskName));
        scheduleMaster.setScheduleType(rs.getString(this.scheduleMasterTableSchema.scheduleType));
        scheduleMaster.setInput(this.scheduleMasterTableSchema.getInputObject(rs));
        String str = rs.getString(this.scheduleMasterTableSchema.startTime);
        if (str != null) {
            scheduleMaster.setStartTime(timeFormatter.parse(str));
        }
        if ((str = rs.getString(this.scheduleMasterTableSchema.endTime)) != null) {
            scheduleMaster.setEndTime(timeFormatter.parse(str));
        }
        long longVal = rs.getLong(this.scheduleMasterTableSchema.repeatInterval);
        if (!rs.wasNull()) {
            scheduleMaster.setRepeatInterval(longVal);
        }
        longVal = rs.getLong(this.scheduleMasterTableSchema.retryInterval);
        if (!rs.wasNull()) {
            scheduleMaster.setRetryInterval(longVal);
        }
        if ((str = rs.getString(this.scheduleMasterTableSchema.retryEndTime)) != null) {
            scheduleMaster.setRetryEndTime(timeFormatter.parse(str));
        }
        longVal = rs.getLong(this.scheduleMasterTableSchema.maxDelayTime);
        if (!rs.wasNull()) {
            scheduleMaster.setMaxDelayTime(longVal);
        }
        scheduleMaster.setExecutorKey(rs.getString(this.scheduleMasterTableSchema.executorKey));
        scheduleMaster.setExecutorType(rs.getString(this.scheduleMasterTableSchema.executorType));
        Object obj = rs.getObject(this.scheduleMasterTableSchema.enable);
        boolean isEnabled = true;
        isEnabled = obj instanceof Boolean ? (Boolean)obj : (obj instanceof Number ? ((Number)obj).intValue() != 0 : (obj == null ? false : Boolean.valueOf(obj.toString())));
        scheduleMaster.setEnabled(isEnabled);
        return scheduleMaster;
    }

    protected ScheduleMaster setDependsOnScheduleMaster(Connection con, ScheduleMaster schedule) throws SQLException {
        ArrayList<ScheduleMaster> tmp = new ArrayList<ScheduleMaster>();
        tmp.add(schedule);
        this.setDependsOnScheduleMasters(con, tmp);
        return (ScheduleMaster)tmp.get(0);
    }

    protected List setDependsOnScheduleMasters(Connection con, List schedules) throws SQLException {
        if (schedules.size() == 0) {
            return schedules;
        }
        StringBuffer buf = new StringBuffer();
        Statement st = con.createStatement();
        ResultSet rs = null;
        HashMap<String, ScheduleMaster> scheduleMap = new HashMap<String, ScheduleMaster>();
        HashMap<String, ArrayList<String>> scheduleDependsMap = new HashMap<String, ArrayList<String>>();
        int to = schedules.size() % 1000 == 0 ? schedules.size() / 1000 : schedules.size() / 1000 + 1;
        for (int i = 0; i < to; ++i) {
            ScheduleMaster schedule;
            int startIndex;
            scheduleMap.clear();
            scheduleDependsMap.clear();
            buf.setLength(0);
            buf.append("select * from ");
            buf.append(this.scheduleDependsMasterTableSchema.table);
            buf.append(" where ");
            buf.append(this.scheduleDependsMasterTableSchema.id);
            buf.append(" in (");
            int jmax = Math.min(startIndex + 1000, schedules.size());
            for (int j = startIndex = i * 1000; j < jmax; ++j) {
                schedule = (ScheduleMaster)schedules.get(j);
                buf.append('\'').append(schedule.getId()).append('\'');
                if (j != jmax - 1) {
                    buf.append(',');
                }
                scheduleMap.put(schedule.getId(), schedule);
            }
            buf.append(')');
            rs = st.executeQuery(buf.toString());
            while (rs.next()) {
                String id = rs.getString(this.scheduleDependsMasterTableSchema.id);
                ArrayList<String> depends = (ArrayList<String>)scheduleDependsMap.get(id);
                if (depends == null) {
                    depends = new ArrayList<String>();
                    scheduleDependsMap.put(id, depends);
                }
                depends.add(rs.getString(this.scheduleDependsMasterTableSchema.dependsId));
            }
            for (Map.Entry entry : scheduleDependsMap.entrySet()) {
                schedule = (DefaultScheduleMaster)scheduleMap.get(entry.getKey());
                List depends = (List)entry.getValue();
                if (depends.size() == 0) continue;
                ((DefaultScheduleMaster)schedule).setDepends(depends.toArray(new String[depends.size()]));
            }
            rs.close();
        }
        return schedules;
    }

    @Override
    public List findAllSchedules() throws ScheduleManageException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.createStatement();
            rs = st.executeQuery("select * from " + this.scheduleTableSchema.table);
            ArrayList<Schedule> result = new ArrayList<Schedule>();
            while (rs.next()) {
                result.add(this.createSchedule(rs));
            }
            this.setDependsOnSchedules(con, result);
            ArrayList<Schedule> arrayList = result;
            return arrayList;
        }
        catch (ParseException e) {
            throw new ScheduleManageException(e);
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        catch (IOException e) {
            throw new ScheduleManageException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    protected Schedule createSchedule(ResultSet rs) throws SQLException, ParseException, IOException, ClassNotFoundException {
        String executeEndTimeStr;
        String retryEndTimeStr;
        DefaultSchedule schedule = new DefaultSchedule();
        schedule.setId(rs.getString(this.scheduleTableSchema.id));
        schedule.setMasterId(rs.getString(this.scheduleTableSchema.masterId));
        SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
        String str = rs.getString(this.scheduleTableSchema.date) + rs.getString(this.scheduleTableSchema.time);
        schedule.setTime(format.parse(str));
        schedule.setTaskName(rs.getString(this.scheduleTableSchema.taskName));
        schedule.setInput(this.scheduleTableSchema.getInputObject(rs));
        schedule.setOutput(this.scheduleTableSchema.getOutputObject(rs));
        str = rs.getString(this.scheduleTableSchema.initialDate) + rs.getString(this.scheduleTableSchema.initialTime);
        schedule.setInitialTime(format.parse(str));
        long longVal = rs.getLong(this.scheduleTableSchema.retryInterval);
        if (!rs.wasNull()) {
            schedule.setRetryInterval(longVal);
        }
        if ((retryEndTimeStr = rs.getString(this.scheduleTableSchema.retryEndTime)) != null) {
            schedule.setRetryEndTime(format.parse(retryEndTimeStr));
        }
        longVal = rs.getLong(this.scheduleTableSchema.maxDelayTime);
        if (!rs.wasNull()) {
            schedule.setMaxDelayTime(longVal);
        }
        schedule.setState(this.scheduleTableSchema.getState(rs.getString(this.scheduleTableSchema.state)));
        schedule.setControlState(this.scheduleTableSchema.getControlState(rs.getString(this.scheduleTableSchema.controlState)));
        schedule.setCheckState(this.scheduleTableSchema.getCheckState(rs.getString(this.scheduleTableSchema.checkState)));
        schedule.setExecutorKey(rs.getString(this.scheduleTableSchema.executorKey));
        schedule.setExecutorType(rs.getString(this.scheduleTableSchema.executorType));
        String executeStartTimeStr = rs.getString(this.scheduleTableSchema.executeStartTime);
        if (executeStartTimeStr != null) {
            schedule.setExecuteStartTime(format.parse(executeStartTimeStr));
        }
        if ((executeEndTimeStr = rs.getString(this.scheduleTableSchema.executeEndTime)) != null) {
            schedule.setExecuteEndTime(format.parse(executeEndTimeStr));
        }
        return schedule;
    }

    protected Schedule setDependsOnSchedule(Connection con, Schedule schedule) throws SQLException {
        ArrayList<Schedule> tmp = new ArrayList<Schedule>();
        tmp.add(schedule);
        this.setDependsOnSchedules(con, tmp);
        return (Schedule)tmp.get(0);
    }

    protected List setDependsOnSchedules(Connection con, List schedules) throws SQLException {
        if (schedules.size() == 0) {
            return schedules;
        }
        StringBuffer buf = new StringBuffer();
        Statement st = con.createStatement();
        ResultSet rs = null;
        HashMap<String, Schedule> scheduleMap = new HashMap<String, Schedule>();
        HashMap<String, ArrayList<String>> scheduleDependsMap = new HashMap<String, ArrayList<String>>();
        int to = schedules.size() % 1000 == 0 ? schedules.size() / 1000 : schedules.size() / 1000 + 1;
        for (int i = 0; i < to; ++i) {
            Schedule schedule;
            int startIndex;
            scheduleMap.clear();
            scheduleDependsMap.clear();
            buf.setLength(0);
            buf.append("select * from ");
            buf.append(this.scheduleDependsTableSchema.table);
            buf.append(" where ");
            buf.append(this.scheduleDependsTableSchema.id);
            buf.append(" in (");
            int jmax = Math.min(startIndex + 1000, schedules.size());
            for (int j = startIndex = i * 1000; j < jmax; ++j) {
                schedule = (Schedule)schedules.get(j);
                buf.append('\'').append(schedule.getId()).append('\'');
                if (j != jmax - 1) {
                    buf.append(',');
                }
                scheduleMap.put(schedule.getId(), schedule);
            }
            buf.append(')');
            rs = st.executeQuery(buf.toString());
            while (rs.next()) {
                String id = rs.getString(this.scheduleDependsTableSchema.id);
                ArrayList<String> depends = (ArrayList<String>)scheduleDependsMap.get(id);
                if (depends == null) {
                    depends = new ArrayList<String>();
                    scheduleDependsMap.put(id, depends);
                }
                depends.add(rs.getString(this.scheduleDependsTableSchema.dependsId));
            }
            for (Map.Entry entry : scheduleDependsMap.entrySet()) {
                schedule = (DefaultSchedule)scheduleMap.get(entry.getKey());
                List depends = (List)entry.getValue();
                if (depends.size() == 0) continue;
                ((DefaultSchedule)schedule).setDepends(depends.toArray(new String[depends.size()]));
            }
            rs.close();
        }
        return schedules;
    }

    @Override
    public Schedule findSchedule(String id) throws ScheduleManageException {
        Schedule schedule;
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement("select * from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                Schedule schedule2 = null;
                return schedule2;
            }
            schedule = this.setDependsOnSchedule(con, this.createSchedule(rs));
        }
        catch (ParseException e) {
            throw new ScheduleManageException(e);
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        catch (IOException e) {
            throw new ScheduleManageException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
        return schedule;
    }

    @Override
    public List findSchedules(String masterId) throws ScheduleManageException {
        ArrayList<Schedule> result = new ArrayList<Schedule>();
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement("select * from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.masterId + "=?");
            st.setString(1, masterId);
            rs = st.executeQuery();
            while (rs.next()) {
                result.add(this.createSchedule(rs));
            }
            this.setDependsOnSchedules(con, result);
        }
        catch (ParseException e) {
            throw new ScheduleManageException(e);
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        catch (IOException e) {
            throw new ScheduleManageException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public List findSchedules(Date date) throws ScheduleManageException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date from = cal.getTime();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        Date to = cal.getTime();
        return this.findSchedules(from, to);
    }

    @Override
    public List findSchedules(Date from, Date to) throws ScheduleManageException {
        return this.findSchedules(from, to, null);
    }

    @Override
    public List findSchedules(int[] states) throws ScheduleManageException {
        return this.findSchedules(null, null, states);
    }

    @Override
    public List findSchedules(Date from, Date to, int[] states) throws ScheduleManageException {
        return this.findSchedules(from, to, states, null, null, null, false);
    }

    @Override
    public List findSchedules(Date from, Date to, int[] states, String masterId) throws ScheduleManageException {
        return this.findSchedules(from, to, states, masterId, null, null, false);
    }

    protected StringBuffer concatQuery(StringBuffer buf, String s1, String s2) {
        if (this.isUseConcatFunction) {
            buf.append("concat(").append(s1).append(',').append(s2).append(')');
        } else {
            buf.append(s1).append("||").append(s2);
        }
        return buf;
    }

    protected List findSchedules(Date from, Date to, int[] states, String masterId, String[] executorTypes, String executorKey, boolean isLock) throws ScheduleManageException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            int i;
            int i2;
            StringBuffer buf = new StringBuffer();
            buf.append("select * from ");
            buf.append(this.scheduleTableSchema.table);
            boolean isAppendWhere = false;
            if (from != null) {
                if (!isAppendWhere) {
                    buf.append(" where ");
                    isAppendWhere = true;
                }
                this.concatQuery(buf, this.scheduleTableSchema.date, this.scheduleTableSchema.time);
                buf.append(">=?");
            }
            if (to != null) {
                if (!isAppendWhere) {
                    buf.append(" where ");
                    isAppendWhere = true;
                } else {
                    buf.append(" and ");
                }
                this.concatQuery(buf, this.scheduleTableSchema.date, this.scheduleTableSchema.time);
                buf.append("<=?");
            }
            if (states != null && states.length != 0) {
                if (!isAppendWhere) {
                    buf.append(" where (");
                    isAppendWhere = true;
                } else {
                    buf.append(" and (");
                }
                for (i2 = 0; i2 < states.length; ++i2) {
                    buf.append(this.scheduleTableSchema.state);
                    buf.append("=?");
                    if (i2 == states.length - 1) continue;
                    buf.append(" or ");
                }
                buf.append(')');
            }
            if (masterId != null) {
                if (!isAppendWhere) {
                    buf.append(" where ");
                    isAppendWhere = true;
                } else {
                    buf.append(" and ");
                }
                buf.append(this.scheduleTableSchema.masterId);
                buf.append("=?");
            }
            if (executorTypes != null && executorTypes.length != 0) {
                if (!isAppendWhere) {
                    buf.append(" where (");
                    isAppendWhere = true;
                } else {
                    buf.append(" and (");
                }
                buf.append(this.scheduleTableSchema.executorType);
                buf.append(" is null or ");
                for (i2 = 0; i2 < executorTypes.length; ++i2) {
                    buf.append(this.scheduleTableSchema.executorType);
                    buf.append("=?");
                    if (i2 == executorTypes.length - 1) continue;
                    buf.append(" or ");
                }
                buf.append(')');
            }
            if (executorKey != null) {
                if (!isAppendWhere) {
                    buf.append(" where (");
                    isAppendWhere = true;
                } else {
                    buf.append(" and (");
                }
                buf.append(this.scheduleTableSchema.executorKey);
                buf.append(" is null or ");
                buf.append(this.scheduleTableSchema.executorKey);
                buf.append(" =?)");
            }
            if (isLock) {
                buf.append(" for update");
            }
            st = con.prepareStatement(buf.toString());
            buf = null;
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
            int index = 0;
            if (from != null) {
                st.setString(++index, format.format(from));
            }
            if (to != null) {
                st.setString(++index, format.format(to));
            }
            if (states != null && states.length != 0) {
                for (i = 0; i < states.length; ++i) {
                    st.setString(++index, this.scheduleTableSchema.getStateString(states[i]));
                }
            }
            if (masterId != null) {
                st.setString(++index, masterId);
            }
            if (executorTypes != null && executorTypes.length != 0) {
                for (i = 0; i < executorTypes.length; ++i) {
                    st.setString(++index, executorTypes[i]);
                }
            }
            if (executorKey != null) {
                st.setString(++index, executorKey);
            }
            rs = st.executeQuery();
            ArrayList<Schedule> result = new ArrayList<Schedule>();
            while (rs.next()) {
                result.add(this.createSchedule(rs));
            }
            this.setDependsOnSchedules(con, result);
            Collections.sort(result);
            ArrayList<Schedule> arrayList = result;
            return arrayList;
        }
        catch (ParseException e) {
            throw new ScheduleManageException(e);
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        catch (IOException e) {
            throw new ScheduleManageException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    public List findExecutableSchedules(Date date, String[] executorTypes) throws ScheduleManageException {
        return this.findExecutableSchedules(date, executorTypes, null);
    }

    @Override
    public List findExecutableSchedules(Date date, String[] executorTypes, String executorKey) throws ScheduleManageException {
        List result = this.findSchedules(null, date, new int[]{1, 8}, null, executorTypes, executorKey, this.isLockForFindExecutable);
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement("select count(1) from " + this.scheduleTableSchema.table + " A, (select " + this.scheduleDependsTableSchema.dependsId + " from " + this.scheduleDependsTableSchema.table + " where " + this.scheduleDependsTableSchema.id + "=?) B where A." + this.scheduleTableSchema.masterId + "=B." + this.scheduleDependsTableSchema.dependsId + " and A." + this.scheduleTableSchema.state + "<>'" + this.scheduleTableSchema.stateString_END + '\'' + " and " + this.concatQuery(new StringBuffer(), "A." + this.scheduleTableSchema.initialDate, "A." + this.scheduleTableSchema.initialTime) + "<=?");
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
            Iterator itr = result.iterator();
            while (itr.hasNext()) {
                Schedule schedule = (Schedule)itr.next();
                st.setString(1, schedule.getId());
                Date initialTime = schedule.getInitialTime() == null ? schedule.getTime() : schedule.getInitialTime();
                st.setString(2, format.format(initialTime));
                rs = st.executeQuery();
                rs.next();
                if (rs.getInt(1) == 0) continue;
                itr.remove();
            }
            Collections.sort(result);
            List list = result;
            return list;
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    public List findDependedSchedules(String id) throws ScheduleManageException {
        ArrayList<Schedule> arrayList;
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement ps = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            StringBuffer buf = new StringBuffer();
            buf.append("select distinct ");
            buf.append(this.scheduleDependsTableSchema.id);
            buf.append(" from ");
            buf.append(this.scheduleDependsTableSchema.table);
            buf.append(" where ");
            buf.append(this.scheduleDependsTableSchema.dependsId);
            buf.append("=(select ");
            buf.append(this.scheduleTableSchema.masterId);
            buf.append(" from ");
            buf.append(this.scheduleTableSchema.table);
            buf.append(" where ");
            buf.append(this.scheduleTableSchema.id);
            buf.append("=?)");
            ps = con.prepareStatement(buf.toString());
            ps.setString(1, id);
            rs = ps.executeQuery();
            ArrayList<String> idList = new ArrayList<String>();
            while (rs.next()) {
                idList.add(rs.getString(1));
            }
            rs.close();
            rs = null;
            ps.close();
            ps = null;
            ArrayList<Schedule> result = new ArrayList<Schedule>();
            if (idList.size() == 0) {
                ArrayList<Schedule> arrayList2 = result;
                return arrayList2;
            }
            st = con.createStatement();
            int to = idList.size() % 1000 == 0 ? idList.size() / 1000 : idList.size() / 1000 + 1;
            for (int i = 0; i < to; ++i) {
                int startIndex;
                buf.setLength(0);
                buf.append("select * from ");
                buf.append(this.scheduleTableSchema.table);
                buf.append(" where ");
                buf.append(this.scheduleTableSchema.id);
                buf.append(" in (");
                int jmax = Math.min(startIndex + 1000, idList.size());
                for (int j = startIndex = i * 1000; j < jmax; ++j) {
                    buf.append('\'').append(idList.get(j)).append('\'');
                    if (j == jmax - 1) continue;
                    buf.append(',');
                }
                buf.append(')');
                rs = st.executeQuery(buf.toString());
                while (rs.next()) {
                    result.add(this.createSchedule(rs));
                }
                rs.close();
                rs = null;
            }
            st.close();
            st = null;
            this.setDependsOnSchedules(con, result);
            Collections.sort(result);
            arrayList = result;
        }
        catch (ParseException e) {
            throw new ScheduleManageException(e);
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        catch (IOException e) {
            throw new ScheduleManageException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
        return arrayList;
    }

    @Override
    public void addSchedule(Schedule schedule) throws ScheduleManageException {
        this.addSchedule(schedule, true);
    }

    @Override
    public void addSchedule(String masterId, Date time, String taskName, Object input, String[] depends, String executorKey, String executorType, long retryInterval, Date retryEndTime, long maxDelayTime) throws ScheduleManageException {
        this.addSchedule(new DefaultSchedule(masterId, time, taskName, input, depends, executorKey, executorType, retryInterval, retryEndTime, maxDelayTime));
    }

    @Override
    public boolean reschedule(String id, Date time) throws ScheduleManageException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement("select " + this.scheduleTableSchema.rowVersion + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new ScheduleStateControlException("Schedule not found : " + id);
            }
            int rowVersion = rs.getInt(1);
            rs.close();
            rs = null;
            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.date + "=?, " + this.scheduleTableSchema.time + "=?," + this.scheduleTableSchema.checkState + "='" + this.scheduleTableSchema.getCheckStateString(1) + "'," + this.scheduleTableSchema.rowVersion + "='" + (rowVersion + 1) + "'," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=?" + " where " + this.scheduleTableSchema.id + "=? and " + this.scheduleTableSchema.rowVersion + "='" + rowVersion + '\'');
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
            st.setString(1, format.format(time));
            format.applyPattern(this.timeFormat);
            st.setString(2, format.format(time));
            st.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            st.setString(4, id);
            boolean bl = st.executeUpdate() != 0;
            return bl;
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    public boolean removeSchedule(String id) throws ScheduleManageException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        try {
            st = con.prepareStatement("delete from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            boolean bl = st.executeUpdate() != 0;
            return bl;
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    public boolean removeScheduleByMasterId(String masterId) throws ScheduleManageException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        try {
            st = con.prepareStatement("delete from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.masterId + "=?");
            st.setString(1, masterId);
            boolean bl = st.executeUpdate() != 0;
            return bl;
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    public boolean removeSchedule(Date date) throws ScheduleManageException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        try {
            st = con.prepareStatement("delete from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.date + "=?");
            st.setString(1, new SimpleDateFormat(this.dateFormat).format(date));
            boolean bl = st.executeUpdate() != 0;
            return bl;
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    public boolean removeSchedule(Date from, Date to, int[] states, String masterId) throws ScheduleManageException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        try {
            StringBuffer buf = new StringBuffer();
            buf.append("delete from ");
            buf.append(this.scheduleTableSchema.table);
            boolean isAppendWhere = false;
            if (from != null) {
                if (!isAppendWhere) {
                    buf.append(" where ");
                    isAppendWhere = true;
                }
                this.concatQuery(buf, this.scheduleTableSchema.date, this.scheduleTableSchema.time);
                buf.append(">=?");
            }
            if (to != null) {
                if (!isAppendWhere) {
                    buf.append(" where ");
                    isAppendWhere = true;
                } else {
                    buf.append(" and ");
                }
                this.concatQuery(buf, this.scheduleTableSchema.date, this.scheduleTableSchema.time);
                buf.append("<=?");
            }
            if (states != null && states.length != 0) {
                if (!isAppendWhere) {
                    buf.append(" where (");
                    isAppendWhere = true;
                } else {
                    buf.append(" and (");
                }
                for (int i = 0; i < states.length; ++i) {
                    buf.append(this.scheduleTableSchema.state);
                    buf.append("=?");
                    if (i == states.length - 1) continue;
                    buf.append(" or ");
                }
                buf.append(')');
            }
            if (masterId != null) {
                if (!isAppendWhere) {
                    buf.append(" where ");
                    isAppendWhere = true;
                } else {
                    buf.append(" and ");
                }
                buf.append(this.scheduleTableSchema.masterId);
                buf.append("=?");
            }
            st = con.prepareStatement(buf.toString());
            buf = null;
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
            int index = 0;
            if (from != null) {
                st.setString(++index, format.format(from));
            }
            if (to != null) {
                st.setString(++index, format.format(to));
            }
            if (states != null && states.length != 0) {
                for (int i = 0; i < states.length; ++i) {
                    st.setString(++index, this.scheduleTableSchema.getStateString(states[i]));
                }
            }
            if (masterId != null) {
                st.setString(++index, masterId);
            }
            boolean bl = st.executeUpdate() != 0;
            return bl;
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    public void setExecutorKey(String id, String key) throws ScheduleManageException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.executorKey + "=?," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=?" + " where " + this.scheduleTableSchema.id + "=?");
            if (key == null) {
                st.setNull(1, 12);
            } else {
                st.setString(1, key);
            }
            st.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            st.setString(3, id);
            st.executeUpdate();
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    public int getState(String id) throws ScheduleStateControlException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleStateControlException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement("select " + this.scheduleTableSchema.state + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new ScheduleStateControlException("Schedule not found : " + id);
            }
            int n = this.scheduleTableSchema.getState(rs.getString(1));
            return n;
        }
        catch (SQLException e) {
            throw new ScheduleStateControlException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    public int getControlState(String id) throws ScheduleStateControlException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleStateControlException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement("select " + this.scheduleTableSchema.controlState + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new ScheduleStateControlException("Schedule not found : " + id);
            }
            int n = this.scheduleTableSchema.getControlState(rs.getString(1));
            return n;
        }
        catch (SQLException e) {
            throw new ScheduleStateControlException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    public boolean changeState(String id, int state) throws ScheduleStateControlException {
        boolean bl;
        boolean isUpdateExecuteStartTime = false;
        boolean isUpdateExecuteEndTime = false;
        Date executeStartTime = null;
        Date executeEndTime = null;
        switch (state) {
            case 3: {
                executeStartTime = new Date();
                isUpdateExecuteStartTime = true;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                executeEndTime = new Date();
                isUpdateExecuteEndTime = true;
                break;
            }
            case 1: 
            case 2: {
                isUpdateExecuteStartTime = true;
                isUpdateExecuteEndTime = true;
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            default: {
                throw new ScheduleStateControlException("Unknown state : " + state);
            }
        }
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleStateControlException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement("select " + this.scheduleTableSchema.state + ',' + this.scheduleTableSchema.rowVersion + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new ScheduleStateControlException("Schedule not found : " + id);
            }
            String oldStateStr = rs.getString(1);
            int rowVersion = rs.getInt(2);
            rs.close();
            rs = null;
            String newStateStr = this.scheduleTableSchema.getStateString(state);
            if (oldStateStr.equals(newStateStr)) {
                boolean bl2 = false;
                return bl2;
            }
            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.state + "=?," + (isUpdateExecuteStartTime ? this.scheduleTableSchema.executeStartTime + "=?," : "") + (isUpdateExecuteEndTime ? this.scheduleTableSchema.executeEndTime + "=?," : "") + this.scheduleTableSchema.rowVersion + "='" + (rowVersion + 1) + "'," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=?" + " where " + this.scheduleTableSchema.id + "=? and " + this.scheduleTableSchema.rowVersion + "='" + rowVersion + '\'');
            int i = 0;
            st.setString(++i, newStateStr);
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
            if (isUpdateExecuteStartTime) {
                st.setString(++i, executeStartTime == null ? null : format.format(executeStartTime));
            }
            if (isUpdateExecuteEndTime) {
                st.setString(++i, executeEndTime == null ? null : format.format(executeEndTime));
            }
            st.setTimestamp(++i, new Timestamp(System.currentTimeMillis()));
            st.setString(++i, id);
            bl = st.executeUpdate() != 0;
        }
        catch (SQLException e) {
            throw new ScheduleStateControlException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
        return bl;
    }

    @Override
    public boolean changeState(String id, int oldState, int newState) throws ScheduleStateControlException {
        boolean bl;
        boolean isUpdateExecuteStartTime = false;
        boolean isUpdateExecuteEndTime = false;
        Date executeStartTime = null;
        Date executeEndTime = null;
        switch (newState) {
            case 3: {
                executeStartTime = new Date();
                isUpdateExecuteStartTime = true;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                executeEndTime = new Date();
                isUpdateExecuteEndTime = true;
                break;
            }
            case 1: 
            case 2: {
                isUpdateExecuteStartTime = true;
                isUpdateExecuteEndTime = true;
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            default: {
                throw new ScheduleStateControlException("Unknown state : " + newState);
            }
        }
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleStateControlException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement("select " + this.scheduleTableSchema.state + ',' + this.scheduleTableSchema.rowVersion + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new ScheduleStateControlException("Schedule not found : " + id);
            }
            String oldStateStr = rs.getString(1);
            int rowVersion = rs.getInt(2);
            rs.close();
            rs = null;
            String newStateStr = this.scheduleTableSchema.getStateString(newState);
            if (oldStateStr.equals(newStateStr)) {
                boolean bl2 = false;
                return bl2;
            }
            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.state + "=?," + (isUpdateExecuteStartTime ? this.scheduleTableSchema.executeStartTime + "=?," : "") + (isUpdateExecuteEndTime ? this.scheduleTableSchema.executeEndTime + "=?," : "") + this.scheduleTableSchema.rowVersion + "='" + (rowVersion + 1) + "'," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=?" + " where " + this.scheduleTableSchema.id + "=? and " + this.scheduleTableSchema.state + "=? and " + this.scheduleTableSchema.rowVersion + "='" + rowVersion + '\'');
            int i = 0;
            st.setString(++i, newStateStr);
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
            if (isUpdateExecuteStartTime) {
                st.setString(++i, executeStartTime == null ? null : format.format(executeStartTime));
            }
            if (isUpdateExecuteEndTime) {
                st.setString(++i, executeEndTime == null ? null : format.format(executeEndTime));
            }
            st.setTimestamp(++i, new Timestamp(System.currentTimeMillis()));
            st.setString(++i, id);
            st.setString(++i, this.scheduleTableSchema.getStateString(oldState));
            bl = st.executeUpdate() != 0;
        }
        catch (SQLException e) {
            throw new ScheduleStateControlException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
        return bl;
    }

    @Override
    public boolean changeState(String id, int state, Object output) throws ScheduleStateControlException {
        boolean bl;
        boolean isUpdateExecuteStartTime = false;
        boolean isUpdateExecuteEndTime = false;
        Date executeStartTime = null;
        Date executeEndTime = null;
        switch (state) {
            case 3: {
                executeStartTime = new Date();
                isUpdateExecuteStartTime = true;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                executeEndTime = new Date();
                isUpdateExecuteEndTime = true;
                break;
            }
            case 1: 
            case 2: {
                isUpdateExecuteStartTime = true;
                isUpdateExecuteEndTime = true;
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            default: {
                throw new ScheduleStateControlException("Unknown state : " + state);
            }
        }
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleStateControlException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement("select " + this.scheduleTableSchema.state + ',' + this.scheduleTableSchema.rowVersion + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new ScheduleStateControlException("Schedule not found : " + id);
            }
            String oldStateStr = rs.getString(1);
            int rowVersion = rs.getInt(2);
            rs.close();
            rs = null;
            String newStateStr = this.scheduleTableSchema.getStateString(state);
            if (oldStateStr.equals(newStateStr)) {
                boolean bl2 = false;
                return bl2;
            }
            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.state + "=?," + this.scheduleTableSchema.output + "=?," + (isUpdateExecuteStartTime ? this.scheduleTableSchema.executeStartTime + "=?," : "") + (isUpdateExecuteEndTime ? this.scheduleTableSchema.executeEndTime + "=?," : "") + this.scheduleTableSchema.rowVersion + "='" + (rowVersion + 1) + "'," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=?" + " where " + this.scheduleTableSchema.id + "=? and " + this.scheduleTableSchema.rowVersion + "='" + rowVersion + '\'');
            int i = 0;
            st.setString(++i, newStateStr);
            this.scheduleTableSchema.setOutputObject(++i, (PreparedStatement)st, output);
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
            if (isUpdateExecuteStartTime) {
                st.setString(++i, executeStartTime == null ? null : format.format(executeStartTime));
            }
            if (isUpdateExecuteEndTime) {
                st.setString(++i, executeEndTime == null ? null : format.format(executeEndTime));
            }
            st.setTimestamp(++i, new Timestamp(System.currentTimeMillis()));
            st.setString(++i, id);
            bl = st.executeUpdate() != 0 && !newStateStr.equals(oldStateStr);
        }
        catch (IOException e) {
            throw new ScheduleStateControlException(e);
        }
        catch (SQLException e) {
            throw new ScheduleStateControlException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean changeControlState(String id, int state) throws ScheduleStateControlException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleStateControlException(e);
        }
        boolean result = false;
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement("select " + this.scheduleTableSchema.controlState + ',' + this.scheduleTableSchema.rowVersion + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new ScheduleStateControlException("Schedule not found : " + id);
            }
            String oldStateStr = rs.getString(1);
            int nowOldState = this.scheduleTableSchema.getControlState(oldStateStr);
            int rowVersion = rs.getInt(2);
            rs.close();
            rs = null;
            if (nowOldState == state) {
                boolean bl = false;
                return bl;
            }
            switch (state) {
                case 2: {
                    if (nowOldState == 3) break;
                    boolean bl = false;
                    return bl;
                }
                case 3: {
                    if (nowOldState == 6) break;
                    boolean bl = false;
                    return bl;
                }
                case 4: {
                    if (nowOldState == 3) break;
                    boolean bl = false;
                    return bl;
                }
                default: {
                    throw new ScheduleStateControlException("Unknown state : " + state);
                }
            }
            String newStateStr = this.scheduleTableSchema.getControlStateString(state);
            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.controlState + "=?," + this.scheduleTableSchema.rowVersion + "='" + (rowVersion + 1) + "'," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=?" + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, newStateStr);
            st.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            st.setString(3, id);
            result = st.executeUpdate() != 0;
            if (!result) return result;
            try {
                if (this.scheduleControlListeners == null) return result;
                if (this.scheduleControlListeners.size() == 0) return result;
                Set e = this.scheduleControlListeners;
                synchronized (e) {
                    Iterator itr = this.scheduleControlListeners.iterator();
                    while (itr.hasNext()) {
                        ScheduleControlListener listener = (ScheduleControlListener)itr.next();
                        listener.changedControlState(id, state);
                    }
                    return result;
                }
            }
            catch (ScheduleStateControlException e) {
                st.setString(1, this.scheduleTableSchema.getControlStateString(5));
                st.executeUpdate();
                throw e;
            }
        }
        catch (SQLException e) {
            throw new ScheduleStateControlException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean changeControlState(String id, int oldState, int newState) throws ScheduleStateControlException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleStateControlException(e);
        }
        boolean result = false;
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement("select " + this.scheduleTableSchema.controlState + ',' + this.scheduleTableSchema.rowVersion + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new ScheduleStateControlException("Schedule not found : " + id);
            }
            String oldStateStr = rs.getString(1);
            int nowOldState = this.scheduleTableSchema.getControlState(oldStateStr);
            int rowVersion = rs.getInt(2);
            rs.close();
            rs = null;
            if (nowOldState == newState) {
                boolean bl = false;
                return bl;
            }
            switch (newState) {
                case 2: {
                    if (nowOldState == 3) break;
                    boolean bl = false;
                    return bl;
                }
                case 3: {
                    if (nowOldState == 6) break;
                    boolean bl = false;
                    return bl;
                }
                case 4: {
                    if (nowOldState == 3) break;
                    boolean bl = false;
                    return bl;
                }
                default: {
                    throw new ScheduleStateControlException("Unknown state : " + newState);
                }
            }
            String newStateStr = this.scheduleTableSchema.getControlStateString(newState);
            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.controlState + "=?," + this.scheduleTableSchema.rowVersion + "='" + (rowVersion + 1) + "'," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=?" + " where " + this.scheduleTableSchema.id + "=? and " + this.scheduleTableSchema.controlState + "=?");
            st.setString(1, newStateStr);
            st.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            st.setString(3, id);
            st.setString(4, this.scheduleTableSchema.getControlStateString(oldState));
            result = st.executeUpdate() != 0;
            if (!result) return result;
            try {
                if (this.scheduleControlListeners == null) return result;
                if (this.scheduleControlListeners.size() == 0) return result;
                Set e = this.scheduleControlListeners;
                synchronized (e) {
                    Iterator itr = this.scheduleControlListeners.iterator();
                    while (itr.hasNext()) {
                        ScheduleControlListener listener = (ScheduleControlListener)itr.next();
                        listener.changedControlState(id, newState);
                    }
                    return result;
                }
            }
            catch (ScheduleStateControlException e) {
                st.setString(1, this.scheduleTableSchema.getControlStateString(5));
                st.executeUpdate();
                throw e;
            }
        }
        catch (SQLException e) {
            throw new ScheduleStateControlException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    public void addScheduleControlListener(ScheduleControlListener listener) {
        if ((this.scheduleControlListeners == null || this.scheduleControlListeners.size() == 0) && this.controlStateChecker == null && this.getState() == 3 && this.controlStateCheckInterval > 0L) {
            this.controlStateChecker = new Daemon(new ControlStateChecker());
            this.controlStateChecker.setName("Nimbus ControlStateChecker " + this.getServiceNameObject());
            this.controlStateChecker.start();
        }
        this.scheduleControlListeners.add(listener);
    }

    @Override
    public void removeScheduleControlListener(ScheduleControlListener listener) {
        this.scheduleControlListeners.remove(listener);
    }

    private static final Object getInOutObject(int type, String name, ResultSet rs) throws IOException, ClassNotFoundException, SQLException {
        int length = 0;
        switch (type) {
            case 2005: {
                Reader reader = rs.getCharacterStream(name);
                StringWriter writer = new StringWriter();
                char[] chars = new char[1024];
                while ((length = reader.read(chars)) > 0) {
                    writer.write(chars, 0, length);
                }
                return writer.toString();
            }
            case 2004: {
                InputStream is = rs.getBinaryStream(name);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] bytes = new byte[1024];
                while ((length = is.read(bytes)) > 0) {
                    baos.write(bytes, 0, length);
                }
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
                return ois.readObject();
            }
        }
        return rs.getObject(name);
    }

    private static final void setInOutObject(int type, int index, PreparedStatement ps, Object value) throws IOException, SQLException {
        if (value == null) {
            ps.setNull(index, type);
            return;
        }
        switch (type) {
            case 2005: {
                char[] chars = value.toString().toCharArray();
                ps.setCharacterStream(index, (Reader)new CharArrayReader(chars), chars.length);
                break;
            }
            case 2004: {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(value);
                oos.flush();
                byte[] bytes = baos.toByteArray();
                ps.setBinaryStream(index, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
                break;
            }
            default: {
                ps.setString(index, value.toString());
            }
        }
    }

    protected class ClusterListener
    implements jp.ossc.nimbus.service.keepalive.ClusterListener {
        protected ClusterListener() {
        }

        @Override
        public void memberInit(Object myId, List members) {
        }

        @Override
        public void memberChange(List oldMembers, List newMembers) {
        }

        @Override
        public void changeMain() throws Exception {
            if (DatabaseScheduleManagerService.this.controlStateChecker != null) {
                DatabaseScheduleManagerService.this.controlStateChecker.resume();
            }
            if (DatabaseScheduleManagerService.this.timeoverChecker != null) {
                DatabaseScheduleManagerService.this.timeoverChecker.resume();
            }
        }

        @Override
        public void changeSub() {
            if (DatabaseScheduleManagerService.this.controlStateChecker != null) {
                DatabaseScheduleManagerService.this.controlStateChecker.suspend();
            }
            if (DatabaseScheduleManagerService.this.timeoverChecker != null) {
                DatabaseScheduleManagerService.this.timeoverChecker.suspend();
            }
        }
    }

    protected class TimeoverChecker
    implements DaemonRunnable {
        protected TimeoverChecker() {
        }

        @Override
        public boolean onStart() {
            return true;
        }

        @Override
        public boolean onStop() {
            return true;
        }

        @Override
        public boolean onSuspend() {
            return true;
        }

        @Override
        public boolean onResume() {
            return true;
        }

        @Override
        public Object provide(DaemonControl ctrl) throws Throwable {
            Thread.sleep(DatabaseScheduleManagerService.this.getTimeoverCheckInterval());
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void consume(Object dequeued, DaemonControl ctrl) throws Throwable {
            Connection con = null;
            try {
                con = DatabaseScheduleManagerService.this.connectionFactory.getConnection();
            }
            catch (ConnectionFactoryException e) {
                DatabaseScheduleManagerService.this.getLogger().write("DSM__00002", e);
                return;
            }
            Statement st = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                st = con.createStatement();
                SimpleDateFormat format = new SimpleDateFormat(DatabaseScheduleManagerService.this.dateFormat + DatabaseScheduleManagerService.this.timeFormat);
                Calendar nowCal = Calendar.getInstance();
                rs = st.executeQuery("select " + DatabaseScheduleManagerService.this.scheduleTableSchema.id + ',' + DatabaseScheduleManagerService.this.scheduleTableSchema.date + ',' + DatabaseScheduleManagerService.this.scheduleTableSchema.time + ',' + DatabaseScheduleManagerService.this.scheduleTableSchema.maxDelayTime + ',' + DatabaseScheduleManagerService.this.scheduleTableSchema.state + ',' + DatabaseScheduleManagerService.this.scheduleTableSchema.taskName + " from " + DatabaseScheduleManagerService.this.scheduleTableSchema.table + " where " + DatabaseScheduleManagerService.this.scheduleTableSchema.checkState + "<>'" + DatabaseScheduleManagerService.this.scheduleTableSchema.getCheckStateString(2) + "' and " + DatabaseScheduleManagerService.this.concatQuery(new StringBuffer(), DatabaseScheduleManagerService.this.scheduleTableSchema.date, DatabaseScheduleManagerService.this.scheduleTableSchema.time) + "<'" + format.format(nowCal.getTime()) + "' and " + DatabaseScheduleManagerService.this.scheduleTableSchema.maxDelayTime + " is not null" + " and " + DatabaseScheduleManagerService.this.scheduleTableSchema.maxDelayTime + ">0" + " and " + DatabaseScheduleManagerService.this.scheduleTableSchema.state + "<>'" + DatabaseScheduleManagerService.this.scheduleTableSchema.getStateString(4) + "' and " + DatabaseScheduleManagerService.this.scheduleTableSchema.state + "<>'" + DatabaseScheduleManagerService.this.scheduleTableSchema.getStateString(5) + "' and " + DatabaseScheduleManagerService.this.scheduleTableSchema.state + "<>'" + DatabaseScheduleManagerService.this.scheduleTableSchema.getStateString(7) + '\'');
                Calendar tmpCal = Calendar.getInstance();
                while (rs.next()) {
                    Date time = format.parse(rs.getString(2) + rs.getString(3));
                    tmpCal.clear();
                    long maxDelayTime = rs.getLong(4);
                    tmpCal.setTimeInMillis(time.getTime() + maxDelayTime);
                    if (tmpCal.after(nowCal) || tmpCal.equals(nowCal)) continue;
                    String id = rs.getString(1);
                    if (ps == null) {
                        String checkStateStr = DatabaseScheduleManagerService.this.scheduleTableSchema.getCheckStateString(2);
                        ps = con.prepareStatement("update " + DatabaseScheduleManagerService.this.scheduleTableSchema.table + " set " + DatabaseScheduleManagerService.this.scheduleTableSchema.checkState + "='" + checkStateStr + "'," + DatabaseScheduleManagerService.this.scheduleTableSchema.updateUserId + "='" + DatabaseScheduleManagerService.this.updateUserId + "'," + DatabaseScheduleManagerService.this.scheduleTableSchema.updateTime + "=?" + " where " + DatabaseScheduleManagerService.this.scheduleTableSchema.id + "=?" + " and " + DatabaseScheduleManagerService.this.scheduleTableSchema.checkState + "<>'" + checkStateStr + '\'');
                    }
                    ps.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                    ps.setString(2, id);
                    if (ps.executeUpdate() == 0) continue;
                    String state = rs.getString(5);
                    String taskName = rs.getString(6);
                    DatabaseScheduleManagerService.this.getLogger().write("DSM__00003", new Object[]{id, taskName, state});
                }
            }
            catch (SQLException e) {
                DatabaseScheduleManagerService.this.getLogger().write("DSM__00002", e);
                return;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {}
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e) {}
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }

        @Override
        public void garbage() {
        }
    }

    protected class ControlStateChecker
    implements DaemonRunnable {
        protected ControlStateChecker() {
        }

        @Override
        public boolean onStart() {
            return true;
        }

        @Override
        public boolean onStop() {
            return true;
        }

        @Override
        public boolean onSuspend() {
            return true;
        }

        @Override
        public boolean onResume() {
            return true;
        }

        @Override
        public Object provide(DaemonControl ctrl) throws Throwable {
            Thread.sleep(DatabaseScheduleManagerService.this.getControlStateCheckInterval());
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void consume(Object input, DaemonControl ctrl) throws Throwable {
            if (DatabaseScheduleManagerService.this.scheduleControlListeners == null || DatabaseScheduleManagerService.this.scheduleControlListeners.size() == 0) {
                return;
            }
            Connection con = null;
            try {
                con = DatabaseScheduleManagerService.this.connectionFactory.getConnection();
            }
            catch (ConnectionFactoryException e) {
                DatabaseScheduleManagerService.this.getLogger().write("DSM__00001", e);
                return;
            }
            Statement st = null;
            ResultSet rs = null;
            try {
                st = con.createStatement();
                rs = st.executeQuery("select " + DatabaseScheduleManagerService.this.scheduleTableSchema.id + ',' + DatabaseScheduleManagerService.this.scheduleTableSchema.controlState + " from " + DatabaseScheduleManagerService.this.scheduleTableSchema.table + " where (" + DatabaseScheduleManagerService.this.scheduleTableSchema.state + "='" + DatabaseScheduleManagerService.this.scheduleTableSchema.getStateString(3) + "' or " + DatabaseScheduleManagerService.this.scheduleTableSchema.state + "='" + DatabaseScheduleManagerService.this.scheduleTableSchema.getStateString(6) + "') and (" + DatabaseScheduleManagerService.this.scheduleTableSchema.controlState + "='" + DatabaseScheduleManagerService.this.scheduleTableSchema.getControlStateString(2) + "' or " + DatabaseScheduleManagerService.this.scheduleTableSchema.controlState + "='" + DatabaseScheduleManagerService.this.scheduleTableSchema.getControlStateString(3) + "' or " + DatabaseScheduleManagerService.this.scheduleTableSchema.controlState + "='" + DatabaseScheduleManagerService.this.scheduleTableSchema.getControlStateString(4) + "')");
                while (rs.next()) {
                    String id = rs.getString(1);
                    String controlStateStr = rs.getString(2);
                    int controlState = DatabaseScheduleManagerService.this.scheduleTableSchema.getControlState(controlStateStr);
                    try {
                        if (DatabaseScheduleManagerService.this.scheduleControlListeners == null || DatabaseScheduleManagerService.this.scheduleControlListeners.size() == 0) continue;
                        Set set = DatabaseScheduleManagerService.this.scheduleControlListeners;
                        synchronized (set) {
                            for (ScheduleControlListener listener : DatabaseScheduleManagerService.this.scheduleControlListeners) {
                                listener.changedControlState(id, controlState);
                            }
                        }
                    }
                    catch (ScheduleStateControlException e) {
                        try {
                            DatabaseScheduleManagerService.this.changeControlState(id, 5);
                        }
                        catch (ScheduleStateControlException e2) {
                            // empty catch block
                        }
                        DatabaseScheduleManagerService.this.getLogger().write("DSM__00001", e);
                    }
                }
            }
            catch (SQLException e) {
                DatabaseScheduleManagerService.this.getLogger().write("DSM__00001", e);
                return;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {}
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e) {}
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }

        @Override
        public void garbage() {
        }
    }

    public static class ScheduleDependsTableSchema
    extends ScheduleDependsMasterTableSchema {
        public static final String DEFAULT_TABLE = "SCHEDULE_DEPENDS";
        public static final String DEFAULT_ROWVERSION = "ROWVERSION";
        public static final String DEFAULT_UPDATEUSERID = "UPDATEUSERID";
        public static final String DEFAULT_UPDATETIME = "UPDATETIME";
        public String table = "SCHEDULE_DEPENDS";
        public String rowVersion = "ROWVERSION";
        public String updateUserId = "UPDATEUSERID";
        public String updateTime = "UPDATETIME";
    }

    public static class ScheduleTableSchema {
        public static final String DEFAULT_TABLE = "SCHEDULE";
        public static final String DEFAULT_ID = "ID";
        public static final String DEFAULT_MASTER_ID = "MASTER_ID";
        public static final String DEFAULT_DATE = "S_DATE";
        public static final String DEFAULT_TIME = "S_TIME";
        public static final String DEFAULT_TASK_NAME = "TASK_NAME";
        public static final String DEFAULT_INPUT = "INPUT";
        public static final String DEFAULT_OUTPUT = "OUTPUT";
        public static final String DEFAULT_INITIAL_DATE = "INITIAL_DATE";
        public static final String DEFAULT_INITIAL_TIME = "INITIAL_TIME";
        public static final String DEFAULT_RETRY_INTERVAL = "RETRY_INTERVAL";
        public static final String DEFAULT_RETRY_END_TIME = "RETRY_END_TIME";
        public static final String DEFAULT_MAX_DELAY_TIME = "MAX_DELAY_TIME";
        public static final String DEFAULT_STATE = "STATE";
        public static final String DEFAULT_CONTROL_STATE = "CONTROL_STATE";
        public static final String DEFAULT_CHECK_STATE = "CHECK_STATE";
        public static final String DEFAULT_EXECUTOR_KEY = "EXECUTOR_KEY";
        public static final String DEFAULT_EXECUTOR_TYPE = "EXECUTOR_TYPE";
        public static final String DEFAULT_EXECUTE_START_TIME = "EXEC_S_TIME";
        public static final String DEFAULT_EXECUTE_END_TIME = "EXEC_E_TIME";
        public static final String DEFAULT_ROWVERSION = "ROWVERSION";
        public static final String DEFAULT_UPDATEUSERID = "UPDATEUSERID";
        public static final String DEFAULT_UPDATETIME = "UPDATETIME";
        public static final String DEFAULT_STATE_STRING_INITIAL = "I";
        public static final String DEFAULT_STATE_STRING_ENTRY = "E";
        public static final String DEFAULT_STATE_STRING_RUN = "R";
        public static final String DEFAULT_STATE_STRING_END = "N";
        public static final String DEFAULT_STATE_STRING_FAILED = "F";
        public static final String DEFAULT_STATE_STRING_PAUSE = "P";
        public static final String DEFAULT_STATE_STRING_ABORT = "A";
        public static final String DEFAULT_STATE_STRING_RETRY = "T";
        public static final String DEFAULT_STATE_STRING_UNKNOWN = "U";
        public static final String DEFAULT_CONTROL_STATE_STRING_INITIAL = "I";
        public static final String DEFAULT_CONTROL_STATE_STRING_PAUSE = "P";
        public static final String DEFAULT_CONTROL_STATE_STRING_RESUME = "R";
        public static final String DEFAULT_CONTROL_STATE_STRING_ABORT = "A";
        public static final String DEFAULT_CONTROL_STATE_STRING_FAILED = "F";
        public static final String DEFAULT_CONTROL_STATE_STRING_UNKNOWN = "U";
        public static final String DEFAULT_CHECK_STATE_STRING_INITIAL = "I";
        public static final String DEFAULT_CHECK_STATE_STRING_TIMEOVER = "O";
        public static final String DEFAULT_CHECK_STATE_STRING_UNKNOWN = "U";
        public String table = "SCHEDULE";
        public String id = "ID";
        public String masterId = "MASTER_ID";
        public String date = "S_DATE";
        public String time = "S_TIME";
        public String taskName = "TASK_NAME";
        public String input = "INPUT";
        public String output = "OUTPUT";
        public String initialDate = "INITIAL_DATE";
        public String initialTime = "INITIAL_TIME";
        public String retryInterval = "RETRY_INTERVAL";
        public String retryEndTime = "RETRY_END_TIME";
        public String maxDelayTime = "MAX_DELAY_TIME";
        public String state = "STATE";
        public String controlState = "CONTROL_STATE";
        public String checkState = "CHECK_STATE";
        public String executorKey = "EXECUTOR_KEY";
        public String executorType = "EXECUTOR_TYPE";
        public String executeStartTime = "EXEC_S_TIME";
        public String executeEndTime = "EXEC_E_TIME";
        public String rowVersion = "ROWVERSION";
        public String updateUserId = "UPDATEUSERID";
        public String updateTime = "UPDATETIME";
        public String stateString_INITIAL = "I";
        public String stateString_ENTRY = "E";
        public String stateString_RUN = "R";
        public String stateString_END = "N";
        public String stateString_FAILED = "F";
        public String stateString_PAUSE = "P";
        public String stateString_ABORT = "A";
        public String stateString_RETRY = "T";
        public String stateString_UNKNOWN = "U";
        public String controlStateString_INITIAL = "I";
        public String controlStateString_PAUSE = "P";
        public String controlStateString_RESUME = "R";
        public String controlStateString_ABORT = "A";
        public String controlStateString_FAILED = "F";
        public String controlStateString_UNKNOWN = "U";
        public String checkStateString_INITIAL = "I";
        public String checkStateString_TIMEOVER = "O";
        public String checkStateString_UNKNOWN = "U";
        public int inputColumnType = 12;
        public int outputColumnType = 12;

        protected Object getInputObject(ResultSet rs) throws IOException, ClassNotFoundException, SQLException {
            return DatabaseScheduleManagerService.getInOutObject(this.inputColumnType, this.input, rs);
        }

        protected void setInputObject(int index, PreparedStatement ps, Object value) throws IOException, SQLException {
            DatabaseScheduleManagerService.setInOutObject(this.inputColumnType, index, ps, value);
        }

        protected Object getOutputObject(ResultSet rs) throws IOException, ClassNotFoundException, SQLException {
            return DatabaseScheduleManagerService.getInOutObject(this.outputColumnType, this.output, rs);
        }

        protected void setOutputObject(int index, PreparedStatement ps, Object value) throws IOException, SQLException {
            DatabaseScheduleManagerService.setInOutObject(this.outputColumnType, index, ps, value);
        }

        public String getStateString(int state) {
            switch (state) {
                case 1: {
                    return this.stateString_INITIAL;
                }
                case 2: {
                    return this.stateString_ENTRY;
                }
                case 3: {
                    return this.stateString_RUN;
                }
                case 4: {
                    return this.stateString_END;
                }
                case 5: {
                    return this.stateString_FAILED;
                }
                case 6: {
                    return this.stateString_PAUSE;
                }
                case 7: {
                    return this.stateString_ABORT;
                }
                case 8: {
                    return this.stateString_RETRY;
                }
            }
            return this.stateString_UNKNOWN;
        }

        public int getState(String state) {
            if (this.stateString_INITIAL.equals(state)) {
                return 1;
            }
            if (this.stateString_ENTRY.equals(state)) {
                return 2;
            }
            if (this.stateString_RUN.equals(state)) {
                return 3;
            }
            if (this.stateString_END.equals(state)) {
                return 4;
            }
            if (this.stateString_FAILED.equals(state)) {
                return 5;
            }
            if (this.stateString_PAUSE.equals(state)) {
                return 6;
            }
            if (this.stateString_ABORT.equals(state)) {
                return 7;
            }
            if (this.stateString_RETRY.equals(state)) {
                return 8;
            }
            return -1;
        }

        public String getControlStateString(int state) {
            switch (state) {
                case 1: {
                    return this.controlStateString_INITIAL;
                }
                case 2: {
                    return this.controlStateString_PAUSE;
                }
                case 3: {
                    return this.controlStateString_RESUME;
                }
                case 4: {
                    return this.controlStateString_ABORT;
                }
                case 5: {
                    return this.controlStateString_FAILED;
                }
            }
            return this.controlStateString_UNKNOWN;
        }

        public int getControlState(String state) {
            if (this.controlStateString_INITIAL.equals(state)) {
                return 1;
            }
            if (this.controlStateString_PAUSE.equals(state)) {
                return 2;
            }
            if (this.controlStateString_ABORT.equals(state)) {
                return 4;
            }
            if (this.controlStateString_FAILED.equals(state)) {
                return 5;
            }
            if (this.controlStateString_RESUME.equals(state)) {
                return 3;
            }
            return -1;
        }

        public String getCheckStateString(int state) {
            switch (state) {
                case 1: {
                    return this.checkStateString_INITIAL;
                }
                case 2: {
                    return this.checkStateString_TIMEOVER;
                }
            }
            return this.checkStateString_UNKNOWN;
        }

        public int getCheckState(String state) {
            if (this.checkStateString_INITIAL.equals(state)) {
                return 1;
            }
            if (this.checkStateString_TIMEOVER.equals(state)) {
                return 2;
            }
            return -1;
        }
    }

    public static class ScheduleDependsMasterTableSchema {
        public static final String DEFAULT_TABLE = "SCHEDULE_DEPENDS_MST";
        public static final String DEFAULT_ID = "ID";
        public static final String DEFAULT_DEPENDS_ID = "DEPENDS_ID";
        public String table = "SCHEDULE_DEPENDS_MST";
        public String id = "ID";
        public String dependsId = "DEPENDS_ID";
    }

    public static class ScheduleMasterTableSchema {
        public static final String DEFAULT_TABLE = "SCHEDULE_MST";
        public static final String DEFAULT_ID = "ID";
        public static final String DEFAULT_TASK_NAME = "TASK_NAME";
        public static final String DEFAULT_SCHEDULE_TYPE = "SCHEDULE_TYPE";
        public static final String DEFAULT_INPUT = "INPUT";
        public static final String DEFAULT_START_TIME = "START_TIME";
        public static final String DEFAULT_END_TIME = "END_TIME";
        public static final String DEFAULT_REPEAT_INTERVAL = "REPEAT_INTERVAL";
        public static final String DEFAULT_RETRY_INTERVAL = "RETRY_INTERVAL";
        public static final String DEFAULT_RETRY_END_TIME = "RETRY_END_TIME";
        public static final String DEFAULT_MAX_DELAY_TIME = "MAX_DELAY_TIME";
        public static final String DEFAULT_ENABLE = "ENABLE";
        public static final String DEFAULT_EXECUTOR_KEY = "EXECUTOR_KEY";
        public static final String DEFAULT_EXECUTOR_TYPE = "EXECUTOR_TYPE";
        public String table = "SCHEDULE_MST";
        public String id = "ID";
        public String taskName = "TASK_NAME";
        public String scheduleType = "SCHEDULE_TYPE";
        public String input = "INPUT";
        public String startTime = "START_TIME";
        public String endTime = "END_TIME";
        public String repeatInterval = "REPEAT_INTERVAL";
        public String retryInterval = "RETRY_INTERVAL";
        public String retryEndTime = "RETRY_END_TIME";
        public String maxDelayTime = "MAX_DELAY_TIME";
        public String enable = "ENABLE";
        public String executorKey = "EXECUTOR_KEY";
        public String executorType = "EXECUTOR_TYPE";
        public int inputColumnType = 12;

        protected Object getInputObject(ResultSet rs) throws IOException, ClassNotFoundException, SQLException {
            return DatabaseScheduleManagerService.getInOutObject(this.inputColumnType, this.input, rs);
        }
    }
}

