/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.semaphore;

import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.semaphore.DefaultSemaphoreServiceMBean;
import jp.ossc.nimbus.service.semaphore.MemorySemaphore;
import jp.ossc.nimbus.service.semaphore.Semaphore;

public class DefaultSemaphoreService
extends ServiceBase
implements Semaphore,
DefaultSemaphoreServiceMBean {
    private static final long serialVersionUID = 6475921591298262486L;
    private int capacity = -1;
    private Semaphore semaphore = null;
    private long sleepTime = -1L;
    private long checkInterval = -1L;
    private String semaphoreClassName = MemorySemaphore.class.getName();
    private long timeoutMillis = -1L;
    private int maxWaitCount = -1;
    private long forceFreeTimeoutMillis = -1L;
    private boolean isThreadBinding = true;

    @Override
    public boolean getResource(long timeout, int count, long forceFreeTimeout) {
        if (this.semaphore == null) {
            return false;
        }
        return this.semaphore.getResource(timeout, count, forceFreeTimeout);
    }

    @Override
    public boolean getResource(long timeout, int count) {
        if (this.semaphore == null) {
            return false;
        }
        return this.semaphore.getResource(timeout, count, this.forceFreeTimeoutMillis);
    }

    @Override
    public boolean getResource(long timeout) {
        if (this.semaphore == null) {
            return false;
        }
        return this.semaphore.getResource(timeout, this.maxWaitCount, this.forceFreeTimeoutMillis);
    }

    @Override
    public boolean getResource(int count) {
        if (this.semaphore == null) {
            return false;
        }
        return this.semaphore.getResource(this.timeoutMillis, count, this.forceFreeTimeoutMillis);
    }

    @Override
    public boolean getResource() {
        if (this.semaphore == null) {
            return false;
        }
        return this.semaphore.getResource(this.timeoutMillis, this.maxWaitCount, this.forceFreeTimeoutMillis);
    }

    @Override
    public void freeResource() {
        this.semaphore.freeResource();
    }

    @Override
    public int getResourceCapacity() {
        return this.capacity;
    }

    @Override
    public void setResourceCapacity(int capa) {
        this.capacity = capa;
    }

    @Override
    public void setSleepTime(long millis) {
        this.sleepTime = millis;
    }

    @Override
    public long getSleepTime() {
        return this.sleepTime;
    }

    @Override
    public void setCheckInterval(long millis) {
        this.checkInterval = millis;
    }

    @Override
    public long getCheckInterval() {
        return this.checkInterval;
    }

    @Override
    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    @Override
    public void setTimeoutMillis(long timeout) {
        this.timeoutMillis = timeout;
    }

    @Override
    public int getMaxWaitCount() {
        return this.maxWaitCount;
    }

    @Override
    public void setMaxWaitCount(int count) {
        this.maxWaitCount = count;
    }

    @Override
    public long getForceFreeTimeoutMillis() {
        return this.forceFreeTimeoutMillis;
    }

    @Override
    public void setForceFreeTimeoutMillis(long timeout) {
        this.forceFreeTimeoutMillis = timeout;
    }

    @Override
    public int getResourceRemain() {
        return this.semaphore == null ? -1 : this.semaphore.getResourceRemain();
    }

    @Override
    public int getWaitingCount() {
        return this.semaphore == null ? 0 : this.semaphore.getWaitingCount();
    }

    @Override
    public void release() {
        this.semaphore.release();
    }

    @Override
    public void accept() {
        this.semaphore.accept();
    }

    @Override
    public int getMaxUsedResource() {
        return this.semaphore == null ? 0 : this.semaphore.getMaxUsedResource();
    }

    @Override
    public int getMaxWaitedCount() {
        return this.semaphore == null ? 0 : this.semaphore.getMaxWaitedCount();
    }

    @Override
    public void setThreadBinding(boolean isBinding) {
        this.isThreadBinding = isBinding;
    }

    @Override
    public boolean isThreadBinding() {
        return this.isThreadBinding;
    }

    @Override
    public void setSemaphoreClassName(String name) {
        this.semaphoreClassName = name;
    }

    @Override
    public String getSemaphoreClassName() {
        return this.semaphoreClassName;
    }

    @Override
    public void startService() throws Exception {
        this.semaphore = (Semaphore)Class.forName(this.semaphoreClassName, true, NimbusClassLoader.getInstance()).newInstance();
        this.semaphore.setResourceCapacity(this.getResourceCapacity());
        if (this.getSleepTime() > 0L) {
            this.semaphore.setSleepTime(this.getSleepTime());
        }
        if (this.getCheckInterval() > 0L) {
            this.semaphore.setCheckInterval(this.getCheckInterval());
        }
        this.semaphore.setThreadBinding(this.isThreadBinding());
    }

    @Override
    public void stopService() {
        this.semaphore.release();
    }
}

