/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.soap;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.rpc.encoding.TypeMappingRegistry;

public class TypeMapping
implements javax.xml.rpc.encoding.TypeMapping {
    private static final long serialVersionUID = -7471505423593230398L;
    private String[] supportedEncodings;
    private Map registeredMap;

    public String[] getSupportedEncodings() {
        return this.supportedEncodings;
    }

    public void setSupportedEncodings(String[] encodingStyleURIs) {
        this.supportedEncodings = encodingStyleURIs;
    }

    public boolean isRegistered(Class javaType, QName xmlType) {
        if (this.registeredMap == null) {
            return false;
        }
        return this.registeredMap.containsKey(new RegisteredKey(javaType, xmlType));
    }

    public void register(Class javaType, QName xmlType, SerializerFactory sf, DeserializerFactory dsf) {
        if (this.registeredMap == null) {
            this.registeredMap = new HashMap();
        }
        this.registeredMap.put(new RegisteredKey(javaType, xmlType), new RegisteredValue(sf, dsf));
    }

    public SerializerFactory getSerializer(Class javaType, QName xmlType) {
        if (this.registeredMap == null) {
            return null;
        }
        RegisteredValue val = (RegisteredValue)this.registeredMap.get(new RegisteredKey(javaType, xmlType));
        return val == null ? null : val.sf;
    }

    public DeserializerFactory getDeserializer(Class javaType, QName xmlType) {
        if (this.registeredMap == null) {
            return null;
        }
        RegisteredValue val = (RegisteredValue)this.registeredMap.get(new RegisteredKey(javaType, xmlType));
        return val == null ? null : val.dsf;
    }

    public void removeSerializer(Class javaType, QName xmlType) {
        if (this.registeredMap == null) {
            return;
        }
        RegisteredKey key = new RegisteredKey(javaType, xmlType);
        RegisteredValue val = (RegisteredValue)this.registeredMap.get(key);
        if (val == null) {
            return;
        }
        val.sf = null;
        if (val.dsf == null) {
            this.registeredMap.remove(key);
        }
    }

    public void removeDeserializer(Class javaType, QName xmlType) {
        if (this.registeredMap == null) {
            return;
        }
        RegisteredKey key = new RegisteredKey(javaType, xmlType);
        RegisteredValue val = (RegisteredValue)this.registeredMap.get(key);
        if (val == null) {
            return;
        }
        val.dsf = null;
        if (val.sf == null) {
            this.registeredMap.remove(key);
        }
    }

    public javax.xml.rpc.encoding.TypeMapping cloneTypeMapping(TypeMappingRegistry registry, String encodingStyleURI) {
        javax.xml.rpc.encoding.TypeMapping orgMapping = registry.getTypeMapping(encodingStyleURI);
        if (orgMapping == null) {
            orgMapping = registry.createTypeMapping();
        }
        if (this.registeredMap != null) {
            for (RegisteredKey key : this.registeredMap.keySet()) {
                RegisteredValue val = (RegisteredValue)this.registeredMap.get(key);
                orgMapping.register(key.javaType, key.xmlType, val.sf, val.dsf);
            }
        }
        return orgMapping;
    }

    private static class RegisteredValue {
        SerializerFactory sf;
        DeserializerFactory dsf;

        public RegisteredValue(SerializerFactory sf, DeserializerFactory dsf) {
            this.sf = sf;
            this.dsf = dsf;
        }
    }

    private static class RegisteredKey {
        Class javaType;
        QName xmlType;

        public RegisteredKey(Class javaType, QName xmlType) {
            if (javaType == null || xmlType == null) {
                throw new IllegalArgumentException("javaType and xmlType should not be null.");
            }
            this.javaType = javaType;
            this.xmlType = xmlType;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof RegisteredKey) {
                RegisteredKey comp = (RegisteredKey)obj;
                if (this.javaType.equals(comp.javaType) && this.xmlType.equals(comp.xmlType)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.javaType.hashCode() + this.xmlType.hashCode();
        }
    }
}

