/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.servlet;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.servlet.BeanFlowSelector;
import jp.ossc.nimbus.servlet.MappingBeanFlowSelectorServiceMBean;

public class MappingBeanFlowSelectorService
extends ServiceBase
implements BeanFlowSelector,
MappingBeanFlowSelectorServiceMBean {
    private static final long serialVersionUID = -6425793191507205445L;
    protected Properties mapping;
    protected boolean isRegexEnabled;
    protected int regexMatchFlag;
    protected Map regexMapping;

    @Override
    public void setMapping(Properties mapping) {
        this.mapping = mapping;
    }

    @Override
    public Properties getMapping() {
        return this.mapping;
    }

    @Override
    public void setRegexEnabled(boolean isEnable) {
        this.isRegexEnabled = isEnable;
    }

    @Override
    public boolean isRegexEnabled() {
        return this.isRegexEnabled;
    }

    @Override
    public void setRegexMatchFlag(int flag) {
        this.regexMatchFlag = flag;
    }

    @Override
    public int getRegexMatchFlag() {
        return this.regexMatchFlag;
    }

    @Override
    public void startService() throws Exception {
        if (this.mapping != null && this.isRegexEnabled) {
            for (String string : this.mapping.keySet()) {
                Pattern pattern = Pattern.compile(string, this.regexMatchFlag);
                if (this.regexMapping == null) {
                    this.regexMapping = new LinkedHashMap();
                }
                this.regexMapping.put(pattern, this.mapping.get(string));
            }
        }
    }

    @Override
    public String selectBeanFlow(HttpServletRequest req) {
        String flowName;
        String path = req.getPathInfo();
        if (path == null) {
            path = req.getServletPath();
        }
        if (path == null) {
            return null;
        }
        String string = flowName = this.mapping == null ? null : this.mapping.getProperty(path);
        if (flowName == null && this.isRegexEnabled && this.regexMapping != null && this.regexMapping.size() != 0) {
            for (Pattern pattern : this.regexMapping.keySet()) {
                if (!pattern.matcher(path).matches()) continue;
                flowName = (String)this.regexMapping.get(pattern);
                break;
            }
        }
        return flowName;
    }
}

