/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;

public class ComparableNumber
extends Number
implements Comparable,
Serializable {
    private static final long serialVersionUID = 6924172285753313273L;
    protected final Number number;
    protected final NumberComparator comparator;
    public static final NumberComparator ASC = new OrderNumberComparator(true);
    public static final NumberComparator DESC = new OrderNumberComparator(false);

    public ComparableNumber(Number number) {
        this(number, ASC);
    }

    public ComparableNumber(Number number, NumberComparator comparator) {
        this.number = number == null ? (Number)new Integer(0) : (Number)number;
        this.comparator = comparator;
    }

    public Number getNumber() {
        return this.number;
    }

    public NumberComparator getNumberComparator() {
        return this.comparator;
    }

    @Override
    public byte byteValue() {
        return this.number.byteValue();
    }

    @Override
    public short shortValue() {
        return this.number.shortValue();
    }

    @Override
    public int intValue() {
        return this.number.intValue();
    }

    @Override
    public long longValue() {
        return this.number.longValue();
    }

    @Override
    public float floatValue() {
        return this.number.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.number.doubleValue();
    }

    public int compareTo(Object obj) {
        if (obj instanceof ComparableNumber) {
            return this.comparator.compare(this.number, ((ComparableNumber)obj).number);
        }
        return this.comparator.compare(this.number, (Number)obj);
    }

    public boolean equals(Object obj) {
        return this.number.equals(obj);
    }

    public int hashCode() {
        return this.number.hashCode();
    }

    public String toString() {
        return this.number.toString();
    }

    public static class OrderNumberComparator
    extends NumberComparator {
        private static final long serialVersionUID = 8713363854005411204L;
        protected transient int more;
        protected transient int less;

        public OrderNumberComparator() {
            this(true);
        }

        public OrderNumberComparator(boolean isAsc) {
            this.more = isAsc ? 1 : -1;
            this.less = isAsc ? -1 : 1;
        }

        protected int compareByte(Number num1, Number num2) {
            int val = num1.byteValue() - num2.byteValue();
            if (val == 0) {
                return 0;
            }
            return val > 0 ? this.more : this.less;
        }

        protected int compareShort(Number num1, Number num2) {
            int val = num1.shortValue() - num2.shortValue();
            if (val == 0) {
                return 0;
            }
            return val > 0 ? this.more : this.less;
        }

        protected int compareInt(Number num1, Number num2) {
            int val = num1.intValue() - num2.intValue();
            if (val == 0) {
                return 0;
            }
            return val > 0 ? this.more : this.less;
        }

        protected int compareLong(Number num1, Number num2) {
            long val = num1.longValue() - num2.longValue();
            if (val == 0L) {
                return 0;
            }
            return val > 0L ? this.more : this.less;
        }

        protected int compareFloat(Number num1, Number num2) {
            int result = Float.compare(num1.floatValue(), num2.floatValue());
            if (result == 0) {
                return 0;
            }
            return this.more > 0 ? result : -result;
        }

        protected int compareDouble(Number num1, Number num2) {
            int result = Double.compare(num1.doubleValue(), num2.doubleValue());
            if (result == 0) {
                return 0;
            }
            return this.more > 0 ? result : -result;
        }

        protected int compareBigInteger(Number num1, Number num2) {
            BigInteger bigInt = null;
            bigInt = num1 instanceof Byte || num1 instanceof Short || num1 instanceof Integer || num1 instanceof Long ? BigInteger.valueOf(num1.longValue()) : (num1 instanceof Float || num1 instanceof Double ? BigInteger.valueOf(Math.round(num1.doubleValue())) : (BigInteger)num1);
            int result = bigInt.compareTo((BigInteger)num2);
            if (result == 0) {
                return 0;
            }
            return this.more > 0 ? result : -result;
        }

        protected int compareBigDecimal(Number num1, Number num2) {
            BigDecimal bigDec2;
            BigDecimal bigDec1 = this.toBigDecimal(num1);
            int result = bigDec1.compareTo(bigDec2 = this.toBigDecimal(num2));
            if (result == 0) {
                return 0;
            }
            return this.more > 0 ? result : -result;
        }

        protected BigDecimal toBigDecimal(Number num) {
            if (num instanceof Byte || num instanceof Short || num instanceof Integer || num instanceof Long) {
                return BigDecimal.valueOf(num.longValue());
            }
            if (num instanceof Float || num instanceof Double) {
                return new BigDecimal(num.doubleValue());
            }
            if (num instanceof BigInteger) {
                return new BigDecimal((BigInteger)num);
            }
            if (num instanceof BigDecimal) {
                return (BigDecimal)num;
            }
            try {
                return new BigDecimal(num.toString());
            }
            catch (NumberFormatException e) {
                return new BigDecimal(num.doubleValue());
            }
        }

        @Override
        public int compare(Number num1, Number num2) {
            if (num1 == null && num2 == null) {
                return 0;
            }
            if (num1 == null && num2 != null) {
                return this.less;
            }
            if (num1 != null && num2 == null) {
                return this.more;
            }
            if (num1 instanceof Byte) {
                if (num2 instanceof Byte) {
                    return this.compareByte(num1, num2);
                }
                if (num2 instanceof Short) {
                    return this.compareShort(num1, num2);
                }
                if (num2 instanceof Integer) {
                    return this.compareInt(num1, num2);
                }
                if (num2 instanceof Long) {
                    return this.compareLong(num1, num2);
                }
                if (num2 instanceof Float) {
                    return this.compareFloat(num1, num2);
                }
                if (num2 instanceof Double) {
                    return this.compareDouble(num1, num2);
                }
                if (num2 instanceof BigInteger) {
                    return this.compareBigInteger(num1, num2);
                }
                return this.compareBigDecimal(num1, num2);
            }
            if (num1 instanceof Short) {
                if (num2 instanceof Byte || num2 instanceof Short) {
                    return this.compareShort(num1, num2);
                }
                if (num2 instanceof Integer) {
                    return this.compareInt(num1, num2);
                }
                if (num2 instanceof Long) {
                    return this.compareLong(num1, num2);
                }
                if (num2 instanceof Float) {
                    return this.compareFloat(num1, num2);
                }
                if (num2 instanceof Double) {
                    return this.compareDouble(num1, num2);
                }
                if (num2 instanceof BigInteger) {
                    return this.compareBigInteger(num1, num2);
                }
                return this.compareBigDecimal(num1, num2);
            }
            if (num1 instanceof Integer) {
                if (num2 instanceof Byte || num2 instanceof Short || num2 instanceof Integer) {
                    return this.compareInt(num1, num2);
                }
                if (num2 instanceof Long) {
                    return this.compareLong(num1, num2);
                }
                if (num2 instanceof Float) {
                    return this.compareFloat(num1, num2);
                }
                if (num2 instanceof Double) {
                    return this.compareDouble(num1, num2);
                }
                if (num2 instanceof BigInteger) {
                    return this.compareBigInteger(num1, num2);
                }
                return this.compareBigDecimal(num1, num2);
            }
            if (num1 instanceof Long) {
                if (num2 instanceof Byte || num2 instanceof Short || num2 instanceof Integer || num2 instanceof Long) {
                    return this.compareLong(num1, num2);
                }
                if (num2 instanceof Float) {
                    return this.compareFloat(num1, num2);
                }
                if (num2 instanceof Double) {
                    return this.compareDouble(num1, num2);
                }
                if (num2 instanceof BigInteger) {
                    return this.compareBigInteger(num1, num2);
                }
                return this.compareBigDecimal(num1, num2);
            }
            if (num1 instanceof Float) {
                if (num2 instanceof Byte || num2 instanceof Short || num2 instanceof Integer || num2 instanceof Long || num2 instanceof Float) {
                    return this.compareFloat(num1, num2);
                }
                if (num2 instanceof Double) {
                    return this.compareDouble(num1, num2);
                }
                if (num2 instanceof BigInteger) {
                    return this.compareBigInteger(num1, num2);
                }
                return this.compareBigDecimal(num1, num2);
            }
            if (num1 instanceof Double) {
                if (num2 instanceof Byte || num2 instanceof Short || num2 instanceof Integer || num2 instanceof Long || num2 instanceof Float || num2 instanceof Double) {
                    return this.compareDouble(num1, num2);
                }
                if (num2 instanceof BigInteger) {
                    return this.compareBigInteger(num1, num2);
                }
                return this.compareBigDecimal(num1, num2);
            }
            if (num1 instanceof BigInteger) {
                if (num2 instanceof Byte || num2 instanceof Short || num2 instanceof Integer || num2 instanceof Long || num2 instanceof Float || num2 instanceof Double || num2 instanceof BigInteger) {
                    return this.compareBigInteger(num1, num2);
                }
                return this.compareBigDecimal(num1, num2);
            }
            return this.compareBigDecimal(num1, num2);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeBoolean(this.more > 0);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            boolean isAsc = in.readBoolean();
            this.more = isAsc ? 1 : -1;
            this.less = isAsc ? -1 : 1;
        }
    }

    public static abstract class NumberComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 688003969304020267L;

        public int compare(Object obj1, Object obj2) {
            return this.compare((Number)obj1, (Number)obj2);
        }

        public abstract int compare(Number var1, Number var2);
    }
}

