/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import jp.ossc.nimbus.io.UnicodeHexBufferedReader;

public class EncodedProperties
extends Properties {
    private static final long serialVersionUID = -3138996569732225373L;
    private Boolean mSyncObj = new Boolean(true);
    private String mEncoding;
    public static final String ENCODE_PORP = "ISO-8859-1";
    public static final String ENCODE_UTF8 = "UTF-8";
    public static final String EQUALS = "=";

    public EncodedProperties() {
        this.mEncoding = ENCODE_PORP;
    }

    public EncodedProperties(Properties prop) {
        super(prop);
        this.mEncoding = ENCODE_PORP;
    }

    public EncodedProperties(String encodeName) {
        this.mEncoding = encodeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(InputStream inStream) throws IOException {
        Boolean bl = this.mSyncObj;
        synchronized (bl) {
            try {
                if (ENCODE_PORP.equals(this.getEncoding())) {
                    super.load(inStream);
                } else {
                    this.readStream(inStream);
                }
            }
            finally {
                inStream.close();
            }
        }
    }

    private void makeKey(String rec) {
        int index = rec.indexOf(EQUALS);
        if (rec.indexOf("#") == 0 || rec.indexOf("!") == 0) {
            return;
        }
        if (index != -1) {
            String key = rec.substring(0, index);
            key = key.trim();
            String value = rec.substring(index + 1);
            value = value.trim();
            super.setProperty(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStream(InputStream stream) throws IOException {
        UnicodeHexBufferedReader in = null;
        in = new UnicodeHexBufferedReader(new InputStreamReader(stream, this.getEncoding()));
        String rec = "";
        String buf = "";
        try {
            while ((buf = in.readLine()) != null) {
                int len = buf.length();
                if (len > 1) {
                    if (buf.lastIndexOf("\\") == len - 1) {
                        buf = buf.trim();
                        len = buf.length();
                        buf = buf.substring(0, len - 1);
                        rec = rec + buf;
                        continue;
                    }
                    buf = buf.trim();
                    rec = rec + buf;
                    this.makeKey(rec);
                }
                rec = "";
            }
        }
        finally {
            in.close();
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromFile(String filePath) throws IOException {
        Boolean bl = this.mSyncObj;
        synchronized (bl) {
            FileInputStream propStream;
            FileInputStream in = propStream = new FileInputStream(filePath);
            this.load(in);
            ((InputStream)in).close();
            propStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromString(String propString) throws IOException {
        Boolean bl = this.mSyncObj;
        synchronized (bl) {
            ByteArrayInputStream propStream;
            String buf = this.getEncoding();
            this.setEncoding(ENCODE_UTF8);
            propString = UnicodeHexBufferedReader.convertUnicode(propString);
            try {
                propStream = new ByteArrayInputStream(propString.getBytes(this.getEncoding()));
            }
            catch (UnsupportedEncodingException e) {
                throw new IOException("Unsupport Encoding = " + this.mEncoding);
            }
            ByteArrayInputStream in = propStream;
            this.load(in);
            ((InputStream)in).close();
            propStream.close();
            this.setEncoding(buf);
        }
    }

    public String getEncoding() {
        return this.mEncoding;
    }

    public void setEncoding(String encoding) {
        this.mEncoding = encoding;
    }
}

