/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jp.ossc.nimbus.beans.dataset.DataSet;
import jp.ossc.nimbus.beans.dataset.DataSetException;
import jp.ossc.nimbus.beans.dataset.Header;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.beans.dataset.RecordListPropertySchema;
import jp.ossc.nimbus.beans.dataset.RecordPropertySchema;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.util.converter.BindingStreamConverter;
import jp.ossc.nimbus.util.converter.BufferedStreamConverter;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.DOMHTMLConverter;
import jp.ossc.nimbus.util.converter.StreamStringConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DataSetXMLConverter
extends BufferedStreamConverter
implements BindingStreamConverter,
StreamStringConverter {
    private static final long serialVersionUID = -7027099857625192227L;
    private static final String ELEMENT_DATASET = "dataSet";
    private static final String ELEMENT_SCHEMA = "schema";
    private static final String ELEMENT_HEADER = "header";
    private static final String ELEMENT_RECORD_LIST = "recordList";
    private static final String ELEMENT_NESTED_RECORD = "nestedRecord";
    private static final String ELEMENT_NESTED_RECORD_LIST = "nestedRecordList";
    private static final String ELEMENT_RECORD = "record";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String METHOD_NAME_SET_XML_VERSION = "setXmlVersion";
    private static final Class[] METHOD_ARGS_SET_XML_VERSION = new Class[]{String.class};
    public static final int DATASET_FROM_XML = 1;
    public static final int XML_FROM_DATASET = 2;
    protected int convertType;
    protected Map dataSetMap = new HashMap();
    protected boolean isOutputSchema = true;
    protected String xslFilePath;
    protected String characterEncodingToStream;
    protected String characterEncodingToObject;
    protected boolean isIgnoreUnknownElement;
    protected boolean isSynchronizedDomParse;
    protected String documentBuilderFactoryClass;
    protected String xmlVersion;

    public DataSetXMLConverter() {
        this(1);
    }

    public void setDocumentBuilderFactoryClassName(String clazz) {
        this.documentBuilderFactoryClass = clazz;
    }

    public DataSetXMLConverter(int type) {
        this.convertType = type;
    }

    @Override
    public void setConvertType(int type) {
        this.convertType = type;
    }

    public int getConvertType() {
        return this.convertType;
    }

    public void setDataSet(DataSet dataSet) {
        if (dataSet.getName() == null) {
            throw new IllegalArgumentException("DataSet name is null. dataSet=" + dataSet);
        }
        this.dataSetMap.put(dataSet.getName(), dataSet);
    }

    public void setDataSet(String name, DataSet dataSet) {
        if (dataSet.getName() == null) {
            dataSet.setName(name);
        }
        this.dataSetMap.put(name, dataSet);
    }

    public void setOutputSchema(boolean isOutput) {
        this.isOutputSchema = isOutput;
    }

    public boolean isOutputSchema() {
        return this.isOutputSchema;
    }

    public void setXSLFilePath(String path) {
        this.xslFilePath = path;
    }

    public String getXSLFilePath() {
        return this.xslFilePath;
    }

    @Override
    public void setCharacterEncodingToStream(String encoding) {
        this.characterEncodingToStream = encoding;
    }

    public String getCharacterEncodingToStream() {
        return this.characterEncodingToStream;
    }

    @Override
    public void setCharacterEncodingToObject(String encoding) {
        this.characterEncodingToObject = encoding;
    }

    public String getCharacterEncodingToObject() {
        return this.characterEncodingToObject;
    }

    public void setIgnoreUnknownElement(boolean isIgnore) {
        this.isIgnoreUnknownElement = isIgnore;
    }

    public boolean isIgnoreUnknownElement() {
        return this.isIgnoreUnknownElement;
    }

    public void setSynchronizedDomParse(boolean isSync) {
        this.isSynchronizedDomParse = isSync;
    }

    public boolean isSynchronizedDomParse() {
        return this.isSynchronizedDomParse;
    }

    public void setXmlVersion(String version) throws IllegalArgumentException {
        try {
            Method method = Document.class.getMethod(METHOD_NAME_SET_XML_VERSION, METHOD_ARGS_SET_XML_VERSION);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("DOM version is old. Not support to change xml version.");
        }
        this.xmlVersion = version;
    }

    public String getXmlVersion() {
        return this.xmlVersion;
    }

    @Override
    public Object convert(Object obj) throws ConvertException {
        if (obj == null) {
            return null;
        }
        switch (this.convertType) {
            case 1: {
                return this.convertToStream(obj);
            }
            case 2: {
                if (obj instanceof File) {
                    return this.toDataSet((File)obj);
                }
                if (obj instanceof InputStream) {
                    return this.toDataSet((InputStream)obj);
                }
                throw new ConvertException("Invalid input type : " + obj.getClass());
            }
        }
        throw new ConvertException("Invalid convert type : " + this.convertType);
    }

    @Override
    protected byte[] convertToByteArray(Object obj) throws ConvertException {
        if (obj instanceof DataSet) {
            return this.toXML((DataSet)obj);
        }
        throw new ConvertException("Invalid input type : " + obj.getClass());
    }

    @Override
    public Object convertToObject(InputStream is) throws ConvertException {
        return this.toDataSet(is);
    }

    @Override
    public Object convertToObject(InputStream is, Object returnType) throws ConvertException {
        if (returnType != null && !(returnType instanceof DataSet)) {
            throw new ConvertException("ReturnType is not DataSet." + returnType);
        }
        return this.toDataSet(is, (DataSet)returnType);
    }

    protected DataSet toDataSet(InputStream is) throws ConvertException {
        return this.toDataSet(is, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSet toDataSet(InputStream is, DataSet dataSet) throws ConvertException {
        try {
            InputSource inputSource = new InputSource(is);
            if (this.characterEncodingToObject != null) {
                String encoding = (String)DOMHTMLConverter.IANA2JAVA_ENCODING_MAP.get(this.characterEncodingToObject);
                if (encoding == null) {
                    encoding = this.characterEncodingToObject;
                }
                inputSource.setEncoding(encoding);
            }
            DocumentBuilderFactory domFactory = null;
            if (this.documentBuilderFactoryClass == null) {
                domFactory = DocumentBuilderFactory.newInstance();
            } else {
                try {
                    domFactory = (DocumentBuilderFactory)Class.forName(this.documentBuilderFactoryClass, true, NimbusClassLoader.getInstance()).newInstance();
                }
                catch (InstantiationException e) {
                    throw new ConvertException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ConvertException(e);
                }
                catch (ClassNotFoundException e) {
                    throw new ConvertException(e);
                }
            }
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            Document doc = null;
            if (this.isSynchronizedDomParse) {
                Class<?> lock;
                Class<?> clazz = lock = builder.getClass();
                synchronized (clazz) {
                    doc = builder.parse(inputSource);
                }
            } else {
                doc = builder.parse(inputSource);
            }
            Element dataSetElement = doc.getDocumentElement();
            String dataSetName = MetaData.getOptionalAttribute(dataSetElement, ATTRIBUTE_NAME);
            if (dataSet == null) {
                dataSet = (DataSet)this.dataSetMap.get(dataSetName);
                if (dataSet != null) {
                    dataSet = dataSet.cloneSchema();
                } else {
                    String schema;
                    Element schemaElement = MetaData.getOptionalChild(dataSetElement, ELEMENT_SCHEMA);
                    if (schemaElement == null) {
                        throw new ConvertException("Dataset is not found. name=" + dataSetName);
                    }
                    dataSet = new DataSet(dataSetName);
                    Iterator headerElements = MetaData.getChildrenByTagName(schemaElement, ELEMENT_HEADER);
                    while (headerElements.hasNext()) {
                        Element headerElement = (Element)headerElements.next();
                        String headerName = MetaData.getOptionalAttribute(headerElement, ATTRIBUTE_NAME);
                        String schema2 = MetaData.getElementContent(headerElement);
                        dataSet.setHeaderSchema(headerName, schema2);
                    }
                    Iterator recListElements = MetaData.getChildrenByTagName(schemaElement, ELEMENT_RECORD_LIST);
                    while (recListElements.hasNext()) {
                        Element recListElement = (Element)recListElements.next();
                        String recListName = MetaData.getOptionalAttribute(recListElement, ATTRIBUTE_NAME);
                        String schema3 = MetaData.getElementContent(recListElement);
                        dataSet.setRecordListSchema(recListName, schema3);
                    }
                    Iterator recElements = MetaData.getChildrenByTagName(schemaElement, ELEMENT_NESTED_RECORD);
                    while (recElements.hasNext()) {
                        Element recElement = (Element)recElements.next();
                        String recName = MetaData.getUniqueAttribute(recElement, ATTRIBUTE_NAME);
                        schema = MetaData.getElementContent(recElement);
                        dataSet.setNestedRecordSchema(recName, schema);
                    }
                    recListElements = MetaData.getChildrenByTagName(schemaElement, ELEMENT_NESTED_RECORD_LIST);
                    while (recListElements.hasNext()) {
                        Element recListElement = (Element)recListElements.next();
                        String recListName = MetaData.getUniqueAttribute(recListElement, ATTRIBUTE_NAME);
                        schema = MetaData.getElementContent(recListElement);
                        dataSet.setNestedRecordListSchema(recListName, schema);
                    }
                }
            } else {
                dataSet = dataSet.cloneSchema();
            }
            Iterator headerElements = MetaData.getChildrenByTagName(dataSetElement, ELEMENT_HEADER);
            while (headerElements.hasNext()) {
                Element headerElement = (Element)headerElements.next();
                this.readHeader(dataSet, headerElement);
            }
            Iterator recListElements = MetaData.getChildrenByTagName(dataSetElement, ELEMENT_RECORD_LIST);
            while (recListElements.hasNext()) {
                Element recListElement = (Element)recListElements.next();
                this.readRecordList(dataSet, recListElement);
            }
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
        catch (ParserConfigurationException e) {
            throw new ConvertException(e);
        }
        catch (SAXException e) {
            throw new ConvertException(e);
        }
        catch (DeploymentException e) {
            throw new ConvertException(e);
        }
        catch (DataSetException e) {
            throw new ConvertException(e);
        }
        return dataSet;
    }

    private DataSet readHeader(DataSet dataSet, Element headerElement) throws DeploymentException {
        String headerName = MetaData.getOptionalAttribute(headerElement, ATTRIBUTE_NAME);
        Header header = dataSet.getHeader(headerName);
        if (header == null) {
            if (this.isIgnoreUnknownElement) {
                return dataSet;
            }
            throw new ConvertException("Unknown header : " + headerName);
        }
        return this.readRecord(dataSet, header, headerElement);
    }

    private DataSet readRecord(DataSet dataSet, Record record, Element recordElement) throws DeploymentException {
        Iterator propElements = MetaData.getChildren(recordElement);
        RecordSchema recSchema = record.getRecordSchema();
        while (propElements.hasNext()) {
            Element propElement = (Element)propElements.next();
            String propName = propElement.getTagName();
            PropertySchema propSchema = recSchema.getPropertySchema(propName);
            if (propSchema == null && this.isIgnoreUnknownElement) continue;
            if (propSchema instanceof RecordPropertySchema) {
                Record rec;
                RecordPropertySchema recPropSchema = (RecordPropertySchema)propSchema;
                Element recElement = MetaData.getOptionalChild(propElement, ELEMENT_RECORD);
                if (recElement == null || (rec = dataSet.createNestedRecord(recPropSchema.getRecordName())) == null) continue;
                this.readRecord(dataSet, rec, recElement);
                record.setProperty(propName, (Object)rec);
                continue;
            }
            if (propSchema instanceof RecordListPropertySchema) {
                RecordList recList;
                RecordListPropertySchema recListPropSchema = (RecordListPropertySchema)propSchema;
                Element recListElement = MetaData.getOptionalChild(propElement, ELEMENT_RECORD_LIST);
                if (recListElement == null || (recList = dataSet.createNestedRecordList(recListPropSchema.getRecordListName())) == null) continue;
                this.readRecordList(dataSet, recList, recListElement);
                record.setProperty(propName, (Object)recList);
                continue;
            }
            String val = MetaData.getElementContent(propElement);
            record.setParseProperty(propName, (Object)(val == null ? "" : val));
        }
        return dataSet;
    }

    private DataSet readRecordList(DataSet dataSet, Element recListElement) throws DeploymentException {
        String recListName = MetaData.getOptionalAttribute(recListElement, ATTRIBUTE_NAME);
        RecordList recList = dataSet.getRecordList(recListName);
        if (recList == null) {
            if (this.isIgnoreUnknownElement) {
                return dataSet;
            }
            throw new ConvertException("Unknown recordList : " + recListName);
        }
        return this.readRecordList(dataSet, recList, recListElement);
    }

    private DataSet readRecordList(DataSet dataSet, RecordList recList, Element recListElement) throws DeploymentException {
        Iterator recordElements = MetaData.getChildrenByTagName(recListElement, ELEMENT_RECORD);
        while (recordElements.hasNext()) {
            Element recordElement = (Element)recordElements.next();
            Record record = recList.createRecord();
            this.readRecord(dataSet, record, recordElement);
            recList.addRecord(record);
        }
        return dataSet;
    }

    protected DataSet toDataSet(File file) throws ConvertException {
        try {
            return this.toDataSet(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
    }

    protected byte[] toXML(DataSet dataSet) throws ConvertException {
        byte[] result = null;
        try {
            DocumentBuilderFactory dbFactory = null;
            if (this.documentBuilderFactoryClass == null) {
                dbFactory = DocumentBuilderFactory.newInstance();
            } else {
                try {
                    dbFactory = (DocumentBuilderFactory)Class.forName(this.documentBuilderFactoryClass, true, NimbusClassLoader.getInstance()).newInstance();
                }
                catch (InstantiationException e) {
                    throw new ConvertException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ConvertException(e);
                }
                catch (ClassNotFoundException e) {
                    throw new ConvertException(e);
                }
            }
            DocumentBuilder docBuilder = dbFactory.newDocumentBuilder();
            Document document = docBuilder.newDocument();
            if (this.xmlVersion != null) {
                try {
                    Method method = Document.class.getMethod(METHOD_NAME_SET_XML_VERSION, METHOD_ARGS_SET_XML_VERSION);
                    method.invoke((Object)document, this.xmlVersion);
                }
                catch (NoSuchMethodException e) {
                    throw new ConvertException("DOM version is old. Not support to change xml version.", e);
                }
                catch (IllegalAccessException e) {
                    throw new ConvertException("DOM version is old. Not support to change xml version.", e);
                }
                catch (InvocationTargetException e) {
                    throw new ConvertException(e);
                }
            }
            Element dataSetElement = document.createElement(ELEMENT_DATASET);
            if (dataSet.getName() != null) {
                dataSetElement.setAttribute(ATTRIBUTE_NAME, dataSet.getName());
            }
            document.appendChild(dataSetElement);
            if (this.isOutputSchema) {
                Text schemaNode;
                RecordSchema recSchema;
                int i;
                Element schemaElement = document.createElement(ELEMENT_SCHEMA);
                dataSetElement.appendChild(schemaElement);
                String[] headerNames = dataSet.getHeaderNames();
                for (int i2 = 0; i2 < headerNames.length; ++i2) {
                    Header header = dataSet.getHeader(headerNames[i2]);
                    Element headerElement = document.createElement(ELEMENT_HEADER);
                    if (headerNames[i2] != null) {
                        headerElement.setAttribute(ATTRIBUTE_NAME, headerNames[i2]);
                    }
                    schemaElement.appendChild(headerElement);
                    Text schemaNode2 = document.createTextNode(header.getSchema());
                    headerElement.appendChild(schemaNode2);
                }
                String[] recListNames = dataSet.getRecordListNames();
                for (int i3 = 0; i3 < recListNames.length; ++i3) {
                    RecordList recList = dataSet.getRecordList(recListNames[i3]);
                    Element recListElement = document.createElement(ELEMENT_RECORD_LIST);
                    if (recListNames[i3] != null) {
                        recListElement.setAttribute(ATTRIBUTE_NAME, recListNames[i3]);
                    }
                    schemaElement.appendChild(recListElement);
                    Text schemaNode3 = document.createTextNode(recList.getSchema());
                    recListElement.appendChild(schemaNode3);
                }
                String[] recNames = dataSet.getNestedRecordSchemaNames();
                for (i = 0; i < recNames.length; ++i) {
                    recSchema = dataSet.getNestedRecordSchema(recNames[i]);
                    Element recElement = document.createElement(ELEMENT_NESTED_RECORD);
                    recElement.setAttribute(ATTRIBUTE_NAME, recNames[i]);
                    schemaElement.appendChild(recElement);
                    schemaNode = document.createTextNode(recSchema.getSchema());
                    recElement.appendChild(schemaNode);
                }
                recListNames = dataSet.getNestedRecordListSchemaNames();
                for (i = 0; i < recListNames.length; ++i) {
                    recSchema = dataSet.getNestedRecordListSchema(recListNames[i]);
                    Element recListElement = document.createElement(ELEMENT_NESTED_RECORD_LIST);
                    recListElement.setAttribute(ATTRIBUTE_NAME, recListNames[i]);
                    schemaElement.appendChild(recListElement);
                    schemaNode = document.createTextNode(recSchema.getSchema());
                    recListElement.appendChild(schemaNode);
                }
            }
            String[] headerNames = dataSet.getHeaderNames();
            for (int i = 0; i < headerNames.length; ++i) {
                Header header = dataSet.getHeader(headerNames[i]);
                this.appendRecord(dataSet, document, dataSetElement, header, ELEMENT_HEADER);
            }
            String[] recListNames = dataSet.getRecordListNames();
            for (int i = 0; i < recListNames.length; ++i) {
                RecordList recList = dataSet.getRecordList(recListNames[i]);
                this.appendRecordList(dataSet, document, dataSetElement, recList, ELEMENT_RECORD_LIST);
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = null;
            transformer = this.xslFilePath == null ? tFactory.newTransformer() : tFactory.newTransformer(new StreamSource(this.xslFilePath));
            if (this.characterEncodingToStream != null) {
                String encoding = (String)DOMHTMLConverter.IANA2JAVA_ENCODING_MAP.get(this.characterEncodingToStream);
                if (encoding == null) {
                    encoding = this.characterEncodingToStream;
                }
                transformer.setOutputProperty("encoding", encoding);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(document), new StreamResult(baos));
            result = baos.toByteArray();
        }
        catch (ParserConfigurationException e) {
            throw new ConvertException(e);
        }
        catch (TransformerConfigurationException e) {
            throw new ConvertException(e);
        }
        catch (TransformerException e) {
            throw new ConvertException(e);
        }
        catch (DataSetException e) {
            throw new ConvertException(e);
        }
        return result;
    }

    private Element appendRecord(DataSet dataSet, Document document, Element parent, Record record, String elementName) {
        String headerName;
        Element recordElement = document.createElement(elementName);
        if (record instanceof Header && (headerName = ((Header)record).getName()) != null) {
            recordElement.setAttribute(ATTRIBUTE_NAME, headerName);
        }
        parent.appendChild(recordElement);
        RecordSchema recSchema = record.getRecordSchema();
        int jmax = recSchema.getPropertySize();
        for (int j = 0; j < jmax; ++j) {
            PropertySchema propSchema = recSchema.getPropertySchema(j);
            Element propElement = document.createElement(propSchema.getName());
            if (propSchema instanceof RecordPropertySchema) {
                Record rec = (Record)record.getProperty(propSchema.getName());
                if (rec == null) continue;
                this.appendRecord(dataSet, document, propElement, rec, ELEMENT_RECORD);
                recordElement.appendChild(propElement);
                continue;
            }
            if (propSchema instanceof RecordListPropertySchema) {
                RecordList recList = (RecordList)record.getProperty(propSchema.getName());
                if (recList == null || recList.size() == 0) continue;
                this.appendRecordList(dataSet, document, propElement, recList, ELEMENT_RECORD_LIST);
                recordElement.appendChild(propElement);
                continue;
            }
            Object prop = record.getFormatProperty(propSchema.getName());
            if (prop == null) continue;
            Text valNode = document.createTextNode(prop.toString());
            propElement.appendChild(valNode);
            recordElement.appendChild(propElement);
        }
        return parent;
    }

    private Element appendRecordList(DataSet dataSet, Document document, Element parent, RecordList recList, String elementName) {
        if (recList == null || recList.size() == 0) {
            return parent;
        }
        Element recListElement = document.createElement(elementName);
        if (recList.getName() != null) {
            recListElement.setAttribute(ATTRIBUTE_NAME, recList.getName());
        }
        parent.appendChild(recListElement);
        int jmax = recList.size();
        for (int j = 0; j < jmax; ++j) {
            Record record = recList.getRecord(j);
            this.appendRecord(dataSet, document, recListElement, record, ELEMENT_RECORD);
        }
        return parent;
    }
}

