/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.net;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;

public class GlobalUID
implements Serializable,
Comparable,
Cloneable {
    private static final long serialVersionUID = -3680686440449795400L;
    protected final UID uid = new UID();
    protected final InetAddress address;

    public GlobalUID() throws UnknownHostException {
        this((InetAddress)null);
    }

    public GlobalUID(String localAddress) throws UnknownHostException {
        this.address = localAddress == null ? InetAddress.getLocalHost() : InetAddress.getByName(localAddress);
    }

    public GlobalUID(InetAddress localAddress) throws UnknownHostException {
        this.address = localAddress == null ? InetAddress.getLocalHost() : localAddress;
    }

    public UID getUID() {
        return this.uid;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GlobalUID)) {
            return false;
        }
        GlobalUID cmp = (GlobalUID)obj;
        if (!this.uid.equals(cmp.uid)) {
            return false;
        }
        return this.address.equals(cmp.address);
    }

    public int hashCode() {
        return this.uid.hashCode() + this.address.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.address).append(':');
        buf.append(this.uid.toString());
        return buf.toString();
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof GlobalUID)) {
            return -1;
        }
        GlobalUID cmp = (GlobalUID)obj;
        int result = this.address.toString().compareTo(cmp.address.toString());
        if (result != 0) {
            return result;
        }
        return this.uid.toString().compareTo(cmp.uid.toString());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

