/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.sql;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.util.sql.ResultSetWrapper;
import jp.ossc.nimbus.util.sql.StatementWrapper;

public class ConnectionWrapper
implements Connection,
Serializable {
    private static final long serialVersionUID = 6168176679889807870L;
    protected Connection connection;
    protected Class statementWrapperClass;
    protected Class callableStatementWrapperClass;
    protected Class preparedStatementWrapperClass;
    protected Class resultSetWrapperClass;
    protected Map statementProperties;
    protected Map callableStatementProperties;
    protected Map preparedStatementProperties;
    protected Map resultSetProperties;

    public ConnectionWrapper(Connection con) {
        this.connection = con;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection con) {
        this.connection = con;
    }

    public void setStatementWrapperClass(Class clazz) throws IllegalArgumentException {
        if (clazz != null && !StatementWrapper.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Illegal class : " + clazz.getName());
        }
        this.statementWrapperClass = clazz;
    }

    public Class getStatementWrapperClass() {
        return this.statementWrapperClass;
    }

    public void setCallableStatementWrapperClass(Class clazz) throws IllegalArgumentException {
        if (!(clazz == null || CallableStatement.class.isAssignableFrom(clazz) && StatementWrapper.class.isAssignableFrom(clazz))) {
            throw new IllegalArgumentException("Illegal class : " + clazz.getName());
        }
        this.callableStatementWrapperClass = clazz;
    }

    public Class getCallableStatementWrapperClass() {
        return this.callableStatementWrapperClass;
    }

    public void setPreparedStatementWrapperClass(Class clazz) throws IllegalArgumentException {
        if (!(clazz == null || PreparedStatement.class.isAssignableFrom(clazz) && StatementWrapper.class.isAssignableFrom(clazz))) {
            throw new IllegalArgumentException("Illegal class : " + clazz.getName());
        }
        this.preparedStatementWrapperClass = clazz;
    }

    public Class getPreparedStatementWrapperClass() {
        return this.preparedStatementWrapperClass;
    }

    public void setResultSetWrapperClass(Class clazz) throws IllegalArgumentException {
        if (clazz != null && !ResultSetWrapper.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Illegal class : " + clazz.getName());
        }
        this.resultSetWrapperClass = clazz;
    }

    public Class getResultSetWrapperClass() {
        return this.resultSetWrapperClass;
    }

    public void setAllStatementProperties(Map props) {
        this.setStatementProperties(props);
        this.setCallableStatementProperties(props);
        this.setPreparedStatementProperties(props);
    }

    public void setAllStatementProperty(String name, Object value) {
        this.setStatementProperty(name, value);
        this.setCallableStatementProperty(name, value);
        this.setPreparedStatementProperty(name, value);
    }

    public void setStatementProperties(Map props) {
        if (props == null || props.size() == 0) {
            if (this.statementProperties != null) {
                this.statementProperties = null;
            }
            return;
        }
        for (String name : props.keySet()) {
            this.setStatementProperty(name, props.get(name));
        }
    }

    public void setStatementProperty(String name, Object value) {
        if (this.statementProperties == null) {
            this.statementProperties = new LinkedHashMap();
        }
        Property prop = PropertyFactory.createProperty(name);
        this.statementProperties.put(prop, value);
    }

    public Object getStatementProperty(String name) {
        if (this.statementProperties == null) {
            return null;
        }
        for (Property prop : this.statementProperties.keySet()) {
            if (!prop.getPropertyName().equals(name)) continue;
            return this.statementProperties.get(prop);
        }
        return null;
    }

    public void setCallableStatementProperties(Map props) {
        if (props == null || props.size() == 0) {
            if (this.callableStatementProperties != null) {
                this.callableStatementProperties = null;
            }
            return;
        }
        for (String name : props.keySet()) {
            this.setCallableStatementProperty(name, props.get(name));
        }
    }

    public void setCallableStatementProperty(String name, Object value) {
        if (this.callableStatementProperties == null) {
            this.callableStatementProperties = new LinkedHashMap();
        }
        Property prop = PropertyFactory.createProperty(name);
        this.callableStatementProperties.put(prop, value);
    }

    public Object getCallableStatementProperty(String name) {
        if (this.callableStatementProperties == null) {
            return null;
        }
        for (Property prop : this.callableStatementProperties.keySet()) {
            if (!prop.getPropertyName().equals(name)) continue;
            return this.callableStatementProperties.get(prop);
        }
        return null;
    }

    public void setPreparedStatementProperties(Map props) {
        if (props == null || props.size() == 0) {
            if (this.preparedStatementProperties != null) {
                this.preparedStatementProperties = null;
            }
            return;
        }
        for (String name : props.keySet()) {
            this.setPreparedStatementProperty(name, props.get(name));
        }
    }

    public void setPreparedStatementProperty(String name, Object value) {
        if (this.preparedStatementProperties == null) {
            this.preparedStatementProperties = new LinkedHashMap();
        }
        Property prop = PropertyFactory.createProperty(name);
        this.preparedStatementProperties.put(prop, value);
    }

    public Object getPreparedStatementProperty(String name) {
        if (this.preparedStatementProperties == null) {
            return null;
        }
        for (Property prop : this.preparedStatementProperties.keySet()) {
            if (!prop.getPropertyName().equals(name)) continue;
            return this.preparedStatementProperties.get(prop);
        }
        return null;
    }

    public void setResultSetProperties(Map props) {
        if (props == null || props.size() == 0) {
            if (this.resultSetProperties != null) {
                this.resultSetProperties = null;
            }
            return;
        }
        for (String name : props.keySet()) {
            this.setResultSetProperty(name, props.get(name));
        }
    }

    public void setResultSetProperty(String name, Object value) {
        if (this.resultSetProperties == null) {
            this.resultSetProperties = new LinkedHashMap();
        }
        this.resultSetProperties.put(name, value);
    }

    public Object getResultSetProperty(String name) {
        if (this.resultSetProperties == null) {
            return null;
        }
        return this.resultSetProperties.get(name);
    }

    protected Statement createStatementWrapper(Statement stmt) throws SQLException {
        if (this.statementWrapperClass == null) {
            return stmt;
        }
        StatementWrapper result = null;
        try {
            Constructor constructor = this.statementWrapperClass.getConstructor(Connection.class, Statement.class);
            result = (StatementWrapper)constructor.newInstance(this, stmt);
            this.applyStatementProperties(result);
        }
        catch (InvocationTargetException e) {
            throw new SQLException(e.getTargetException().toString());
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
        return result;
    }

    protected void applyStatementProperties(StatementWrapper stmtw) throws Exception {
        this.applyStatementProperties(stmtw, this.statementProperties);
    }

    protected CallableStatement createCallableStatementWrapper(CallableStatement stmt, String sql) throws SQLException {
        if (this.callableStatementWrapperClass == null) {
            return stmt;
        }
        StatementWrapper result = null;
        try {
            Constructor constructor = this.callableStatementWrapperClass.getConstructor(Connection.class, CallableStatement.class, String.class);
            result = (StatementWrapper)constructor.newInstance(this, stmt, sql);
            this.applyCallableStatementProperties(result);
        }
        catch (InvocationTargetException e) {
            throw new SQLException(e.getTargetException().toString());
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
        return (CallableStatement)((Object)result);
    }

    protected void applyCallableStatementProperties(StatementWrapper stmtw) throws Exception {
        this.applyStatementProperties(stmtw, this.callableStatementProperties);
    }

    protected PreparedStatement createPreparedStatementWrapper(PreparedStatement stmt, String sql) throws SQLException {
        if (this.preparedStatementWrapperClass == null) {
            return stmt;
        }
        StatementWrapper result = null;
        try {
            Constructor constructor = this.preparedStatementWrapperClass.getConstructor(Connection.class, PreparedStatement.class, String.class);
            result = (StatementWrapper)constructor.newInstance(this, stmt, sql);
            this.applyPreparedStatementProperties(result);
        }
        catch (InvocationTargetException e) {
            throw new SQLException(e.getTargetException().toString());
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
        return (PreparedStatement)((Object)result);
    }

    protected void applyPreparedStatementProperties(StatementWrapper stmtw) throws Exception {
        this.applyStatementProperties(stmtw, this.preparedStatementProperties);
    }

    protected void applyStatementProperties(StatementWrapper stmt, Map properties) throws Exception {
        if (this.resultSetWrapperClass != null) {
            stmt.setResultSetWrapperClass(this.resultSetWrapperClass);
            if (this.resultSetProperties != null && this.resultSetProperties.size() != 0) {
                for (String name : this.resultSetProperties.keySet()) {
                    stmt.setResultSetProperty(name, this.resultSetProperties.get(name));
                }
            }
        }
        if (properties != null && properties.size() != 0) {
            for (Property prop : properties.keySet()) {
                prop.setProperty(stmt, properties.get(prop));
            }
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.connection.getHoldability();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.connection.close();
    }

    @Override
    public void commit() throws SQLException {
        this.connection.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public void setHoldability(int arg0) throws SQLException {
        this.connection.setHoldability(arg0);
    }

    @Override
    public void setTransactionIsolation(int arg0) throws SQLException {
        this.connection.setTransactionIsolation(arg0);
    }

    @Override
    public void setAutoCommit(boolean arg0) throws SQLException {
        this.connection.setAutoCommit(arg0);
    }

    @Override
    public void setReadOnly(boolean arg0) throws SQLException {
        this.connection.setReadOnly(arg0);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    @Override
    public void setCatalog(String arg0) throws SQLException {
        this.connection.setCatalog(arg0);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.connection.setSavepoint();
    }

    @Override
    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        this.connection.releaseSavepoint(arg0);
    }

    @Override
    public void rollback(Savepoint arg0) throws SQLException {
        this.connection.rollback(arg0);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatementWrapper(this.connection.createStatement());
    }

    @Override
    public Statement createStatement(int arg0, int arg1) throws SQLException {
        return this.createStatementWrapper(this.connection.createStatement(arg0, arg1));
    }

    @Override
    public Statement createStatement(int arg0, int arg1, int arg2) throws SQLException {
        return this.createStatementWrapper(this.connection.createStatement(arg0, arg1, arg2));
    }

    public Map getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    public void setTypeMap(Map arg0) throws SQLException {
        this.connection.setTypeMap(arg0);
    }

    @Override
    public String nativeSQL(String arg0) throws SQLException {
        return this.connection.nativeSQL(arg0);
    }

    @Override
    public CallableStatement prepareCall(String arg0) throws SQLException {
        return this.createCallableStatementWrapper(this.connection.prepareCall(arg0), arg0);
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2) throws SQLException {
        return this.createCallableStatementWrapper(this.connection.prepareCall(arg0, arg1, arg2), arg0);
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        return this.createCallableStatementWrapper(this.connection.prepareCall(arg0, arg1, arg2, arg3), arg0);
    }

    @Override
    public PreparedStatement prepareStatement(String arg0) throws SQLException {
        return this.createPreparedStatementWrapper(this.connection.prepareStatement(arg0), arg0);
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1) throws SQLException {
        return this.createPreparedStatementWrapper(this.connection.prepareStatement(arg0, arg1), arg0);
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2) throws SQLException {
        return this.createPreparedStatementWrapper(this.connection.prepareStatement(arg0, arg1, arg2), arg0);
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        return this.createPreparedStatementWrapper(this.connection.prepareStatement(arg0, arg1, arg2, arg3), arg0);
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int[] arg1) throws SQLException {
        return this.createPreparedStatementWrapper(this.connection.prepareStatement(arg0, arg1), arg0);
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, String[] arg1) throws SQLException {
        return this.createPreparedStatementWrapper(this.connection.prepareStatement(arg0, arg1), arg0);
    }

    @Override
    public Savepoint setSavepoint(String arg0) throws SQLException {
        return this.connection.setSavepoint(arg0);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.connection.createStruct(typeName, attributes);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.connection.createArrayOf(typeName, elements);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.connection.getClientInfo();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.connection.getClientInfo(name);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.connection.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.connection.setClientInfo(name, value);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.connection.isValid(timeout);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.connection.createSQLXML();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.connection.createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.connection.createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.connection.createNClob();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.connection.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.connection.unwrap(iface);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.connection.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.connection.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.connection.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.connection.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.connection.getNetworkTimeout();
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.isClosed()) {
                this.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        super.finalize();
    }
}

