/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.sql;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.util.sql.ResultSetWrapper;

public class StatementWrapper
implements Statement,
Serializable {
    private static final long serialVersionUID = -3678006522511003450L;
    protected Connection connection;
    protected Statement statement;
    protected Class resultSetWrapperClass;
    protected Map resultSetProperties;

    public StatementWrapper(Statement st) {
        this(null, st);
    }

    public StatementWrapper(Connection con, Statement st) {
        this.connection = con;
        this.statement = st;
    }

    public void setStatement(Statement st) {
        this.statement = st;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setResultSetWrapperClass(Class clazz) throws IllegalArgumentException {
        if (clazz != null && !ResultSetWrapper.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Illegal class : " + clazz.getName());
        }
        this.resultSetWrapperClass = clazz;
    }

    public Class getResultSetWrapperClass() {
        return this.resultSetWrapperClass;
    }

    public void setResultSetProperty(String name, Object value) {
        if (this.resultSetProperties == null) {
            this.resultSetProperties = new LinkedHashMap();
        }
        Property prop = PropertyFactory.createProperty(name);
        this.resultSetProperties.put(prop, value);
    }

    public Object getResultSetProperty(String name) {
        if (this.resultSetProperties == null) {
            return null;
        }
        for (Property prop : this.resultSetProperties.keySet()) {
            if (!prop.getPropertyName().equals(name)) continue;
            return this.resultSetProperties.get(prop);
        }
        return null;
    }

    protected ResultSet createResultSetWrapper(ResultSet rs) throws SQLException {
        if (this.resultSetWrapperClass == null) {
            return rs;
        }
        ResultSetWrapper result = null;
        try {
            Constructor constructor = this.resultSetWrapperClass.getConstructor(ResultSet.class);
            result = (ResultSetWrapper)constructor.newInstance(rs);
            this.applyResultSetProperties(result);
        }
        catch (InvocationTargetException e) {
            throw new SQLException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        return result;
    }

    protected void applyResultSetProperties(ResultSetWrapper rsw) throws Exception {
        if (this.resultSetProperties == null || this.resultSetProperties.size() == 0) {
            return;
        }
        for (Property prop : this.resultSetProperties.keySet()) {
            prop.setProperty(rsw, this.resultSetProperties.get(prop));
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.statement.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.statement.getFetchSize();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.statement.getMaxFieldSize();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.statement.getMaxRows();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.statement.getQueryTimeout();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.statement.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.statement.getResultSetHoldability();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.statement.getResultSetType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.statement.getUpdateCount();
    }

    @Override
    public void cancel() throws SQLException {
        this.statement.cancel();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.statement.clearBatch();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.statement.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.statement.close();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.statement.getMoreResults();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.statement.executeBatch();
    }

    @Override
    public void setFetchDirection(int arg0) throws SQLException {
        this.statement.setFetchDirection(arg0);
    }

    @Override
    public void setFetchSize(int arg0) throws SQLException {
        this.statement.setFetchSize(arg0);
    }

    @Override
    public void setMaxFieldSize(int arg0) throws SQLException {
        this.statement.setMaxFieldSize(arg0);
    }

    @Override
    public void setMaxRows(int arg0) throws SQLException {
        this.statement.setMaxRows(arg0);
    }

    @Override
    public void setQueryTimeout(int arg0) throws SQLException {
        this.statement.setQueryTimeout(arg0);
    }

    @Override
    public boolean getMoreResults(int arg0) throws SQLException {
        return this.statement.getMoreResults(arg0);
    }

    @Override
    public void setEscapeProcessing(boolean arg0) throws SQLException {
        this.statement.setEscapeProcessing(arg0);
    }

    @Override
    public int executeUpdate(String arg0) throws SQLException {
        return this.statement.executeUpdate(arg0);
    }

    @Override
    public void addBatch(String arg0) throws SQLException {
        this.statement.addBatch(arg0);
    }

    @Override
    public void setCursorName(String arg0) throws SQLException {
        this.statement.setCursorName(arg0);
    }

    @Override
    public boolean execute(String arg0) throws SQLException {
        return this.statement.execute(arg0);
    }

    @Override
    public int executeUpdate(String arg0, int arg1) throws SQLException {
        return this.statement.executeUpdate(arg0, arg1);
    }

    @Override
    public boolean execute(String arg0, int arg1) throws SQLException {
        return this.statement.execute(arg0, arg1);
    }

    @Override
    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        return this.statement.executeUpdate(arg0, arg1);
    }

    @Override
    public boolean execute(String arg0, int[] arg1) throws SQLException {
        return this.statement.execute(arg0, arg1);
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.connection == null) {
            return this.statement.getConnection();
        }
        return this.connection;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.createResultSetWrapper(this.statement.getGeneratedKeys());
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.createResultSetWrapper(this.statement.getResultSet());
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.statement.getWarnings();
    }

    @Override
    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        return this.statement.executeUpdate(arg0, arg1);
    }

    @Override
    public boolean execute(String arg0, String[] arg1) throws SQLException {
        return this.statement.execute(arg0, arg1);
    }

    @Override
    public ResultSet executeQuery(String arg0) throws SQLException {
        return this.createResultSetWrapper(this.statement.executeQuery(arg0));
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.statement.isPoolable();
    }

    @Override
    public void setPoolable(boolean isPoolable) throws SQLException {
        this.statement.setPoolable(isPoolable);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.statement.isClosed();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.statement.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.statement.unwrap(iface);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.statement.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.statement.isCloseOnCompletion();
    }
}

