
import java.io.*;
import java.sql.*;
import java.util.*;

import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.io.CSVRecordReader;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.ConnectionFactoryException;
import jp.ossc.nimbus.service.connection.PersistentManager;
import jp.ossc.nimbus.service.connection.PersistentException;

/**
 * TvWsNXB
 */
public class Main{
    
    public static final void main(String[] args){
        
        // T[rX`t@C[h
        if(ServiceManagerFactory.loadManager("service-definition.xml")){
            System.out.println("T[rX`̓ǂݍ݂ɐ܂B");
            
            // ConnectionFactoryT[rX擾
            ConnectionFactory factory = (ConnectionFactory)ServiceManagerFactory
                .getServiceObject("ConnectionFactory");
            
            // PersistentManagerT[rX擾
            PersistentManager pm = (PersistentManager)ServiceManagerFactory
                .getServiceObject("PersistentManager");
            
            Connection con = null;
            FileInputStream fis = null;
            try{
                // ͂ƂȂ郆[UXgCSVt@CI[v
                fis = new FileInputStream("userlist.csv");
                
                // Xg[CSVRecordReaderŃbv
                CSVRecordReader reader = new CSVRecordReader(new InputStreamReader(fis));
                reader.setCommentPrefix("#");
                
                // Connection̎擾
                con = factory.getConnection();
                
                // f[^x[Xւ̃ob`݂sBatchExecutor𐶐
                PersistentManager.BatchExecutor executor = pm.createQueryBatchExecutor(con, "insert into MYUSER(name, age, sex) values(?<-{name}, ?<-{age}, ?<-{sex})");
                // 5ob`s悤ɐݒ
                executor.setAutoBatchPersistCount(5);
                
                // CSVt@CPsǂݍ݂Ȃf[^x[XɃob`sINSERT
                Record record = new Record(
                    ":name,java.lang.String\n"
                     + ":age,int\n"
                     + ":sex,int\n"
                );
                Record tmpRecord = record;
                int updateCount = 0;
                int total = 0;
                System.out.println("f[^x[Xւ̏݊Jn");
                while((tmpRecord = reader.readRecord(tmpRecord)) != null){
                    updateCount = executor.addBatch(tmpRecord);
                    if(updateCount > 0){
                        System.out.println("MYUSERe[u " + updateCount + " INSERT܂B");
                    }
                    total+=updateCount;
                }
                updateCount = executor.persist();
                if(updateCount > 0){
                    System.out.println("MYUSERe[u " + updateCount + " INSERT܂B");
                }
                total+=updateCount;
                System.out.println("MYUSERe[uɍv " + total + " INSERT܂B");
                executor.close();
                fis.close();
                fis = null;
                
                // f[^x[X̃J[\ǂݏosCursor𐶐
                PersistentManager.Cursor cursor = pm.createCursor(con, "select name, age, sex from MYUSER", null, null, null);
                
                // f[^x[XSELECTR[hPsJ[\ړȂo͂
                System.out.println("f[^x[X̓ǂݍ݊Jn");
                while(cursor.next()){
                    cursor.load(record);
                    System.out.println("    " + record);
                }
                cursor.close();
            }catch(IOException e){
                e.printStackTrace();
                System.exit(-1);
            }catch(ConnectionFactoryException e){
                e.printStackTrace();
                System.exit(-1);
            }catch(PersistentException e){
                e.printStackTrace();
                System.exit(-1);
            }finally{
                if(fis != null){
                    try{
                        fis.close();
                    }catch(IOException e){
                        e.printStackTrace();
                    }
                }
                if(con != null){
                    try{
                        con.close();
                    }catch(SQLException e){
                        e.printStackTrace();
                    }
                }
            }
        }else{
            System.out.println("T[rX`̓ǂݍ݂Ɏs܂B");
        }
        
        // T[rX`t@CA[h
        ServiceManagerFactory.unloadManager("service-definition.xml");
    }
}