/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/10/15
 */
public abstract class Quadro implements NinaEvent {

	/**
	 * 
	 *
	 *
	 * @author MORIGUCHI, Yuichiro 2013/10/02
	 */
	public static enum Direction {
		WEST, EAST, NORTH, SOUTH, CR
	}

	//
	static final int EQ_TO_LEFT = -1;
	static final int BLANKX = -2;
	static final int BLANKY = -3;
	static final int E2 = -100;
	static final int W2 = -101;
	static final int N2 = -102;
	static final int S2 = -103;
	static final int E3 = -200;
	static final int W3 = -201;
	static final int N3 = -202;
	static final int S3 = -203;
	static final int DONE = -300;
	static final int ENTRY = -301;
	static final int WARP2 = -400;
	static final int WARP3 = -402;
	static final int BRANCH   = -5000000;
	static final int BRANCH_N = 1000;
	static final int BRANCH_E =  100;
	static final int BRANCH_S =   10;
	static final int BRANCH_W =    1;

	Map<String, String> options = new HashMap<String, String>();
	Map<String, String> aliases = new HashMap<String, String>();
	List<String> imports = new ArrayList<String>();
	String fragment, type;

	static int len(char c) {
		Character.UnicodeBlock b;

		b = Character.UnicodeBlock.of(c);
		if(b == null) {
			return 1;
		} else if(c >= 0xff01 && c <= 0xff60) {
			return 2;
		} else if(c >= 0xffe0 && c <= 0xffe6) {
			return 2;
		} else if(b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY) ||
				b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS) ||
				b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS) ||
				b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT) ||
				b.equals(Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT) ||
//				b.equals(Character.UnicodeBlock.CJK_STROKES) ||
				b.equals(Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION) ||
				b.equals(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS) ||
				b.equals(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A) ||
				b.equals(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B) ||
				b.equals(Character.UnicodeBlock.KATAKANA) ||
				b.equals(Character.UnicodeBlock.HIRAGANA) ||
				b.equals(Character.UnicodeBlock.HANGUL_SYLLABLES)) {
			return 2;
		} else {
			return 1;
		}
	}

	static int len(String s) {
		int r = 0;

		for(int i = 0; i < s.length(); i++) {
			r = r + len(s.charAt(i));
		}
		return r;
	}

	static int putWedgeN(int x) {
		if(x == '+') {
			return BRANCH - BRANCH_N;
		} else if(x < BRANCH) {
			return x - BRANCH_N;
		} else {
			throw new RuntimeException();
		}
	}

	static int putWedgeE(int x) {
		if(x == '+') {
			return BRANCH - BRANCH_E;
		} else if(x < BRANCH) {
			return x - BRANCH_E;
		} else {
			throw new RuntimeException();
		}
	}

	static int putWedgeS(int x) {
		if(x == '+') {
			return BRANCH - BRANCH_S;
		} else if(x < BRANCH) {
			return x - BRANCH_S;
		} else {
			throw new RuntimeException();
		}
	}

	static int putWedgeW(int x) {
		if(x == '+') {
			return BRANCH - BRANCH_W;
		} else if(x < BRANCH) {
			return x - BRANCH_W;
		} else {
			throw new RuntimeException();
		}
	}

	/**
	 * 
	 * @param classe
	 * @return
	 * @throws IOException
	 */
	public static Quadro readResource(String name) throws IOException {
		InputStream in = null;
		Reader rd;

		try {
			in = Quadro.class.getResourceAsStream(name);
			rd = new InputStreamReader(in);
			return read(name, rd);
		} finally {
			if(in != null)  in.close();
		}
	}

	/**
	 * 
	 * @param s
	 * @return
	 */
	public static Quadro read(String name, String s) {
		StringReader r;

		try {
			r = new StringReader(s);
			return read(name, r);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * 
	 * @param name
	 * @param rd
	 * @return
	 * @throws IOException
	 */
	public static Quadro read(String name,
			Reader rd) throws IOException {
		BufferedReader br = new BufferedReader(rd);
		List<int[]> l = new ArrayList<int[]>();
		StringWriter sw = new StringWriter();
		PrintWriter pw = new PrintWriter(sw);
		String s;
		int[] a;
		int m;

		while((s = br.readLine()) != null && !s.equals("%%")) {
			if(s.equals(""))  continue;
			a = new int[len(s)];
			for(int i = 0, j = 0; j < s.length(); i += m, j++) {
				m = len(s.charAt(j));
				a[i] = s.charAt(j);
				for(int k = i + 1; k < i + m; k++) {
					a[k] = QuadroImpl.EQ_TO_LEFT;
				}
			}
			l.add(a);
		}

		while((s = br.readLine()) != null) {
			pw.println(s);
		}
		pw.flush();
		return new QuadroImpl(name, l, sw.toString());
	}

	/**
	 * 
	 * @param s
	 * @return
	 */
	public String getOption(String s) {
		return options.get(s);
	}

	/**
	 * 
	 * @param s
	 * @return
	 */
	public boolean isOptionDefined(String s) {
		return options.get(s) != null;
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaEvent#getOptionBoolean(java.lang.String)
	 */
	@Override
	public boolean getOptionBoolean(String s) {
		String x;

		if((x = options.get(s)) == null)  return false;
		return (x.equalsIgnoreCase("true") ||
				x.equalsIgnoreCase("yes")  ||
				x.equalsIgnoreCase("on")   ||
				x.equalsIgnoreCase("oui"));
	}

	/**
	 * 
	 * @param s
	 * @return
	 */
	public String getAlias(String s) {
		return aliases.get(s);
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaEvent#getCharset()
	 */
	@Override
	public String getCharset() {
		String s;

		return (s = options.get("charset")) != null ? s : "UTF-8";
	}

	/**
	 * 
	 * @return
	 */
	public String getType() {
		return type;
	}

	/**
	 * 
	 * @return
	 */
	public List<String> getImports() {
		return Collections.unmodifiableList(imports);
	}

	//
	void addImports(String s) {
		imports.add(s);
	}

	/**
	 * 
	 * @return
	 */
	public String getFragment() {
		return fragment != null ? fragment : "";
	}

	/**
	 * 
	 * @return the rootResource
	 */
	public abstract String getRootResource();

	/**
	 * 
	 * @return the rootPackage
	 */
	public abstract String getRootPackage();

	/**
	 * 
	 * @return
	 */
	public abstract String getName();

	/**
	 * 
	 * @param x
	 */
	public abstract void setRootResource(String x);

	/**
	 * 
	 * @param x
	 */
	public abstract void setRootPackage(String x);

	/**
	 * @return the edge
	 */
	public abstract Object getEdge();

	/**
	 * @param edge the edge to set
	 */
	public abstract void setEdge(Object edge);

	/**
	 * 
	 * @return
	 */
	public abstract boolean isInBounds();

	/**
	 * 
	 * @return
	 */
	public abstract int get();

	/**
	 * 
	 * @return
	 */
	public abstract Object getScratch();

	/**
	 * 
	 * @return
	 */
	public abstract Object getScratch2();

	/**
	 * 
	 * @return
	 */
	public abstract boolean isBlankX();

	/**
	 * 
	 * @return
	 */
	public abstract boolean isBlankY();

	/**
	 * 
	 * @return
	 */
	public abstract boolean isLetter();

	/**
	 * 
	 * @return
	 */
	public abstract boolean isDigit();

	/**
	 * 
	 * @return
	 */
	public abstract boolean isArrow();

	/**
	 * 
	 * @return
	 */
	public abstract boolean isEntry();

	/**
	 * 
	 * @return
	 */
	public abstract boolean isDone();

	/**
	 * 
	 * @return
	 */
	public abstract boolean isFrame();

	/**
	 * 
	 * @return
	 */
	public abstract boolean isArrow2();

	/**
	 * 
	 * @return
	 */
	public abstract boolean isArrow3();

	/**
	 * 
	 * @return
	 */
	public abstract boolean isWhitespace();

	/**
	 * 
	 * @return
	 */
	public abstract boolean isBranch();

	/**
	 * 
	 * @return
	 */
	public abstract boolean isBranchN();

	/**
	 * 
	 * @return
	 */
	public abstract boolean isBranchE();

	/**
	 * 
	 * @return
	 */
	public abstract boolean isBranchS();

	/**
	 * 
	 * @return
	 */
	public abstract boolean isBranchW();

	/**
	 * 
	 * @return
	 */
	public abstract boolean isWedgeN();

	/**
	 * 
	 * @return
	 */
	public abstract boolean isWedgeE();

	/**
	 * 
	 * @return
	 */
	public abstract boolean isWedgeS();

	/**
	 * 
	 * @return
	 */
	public abstract boolean isWedgeW();

	/**
	 * 
	 * @param a
	 */
	public abstract void set(int a);

	/**
	 * 
	 * @param a
	 */
	public abstract void setScratch(Object a);

	/**
	 * 
	 * @param a
	 */
	public abstract void setScratch2(Object a);

	/**
	 * 
	 * @param d
	 * @return
	 */
	public abstract Quadro move(Quadro.Direction d);

	/**
	 * 
	 * @param x
	 * @param y
	 * @return
	 */
	public abstract Quadro move(int x, int y);

	/**
	 * 
	 * @return
	 */
	public abstract Quadro west();

	/**
	 * 
	 * @return
	 */
	public abstract Quadro east();

	/**
	 * 
	 * @return
	 */
	public abstract Quadro north();

	/**
	 * 
	 * @return
	 */
	public abstract Quadro south();

	/**
	 * 
	 * @return
	 */
	public abstract Quadro cr();

	/**
	 * 
	 * @param pr
	 */
	public void printTrace(PrintStream pr) {
		pr.println(toString());
	}

}
