/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina.translate;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

import net.morilib.nina.Nina;
import net.morilib.nina.NinaParser;
import net.morilib.nina.Quadro;
import net.morilib.nina.cmd.NinatOptions;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/12/11
 */
public class ProxyNinaTranslator implements NinaTranslator {

	//
	private NinaTranslator proxy = null;

	/* (non-Javadoc)
	 * @see net.morilib.nina.translate.NinaTranslator#translateQuadro(net.morilib.nina.Quadro, net.morilib.nina.cmd.NinatOptions, java.util.Map)
	 */
	@Override
	public void translateQuadro(String name, Quadro q, Object o,
			NinatOptions opts, Map<String, String> prms,
			Map<String, Object> sub) throws IOException {
		proxy.translateQuadro(name, q, o, opts, prms, sub);
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.translate.NinaTranslator#reportStatistics(java.io.PrintStream)
	 */
	@Override
	public void reportStatistics(PrintStream std) {
		proxy.reportStatistics(std);
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.translate.NinaTranslator#getAutomaton(java.lang.String)
	 */
	@Override
	public Object getAutomaton(String s) {
		return proxy.getAutomaton(s);
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.translate.NinaTranslator#getAutomata()
	 */
	@Override
	public Map<String, ?> getAutomata() {
		return proxy.getAutomata();
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.compiler.NinaTranslater#translate(java.io.Reader, java.io.PrintWriter)
	 */
	@Override
	public void translate(String name, Reader rd, NinatOptions opts,
			Map<String, String> prms) throws IOException {
		Map<String, Object> s;
		Quadro q;
		String l;
		Object o;
		String n;

		s = new HashMap<String, Object>();
		n = Nina.getFAName(name);
		s.put(n, null);
		q = Quadro.read(n, rd);
		o = NinaParser.complie(q, opts.getLibraryList(), prms, s);
		l = q.getOption("targetLanguage");
		if(l != null && !l.equals("")) {
			proxy = AbstractNinaTranslator.getTranslator(l);
		} else {
			proxy = new NinaTranslatorJava();
		}
		translateQuadro(n, q, o, opts, prms, s);
	}

}
