/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Translated by Nina
package net.morilib.nina.translate;

import java.io.IOException;

import net.morilib.nina.NinaException;

/**
 * 
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/12/11
 */
public class ReplaceDollar {

	private int state;
	private int unread = -1;

	private StringBuffer b1;

	ReplaceDollar() {
		b1 = new StringBuffer();
	}

	/**
	 * 
	 * @param s
	 * @return
	 */
	public static String replace(String s) {
		ReplaceDollar r = new ReplaceDollar();

		try {
			r.parse(new java.io.StringReader(s));
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
		return r.b1.toString();
	}

	private int _read(java.io.Reader rd) throws java.io.IOException {
		int c;

		if(unread < 0) {
			return rd.read();
		} else {
			c = unread;
			unread = -1;
			return c;
		}
	}

	private boolean _step(int c) {
		switch(state) {
		case 0:
			if(c >= 34 && c <= 34) {
				state = 1;
				return true;
			} else if(c >= 36 && c <= 36) {
				state = 2;
				return true;
			} else {
				state = 0;
				return true;
			}
		case 2:
			if(c >= 36 && c <= 36) {
				state = 3;
				return true;
			} else if(c >= 99 && c <= 99) {
				state = 4;
				return true;
			}
			return false;
		case 4:
			if(c >= 34 && c <= 34) {
				state = 1;
				return true;
			} else {
				state = 0;
				return true;
			}
		case 3:
			if(c >= 34 && c <= 34) {
				state = 1;
				return true;
			} else {
				state = 0;
				return true;
			}
		case 1:
			if(c >= 34 && c <= 34) {
				state = 0;
				return true;
			} else {
				state = 1;
				return true;
			}
		}
		return false;
	}

	private boolean _accepted() {
		return (state == 0 ||
				state == 3 ||
				state == 4);
	}

	private void _execaction(int  $c) {
		switch(state) {
		case 2:
			break;
		case 0:
			{if($c >= 0)  b1.appendCodePoint($c); }
			break;
		case 1:
			{ b1.appendCodePoint($c); }
			break;
		case 3:
			{ b1.append("__b__"); }
			break;
		case 4:
			{ b1.append("__c__"); }
			break;
		}
	}

	private boolean parse(
			java.io.Reader rd) throws java.io.IOException {
		int p, c;

		for(p = -2; (c = _read(rd)) >= 0; p = c) {
			_execaction(p);
			if(!_step(c)) {
				throw new NinaException("invalidaction");
			}
		}
		_execaction(p);
		return _accepted();
	}

}
