cat > /output/${OUTPUT_FILENAME}.h << EOF
/* Translated by Nina */
/* This source code is under public domain */

#ifndef DEFINED_NINA_COMMON
#define DEFINED_NINA_COMMON

#include <stdio.h>
#include <setjmp.h>
#define ENDMARKER ((void *)1)
#define STATE (__o__->state)
#define INITIAL 0
#define THROW_CODE_ACCEPT 91
#define THROW_CODE_REJECT 85
#define THROW_CODE_ERROR  72
#define NEW_NINA_STREAM_FILE(f)   ((nina_stream_t)(&(f)))
#define NEW_NINA_STREAM_STRING(s) ((nina_stream_t)(&(s)))

typedef void **nina_stream_t;
#endif

#ifndef DEFINED_${FILENAME}
#define DEFINED_${FILENAME}

#define UNGET(c)       (${FILENAME}__unread(__o__, (c)))
#define GOTOSYMBOL(c)  (${FILENAME}__gotoSymbol(__o__, (c)))
#define THROWERROR     longjmp(__o__->ex, THROW_CODE_ERROR);

typedef struct ${FILENAME}_tag {
	int state;
	int unread;
	int gotoSymbol;
	void *iseof;
	char buf[${BUFSIZE}];
	int (*read)(nina_stream_t);
	jmp_buf ex;
} ${FILENAME};

extern int ${FILENAME}_matches(char *s);
extern int ${FILENAME}_lookingAt(${FILENAME} *b, char *s);
extern int ${FILENAME}_find(${FILENAME} *b, char *s);
extern int ${FILENAME}_parse(${FILENAME} *s, FILE *f);
extern int ${FILENAME}_parse_string(${FILENAME} *s, char *f);
static void ${FILENAME}__unread(${FILENAME} *b, int c);
static void ${FILENAME}__gotoSymbol(${FILENAME} *b, int c);
EOF
for i in $SUBAUTOMATA
do
  ch1=`replace_strange_char $i`
  echo "static void ${FILENAME}_${ch1}__parse_int(${FILENAME} *__o__," >> /output/${OUTPUT_FILENAME}.h
  echo "		nina_stream_t rd, int x);" >> /output/${OUTPUT_FILENAME}.h
done
echo "#endif" >> /output/${OUTPUT_FILENAME}.h

echo '/* Translated by Nina */'
echo '/* This source code is under public domain */'

cat << EOF
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "${FILENAME}.h"

EOF
#cat fragment
cat fragment | replace_action
cat << EOF

static int __readf(nina_stream_t f) {
	return fgetc(*((FILE **)f));
}

static int __reads(nina_stream_t f) {
	char **s = (char **)f;

	return **s ? *((*s)++) : -1;
}

static int ${FILENAME}__read(${FILENAME} *b, nina_stream_t f) {
	int c;

	if(b->gotoSymbol >= 0) {
		c = b->gotoSymbol;
		b->gotoSymbol = -1;
	} else if(b->unread >= 0) {
		c = b->unread;
		b->unread = -1;
	} else if((c = (*(b->read))(f)) < 0) {
		b->iseof = ENDMARKER;
	}
	return c;
}

static void ${FILENAME}__unread(${FILENAME} *b, int c) {
	b->unread = c;
}

static void ${FILENAME}__gotoSymbol(${FILENAME} *b, int c) {
	b->gotoSymbol = c;
}
EOF

for i in $SUBAUTOMATA
do
  ch1=`replace_strange_char $i`
  echo
  echo "static int ${FILENAME}_${ch1}__step(${FILENAME} *__o__,"
  echo "		nina_stream_t __rd, int __c__) {"
  echo '	switch(__o__->state) {'
  print_states $i
  echo '	}'
  echo '	return 0;'
  echo '}'
  echo

  echo "static int ${FILENAME}_${ch1}__accepted(${FILENAME} *__o__) {"
  print_accepts $i
  echo '}'
  echo

  echo "static int ${FILENAME}_${ch1}__execaction(${FILENAME} *__o__, int __c__) {"
  echo '	switch(__o__->state) {'
  print_actions $i
  echo '	}'
  echo '	return 1;'
  echo '}'
  echo

  echo "static int ${FILENAME}_${ch1}__isend(${FILENAME} *__o__) {"
  print_isend $i
  echo '}'

  cat << EOF

static void ${FILENAME}_${ch1}__parse_int(${FILENAME} *__o__,
		nina_stream_t rd, int x) {
	int b = 0;
	int c = x;

	b = ${FILENAME}_${ch1}__accepted(__o__);
	if(rd == NULL) {
		abort();
	} else if(!${FILENAME}_${ch1}__execaction(__o__, -2)) {
		if(!b)  THROWERROR;
	}

	do {
		if(${FILENAME}_${ch1}__step(__o__, rd, c)) {
			b = ${FILENAME}_${ch1}__accepted(__o__) || b;
			if(!${FILENAME}_${ch1}__execaction(__o__, c))  break;
		} else if(b) {
			UNGET(c);
			return;
		} else {
			THROWERROR;
		}
	} while((c = ${FILENAME}__read(__o__, rd)) >= 0);
	if(!b)  THROWERROR;
}
EOF
done

ch1=`replace_strange_char ${MAINNAME}`
cat << EOF

int ${FILENAME}_matches(char *s) {
	${FILENAME} b;
	char *n;

	memset(&b, 0, sizeof(b));
	for(n = s; *n != 0; n++) {
		if(!${FILENAME}_${ch1}__step(&b, NULL, *n)) {
			return 0;
		}
	}
	return ${FILENAME}_${ch1}__accepted(&b);
}

int ${FILENAME}_lookingAt(${FILENAME} *b, char *s) {
	char *n, *p, *q;

	p = b->buf;  q = NULL;
	memset(b->buf, 0, sizeof(b->buf));
	for(n = s; *n != 0; *(p++) = *(n++)) {
		if(${FILENAME}_${ch1}__accepted(b)) {
			q = p;
		}

		if(p - b->buf >= sizeof(b->buf) - 1 ||
				!${FILENAME}_${ch1}__step(b, NULL, *n)) {
			if(q != NULL) {
				*q = 0;
				return 1;
			} else {
				return 0;
			}
		}
	}

	if(${FILENAME}_${ch1}__accepted(b)) {
		*p = 0;
		return 1;
	} else if(q != NULL) {
		*q = 0;
		return 1;
	} else {
		return 0;
	}
}

int ${FILENAME}_find(${FILENAME} *b, char *s) {
	char *n, *k, *p, *q;
	int x = 0;

	p = b->buf;  q = NULL;
	memset(b->buf, 0, sizeof(b->buf));
	for(k = s; *k != 0; k++) {
		for(n = k; *n != 0; *(p++) = *(n++)) {
			if(${FILENAME}_${ch1}__accepted(b)) {
				q = p;
			}

			if(p - b->buf >= sizeof(b->buf) - 1) {
				if(q != NULL) {
					*q = 0;
					return 1;
				} else {
					return 0;
				}
			} else if(!${FILENAME}_${ch1}__step(b, NULL, *n)) {
				if(q != NULL) {
					*q = 0;
					return 1;
				} else {
					b->state = 0;
					p = b->buf;  *p = 0;
					break;
				}
			}
		}

		if(${FILENAME}_${ch1}__accepted(b)) {
			*p = 0;
			return 1;
		} else if(q != NULL) {
			*q = 0;
			return 1;
		}
	}
	return 0;
}

static int ${FILENAME}_parse_generic(${FILENAME} *b, nina_stream_t f) {
	int c;

	if((c = setjmp(b->ex)) == THROW_CODE_ERROR) {
		fprintf(stderr, "syntax error\n");
		return 0;
	} else if(c == THROW_CODE_ACCEPT) {
		return 1;
	} else if(c == THROW_CODE_REJECT) {
		return 0;
	} else if(c) {
		abort();
	}

	if(!${FILENAME}_${ch1}__execaction(b, -2)) {
		return ${FILENAME}_${ch1}__accepted(b);
	}

	while((c = ${FILENAME}__read(b, f)) >= 0 || ${FILENAME}_${ch1}__isend(b)) {
		if(!${FILENAME}_${ch1}__step(b, f, c)) {
			b->state = 0;
		} else if(!${FILENAME}_${ch1}__execaction(b, c)) {
			return ${FILENAME}_${ch1}__accepted(b);
 		}
	}
	return ${FILENAME}_${ch1}__accepted(b);
}

int ${FILENAME}_parse(${FILENAME} *b, FILE *f) {
	b->read = __readf;
	return ${FILENAME}_parse_generic(b, NEW_NINA_STREAM_FILE(f));
}

int ${FILENAME}_parse_string(${FILENAME} *b, char *s) {
	b->read = __reads;
	return ${FILENAME}_parse_generic(b, NEW_NINA_STREAM_STRING(s));
}
EOF
