echo '// Translated by Nina'
echo '// This source code is under public domain'
[ -z "$PACKAGE" ] || echo "package $PACKAGE;"
[ -z "$EXTENDS" ] || extends="extends $EXTENDS"
[ -z "$IMPLEMENTS" ] || implements="implements $IMPLEMENTS"
print_imports

cat << EOF

public $ABSTRACT class ${CLASSNAME}${TEMPLATE} $extends $implements {

	static final int INITIAL = 0;

	private int STATE;
EOF
if [ -z "$TYPE" ]
then
  echo "	private $CTYPE unread = -1;"
  echo "	private $CTYPE gotoSymbol = -1;"
  echo '	private String matched;'
else
  echo "	private $CTYPE unread = null;"
  echo "	private $CTYPE gotoSymbol = null;"
fi

echo
#cat fragment
cat fragment | replace_action
echo

if [ -z "$TYPE" ]
then
  cat << EOF
	private int _read(java.io.Reader rd) throws java.io.IOException {
		int c;

		if(gotoSymbol >= 0) {
			c = gotoSymbol;
			gotoSymbol = -1;
			return c;
		} else if(unread >= 0) {
			c = unread;
			unread = -1;
			return c;
		} else {
			return rd.read();
		}
	}

	void UNGET(int c) {
		unread = c;
	}

	void GOTOSYMBOL(int c) {
		gotoSymbol = c;
	}
EOF
else
  cat << EOF
	private $CTYPE _read(java.util.Iterator<$CTYPE> itr) {
		$CTYPE c;

		if(unread != null) {
			c = unread;
			unread = null;
			return c;
		} else if(itr.hasNext()) {
			return itr.next();
		} else {
			return null;
		}
	}

	void UNGET($CTYPE c) {
		unread = c;
	}

	void GOTOSYMBOL($CTYPE c) {
		gotoSymbol = c;
	}
EOF
fi

for i in $SUBAUTOMATA
do
  ch1=`replace_strange_char $i`
  echo

  if [ -z "$TYPE" ]
  then
    echo "	private boolean ${ch1}_step(java.io.Reader __rd,"
    echo "			$CTYPE" ' $c) throws java.io.IOException {'
    echo '		switch(STATE) {'
    print_states $i
    echo '		}'
    echo '		return false;'
    echo '	}'
  else
    echo "	private boolean ${ch1}_step(Iterable<$CTYPE> __rd,"
    echo "			$CTYPE" ' $c) {'
    echo '		switch(STATE) {'
    print_states $i
    echo '		}'
    echo '		return false;'
    echo '	}'
  fi

  echo "	private boolean ${ch1}_accepted() {"
  print_accepts $i
  echo '	}'
  echo

  echo "	private boolean ${ch1}_execaction($CTYPE" ' $c) {'
  echo '		switch(STATE) {'
  print_actions $i
  echo '		}'
  echo '		return true;'
  echo '	}'
  echo

  echo "	private boolean ${ch1}_isend() {"
  print_isend $i
  echo '	}'

  if [ -z "$TYPE" ]
  then
    cat << EOF

	private void ${ch1}_parse(java.io.Reader rd,
			int x) throws java.io.IOException {
		boolean b = false;
		int c = x;

		b = ${ch1}_accepted();
		if(rd == null) {
			throw new RuntimeException("can not recurse");
		} else if(!${ch1}_execaction(-2)) {
			if(!b)  throw new ${TOKENERROR}();
		}

		do {
			if(${ch1}_step(rd, c)) {
				b = ${ch1}_accepted() || b;
				if(!${ch1}_execaction(c))  break;
			} else if(b) {
				UNGET(c);
				return;
			} else {
				throw new ${TOKENERROR}();
			}
		} while((c = _read(rd)) >= 0);
		if(!b)  throw new ${TOKENERROR}();
	}
EOF
  else
    cat << EOF

	public void ${ch1}_parse(Iterable<$CTYPE> rd, $CTYPE x) {
		boolean b = false;
		$CTYPE c = x;

		b = ${ch1}_accepted();
		if(rd == null) {
			throw new RuntimeException("can not recurse");
		} else if(!${ch1}_execaction(null)) {
			if(!b)  throw new ${TOKENERROR}();
		}

		do {
			if(${ch1}_step(rd, c)) {
				b = ${ch1}_accepted() || b;
				if(!${ch1}_execaction(c))  break;
			} else if(b) {
				UNGET(c);
				return;
			} else {
				throw new ${TOKENERROR}();
			}
		} while((c = _read(rd)) != null);
		if(!b)  throw new ${TOKENERROR}();
	}
EOF
  fi
done

ch1=`replace_strange_char ${MAINNAME}`
echo
if [ -z "$TYPE" ]
then
  cat << EOF
	public boolean matches(String s) {
		int n;

		try {
			STATE = 0;  matched = null;
			for(n = 0; n < s.length(); n++) {
				if(!${ch1}_step(null, s.charAt(n))) {
					return false;
				}
			}
		} catch(java.io.IOException e) {
			throw new RuntimeException(e);
		}

		if(${ch1}_accepted()) {
			matched = s;
			return true;
		} else {
			return false;
		}
	}

	public boolean lookingAt(String s) {
		StringBuffer b = new StringBuffer();
		int n;

		try {
			STATE = 0;  matched = null;
			for(n = 0; n < s.length(); n++) {
				if(${ch1}_accepted()) {
					matched = b.toString();
				}
	
				if(${ch1}_step(null, s.charAt(n))) {
					// do nothing
				} else {
					return matched != null;
				}
				b.append(s.charAt(n));
			}
		} catch(java.io.IOException e) {
			throw new RuntimeException(e);
		}

		if(${ch1}_accepted()) {
			matched = b.toString();
			return true;
		} else {
			return matched != null;
		}
	}

	public boolean find(String s) {
		StringBuffer b;
		int n, k;

		try {
			STATE = 0;  matched = null;
			for(k = 0; k < s.length(); k++) {
				b = new StringBuffer();
				for(n = k; n < s.length(); n++) {
					if(${ch1}_accepted()) {
						matched = b.toString();
					}
	
					if(${ch1}_step(null, s.charAt(n))) {
						// do noting
					} else if(matched == null) {
						break;
					} else {
						return true;
					}
					b.append(s.charAt(n));
				}
	
				if(${ch1}_accepted()) {
					matched = b.toString();
					return true;
				} else if(matched != null) {
					return true;
				} else {
					STATE = 0;
				}
			}
			return false;
		} catch(java.io.IOException e) {
			throw new RuntimeException(e);
		}
	}

	public String group() {
		return matched;
	}

	public boolean parse(
			java.io.Reader rd) throws java.io.IOException {
		int c;

		if(!${ch1}_execaction(-2))  return ${ch1}_accepted();
		while((c = _read(rd)) >= 0 || ${ch1}_isend()) {
			if(!${ch1}_step(rd, c)) {
				throw new ${TOKENERROR}();
			} else if(!${ch1}_execaction(c)) {
				return ${ch1}_accepted();
			}
		}
		return ${ch1}_accepted();
	}

	public boolean parse(
			java.io.InputStream rd) throws java.io.IOException {
		return parse(new java.io.InputStreamReader(rd));
	}

	public static boolean parseAll(
			java.io.Reader rd) throws java.io.IOException {
		${CLASSNAME} o = new ${CLASSNAME}();

		return o.parse(rd);
	}

	public static boolean parseAll(
			java.io.InputStream rd) throws java.io.IOException {
		return parseAll(new java.io.InputStreamReader(rd));
	}

}
EOF
else
  cat << EOF
	public boolean parse(Iterable<$CTYPE> x) {
		java.util.Iterator<$CTYPE> itr = x.iterator();
		$CTYPE c;

		if(!${ch1}_execaction(null))  return ${ch1}_accepted();
		while((c = _read(itr)) != null || ${ch1}_isend()) {
			if(!${ch1}_step(c)) {
				throw new ${TOKENERROR}();
			} else if(!${ch1}_execaction(c)) {
				return ${ch1}_accepted();
			}
		}
		return ${ch1}_accepted();
	}

	public static boolean parseAll(Iterable<$CTYPE> x) {
		${CLASSNAME} o = new ${CLASSNAME}();

		return o.parse(rd);
	}

}
EOF
fi
