cat > /output/${OUTPUT_FILENAME}.h << EOF
/* Translated by Nina */
/* This source code is under public domain */

#ifndef DEFINED_NINA_COMMON
#define DEFINED_NINA_COMMON

#include <stdio.h>
#define ENDMARKER ((void *)1)
#define STATE (__o__->state)
#define INITIAL 0
#endif

#ifndef DEFINED_${FILENAME}
#define DEFINED_${FILENAME}

typedef struct ${FILENAME}_tag {
	int state;
	int unread;
	void *iseof;
	char buf[${BUFSIZE}];
} ${FILENAME};

extern int ${FILENAME}_matches(char *s);
extern int ${FILENAME}_lookingAt(${FILENAME} *b, char *s);
extern int ${FILENAME}_find(${FILENAME} *b, char *s);
extern void *${FILENAME}_searchToken(${FILENAME} *s, FILE *f);
extern void *${FILENAME}_searchTokenStr(${FILENAME} *b, char **t);
#endif
EOF

echo '/* Translated by Nina */'
echo '/* This source code is under public domain */'

cat << EOF
#include <stdio.h>
#include <string.h>
#include "${FILENAME}.h"

EOF
#cat fragment
cat fragment | replace_action
cat << EOF

static int ${FILENAME}__read(${FILENAME} *b, FILE* f) {
	int c;

	if(b->unread > 0) {
		c = b->unread;
		b->unread = -1;
	} else if((c = fgetc(f)) < 0) {
		b->iseof = ENDMARKER;
	}
	return c;
}

static int ${FILENAME}__readstr(${FILENAME} *b, char** p) {
	int c;

	if(b->unread > 0) {
		c = b->unread;  b->unread = -1;
		return c;
	} else if(**p == 0) {
		b->iseof = ENDMARKER;
		return -1;
	} else {
		return *((*p)++);
	}
}

static int ${FILENAME}__step(${FILENAME} *__o__, int __c__) {
	switch(__o__->state) {
EOF

print_states
cat << EOF
	}
	return 0;
}

static int ${FILENAME}__accepted(${FILENAME} *__o__) {
EOF

print_accepts
cat << EOF
}

static void *${FILENAME}__gettoken(${FILENAME} *__o__, char *__b__) {
	switch(__o__->state) {
EOF

print_token
cat << EOF
	default:  return NULL;
	}
}

int ${FILENAME}_matches(char *s) {
	${FILENAME} b;
	char *n;

	memset(&b, 0, sizeof(b));
	for(n = s; *n != 0; n++) {
		if(!${FILENAME}__step(&b, *n)) {
			return 0;
		}
	}
	return ${FILENAME}__accepted(&b);
}

int ${FILENAME}_lookingAt(${FILENAME} *b, char *s) {
	char *n, *p, *q;

	p = b->buf;  q = NULL;
	memset(b->buf, 0, sizeof(b->buf));
	for(n = s; *n != 0; *(p++) = *(n++)) {
		if(${FILENAME}__accepted(b)) {
			q = p;
		}

		if(p - b->buf >= sizeof(b->buf) - 1 ||
				!${FILENAME}__step(b, *n)) {
			if(q != NULL) {
				*q = 0;
				return 1;
			} else {
				return 0;
			}
		}
	}

	if(${FILENAME}__accepted(b)) {
		*p = 0;
		return 1;
	} else if(q != NULL) {
		*q = 0;
		return 1;
	} else {
		return 0;
	}
}

int ${FILENAME}_find(${FILENAME} *b, char *s) {
	char *n, *k, *p, *q;
	int x = 0;

	p = b->buf;  q = NULL;
	memset(b->buf, 0, sizeof(b->buf));
	for(k = s; *k != 0; k++) {
		for(n = k; *n != 0; *(p++) = *(n++)) {
			if(${FILENAME}__accepted(b)) {
				q = p;
			}

			if(p - b->buf >= sizeof(b->buf) - 1) {
				if(q != NULL) {
					*q = 0;
					return 1;
				} else {
					return 0;
				}
			} else if(!${FILENAME}__step(b, *n)) {
				if(q != NULL) {
					*q = 0;
					return 1;
				} else {
					b->state = 0;
					p = b->buf;  *p = 0;
					break;
				}
			}
		}

		if(${FILENAME}__accepted(b)) {
			*p = 0;
			return 1;
		} else if(q != NULL) {
			*q = 0;
			return 1;
		}
	}
	return 0;
}

void *${FILENAME}_searchToken(${FILENAME} *b, FILE *t) {
	void *o = NULL;
	int f = 0, c;
	char *p;

	p = b->buf;
	memset(b->buf, 0, sizeof(b->buf));
	if(b->iseof != NULL)  return b->iseof;
	while((c = ${FILENAME}__read(b, t)) >= 0) {
		*p++ = c;
		if(!${FILENAME}__step(b, c)) {
			if(f) {
				b->unread = c;
				b->state = 0;
				return o;
			} else {
				return NULL;
			}
		} else if(f = ${FILENAME}__accepted(b)) {
			o = ${FILENAME}__gettoken(b, b->buf);
		}
	}
	return f ? o : NULL;
}

void *${FILENAME}_searchTokenStr(${FILENAME} *b, char **t) {
	void *o = NULL;
	int f = 0, c;
	char *p;

	p = b->buf;
	memset(b->buf, 0, sizeof(b->buf));
	if(b->iseof != NULL)  return b->iseof;
	while((c = ${FILENAME}__readstr(b, t)) >= 0) {
		*p++ = c;
		if(!${FILENAME}__step(b, c)) {
			if(f) {
				b->unread = c;
				b->state = 0;
				return o;
			} else {
				return NULL;
			}
		} else if(f = ${FILENAME}__accepted(b)) {
			o = ${FILENAME}__gettoken(b, b->buf);
		}
	}
	return f ? o : NULL;
}
EOF
