/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina.translate.sh;

import java.util.HashMap;
import java.util.Map;

import net.morilib.sh.ShBuiltInCommands;
import net.morilib.sh.ShProcess;
import net.morilib.sh.testcmd.ShTestParser;

public final class ShNinatBuiltInCommands
implements ShBuiltInCommands {

	private Map<String, ShProcess> commands;

	/**
	 * 
	 * @param cmd
	 */
	public ShNinatBuiltInCommands() {
		commands = new HashMap<String, ShProcess>();
		commands.put("cat", new ShCat());
		commands.put("echo", new ShEcho());
		commands.put("test", ShTestParser.getDefault());
		commands.put("replace_action", new ReplaceSharp());
		commands.put("replace_strange_char", new ReplaceStrangeChar());
	}

	/**
	 * 
	 * @param s
	 * @param p
	 */
	public void putCommand(String s, ShProcess p) {
		commands.put(s, p);
	}

	/**
	 * 
	 * @param name
	 * @return
	 */
	public ShProcess find(String name) {
		return commands.get(name);
	}

}
