/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.dfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.morilib.automata.DFA;
import net.morilib.automata.DFAState;
import net.morilib.automata.TextBound;
import net.morilib.automata.dfa.DFAs;
import net.morilib.range.Interval;
import net.morilib.range.RangeAdder;

public class MinimizedRangeDFA<T, A, B>
implements DFA<T, A, B> {
    private Map<DFAState<T, A, B>, DFAState<T, A, B>> groupmap = new HashMap<DFAState<T, A, B>, DFAState<T, A, B>>();
    private DFAState<T, A, B> initetat;
    private Map<DFAState<T, A, B>, DFAW> cache = new HashMap<DFAState<T, A, B>, DFAW>();

    private MinimizedRangeDFA() {
    }

    DFAW getdfaw(DFAState<T, A, B> s) {
        DFAW t = this.cache.get(s);
        if (t == null) {
            t = new DFAW(s);
            this.cache.put(s, t);
        }
        return t;
    }

    public static <T, A, B> MinimizedRangeDFA<T, A, B> newInstance(DFA<T, A, B> dfa) {
        DFAS x;
        MinimizedRangeDFA<T, A, B> r = new MinimizedRangeDFA<T, A, B>();
        Set<Set<DFAState<T, A, B>>> g = DFAs.getEquivalentGroup(dfa);
        for (Set<DFAState<T, A, B>> t : g) {
            MinimizedRangeDFA<T, A, B> minimizedRangeDFA = r;
            minimizedRangeDFA.getClass();
            x = minimizedRangeDFA.new DFAS(t);
            for (DFAState<T, A, B> s : t) {
                r.groupmap.put(s, x);
            }
        }
        x = r.groupmap.get(dfa.getInitialState());
        r.initetat = x != null ? x : r.getdfaw(dfa.getInitialState());
        return r;
    }

    @Override
    public DFAState<T, A, B> getInitialState() {
        return this.initetat;
    }

    private class DFAS
    implements DFAState<T, A, B> {
        List<DFAState<T, A, B>> group;

        DFAS(Collection<DFAState<T, A, B>> c) {
            this.group = new ArrayList(c);
        }

        @Override
        public DFAState<T, A, B> go(T alphabet) {
            DFAState s = this.group.get(0).go(alphabet);
            DFAState t = (DFAState)MinimizedRangeDFA.this.groupmap.get(s);
            return t != null ? t : MinimizedRangeDFA.this.getdfaw(s);
        }

        @Override
        public DFAState<T, A, B> goInt(int x) {
            return this.go(x);
        }

        @Override
        public DFAState<T, A, B> goChar(char x) {
            return this.go(Integer.valueOf(x));
        }

        @Override
        public DFAState<T, A, B> goBound(TextBound bound) {
            DFAState s = this.group.get(0).goBound(bound);
            DFAState t = (DFAState)MinimizedRangeDFA.this.groupmap.get(s);
            return t != null ? t : MinimizedRangeDFA.this.getdfaw(s);
        }

        @Override
        public boolean isInitialState() {
            for (DFAState s : this.group) {
                if (!s.isInitialState()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set<A> getAccepted() {
            HashSet t = new HashSet();
            for (DFAState s : this.group) {
                t.addAll(s.getAccepted());
            }
            return t;
        }

        @Override
        public boolean isDead() {
            for (DFAState s : this.group) {
                if (!s.isDead()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isAccepted() {
            for (DFAState s : this.group) {
                if (!s.isAccepted()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set<T> getAlphabets() {
            HashSet t = new HashSet();
            for (DFAState s : this.group) {
                t.addAll(s.getAlphabets());
            }
            return t;
        }

        @Override
        public Iterable<Interval> getAlphabetRanges() {
            RangeAdder a = new RangeAdder();
            for (DFAState s : this.group) {
                for (Interval v : s.getAlphabetRanges()) {
                    a.addInterval(v);
                }
            }
            return a.toRange().intervals();
        }

        @Override
        public Object getLabel(T alphabet) {
            return null;
        }

        @Override
        public Object getLabelInt(int x) {
            return null;
        }

        @Override
        public Object getLabelChar(char x) {
            return null;
        }
    }

    private class DFAW
    implements DFAState<T, A, B> {
        private DFAState<T, A, B> etat;

        DFAW(DFAState<T, A, B> s) {
            this.etat = s;
        }

        @Override
        public DFAState<T, A, B> go(T alphabet) {
            DFAState s = this.etat.go(alphabet);
            DFAState t = (DFAState)MinimizedRangeDFA.this.groupmap.get(s);
            return t != null ? t : MinimizedRangeDFA.this.getdfaw(s);
        }

        @Override
        public DFAState<T, A, B> goInt(int x) {
            return this.go(x);
        }

        @Override
        public DFAState<T, A, B> goChar(char x) {
            return this.go(Integer.valueOf(x));
        }

        @Override
        public DFAState<T, A, B> goBound(TextBound bound) {
            DFAState s = this.etat.goBound(bound);
            DFAState t = (DFAState)MinimizedRangeDFA.this.groupmap.get(s);
            return t != null ? t : MinimizedRangeDFA.this.getdfaw(s);
        }

        @Override
        public boolean isInitialState() {
            return this.etat.isInitialState();
        }

        @Override
        public Set<A> getAccepted() {
            return this.etat.getAccepted();
        }

        @Override
        public boolean isDead() {
            return this.etat.isDead();
        }

        @Override
        public boolean isAccepted() {
            return this.etat.isAccepted();
        }

        @Override
        public Set<T> getAlphabets() {
            return this.etat.getAlphabets();
        }

        @Override
        public Iterable<Interval> getAlphabetRanges() {
            return this.etat.getAlphabetRanges();
        }

        @Override
        public Object getLabel(T alphabet) {
            return null;
        }

        @Override
        public Object getLabelInt(int x) {
            return null;
        }

        @Override
        public Object getLabelChar(char x) {
            return null;
        }
    }
}

