/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.nano.expr;

import java.math.BigInteger;
import net.morilib.awk.nano.AwkCastException;
import net.morilib.awk.nano.expr.AwkExpression;
import net.morilib.awk.nano.io.AwkFiles;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.value.AwkFloat;
import net.morilib.awk.nano.value.AwkInteger;
import net.morilib.awk.nano.value.AwkUndefined;
import net.morilib.awk.nano.value.AwkValue;

public class AwkInclementer
extends AwkExpression {
    private AwkExpression e1;
    private boolean prefix;

    public AwkInclementer(AwkExpression e1, boolean prefix) {
        this.e1 = e1;
        this.prefix = prefix;
    }

    @Override
    public AwkValue eval(AwkNamespace ns, AwkFiles o) {
        AwkValue w;
        AwkValue v = this.e1.eval(ns, o);
        if (v.isInteger() || v.isString() && v.isIntegerValue()) {
            BigInteger b = v.toInteger();
            w = AwkInteger.valueOf(b.add(BigInteger.ONE));
        } else if (v.isFloat() || v.isString() && v.isFloatValue()) {
            w = AwkFloat.valueOf(v.toFloat() + 1.0);
        } else if (v instanceof AwkUndefined) {
            v = AwkInteger.ZERO;
            w = AwkInteger.ONE;
        } else {
            throw new AwkCastException("number required");
        }
        v = this.prefix ? w : v;
        this.e1.assign(ns, w, o);
        return v;
    }

    @Override
    public boolean isLvalue() {
        return false;
    }
}

