/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.nano.java6;

import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.SimpleBindings;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.value.AwkArray;
import net.morilib.awk.nano.value.AwkFloat;
import net.morilib.awk.nano.value.AwkInteger;
import net.morilib.awk.nano.value.AwkString;
import net.morilib.awk.nano.value.AwkUndefined;
import net.morilib.awk.nano.value.AwkValue;

public class AwkScriptContext
implements ScriptContext {
    private Reader reader;
    private Writer writer;
    private Writer errwriter;
    AwkNamespace global;
    AwkNamespace engine;

    AwkScriptContext(AwkNamespace rt, AwkNamespace eng) {
        this.global = rt;
        this.engine = eng;
        this.reader = new InputStreamReader(System.in);
        this.writer = new OutputStreamWriter(System.out);
        this.errwriter = new OutputStreamWriter(System.err);
    }

    private AwkNamespace _scope(int scope) {
        switch (scope) {
            case 100: {
                return this.engine;
            }
            case 200: {
                return this.global;
            }
        }
        throw new IllegalArgumentException();
    }

    private static AwkValue toAwkValue(Object o, boolean nest) {
        if (o == null) {
            return AwkUndefined.UNDEF;
        }
        if (o instanceof String) {
            return AwkString.valueOf((String)o);
        }
        if (o instanceof Integer || o instanceof Long || o instanceof Byte || o instanceof Short) {
            return AwkInteger.valueOf(((Number)o).intValue());
        }
        if (o instanceof Character) {
            return AwkInteger.valueOf(((Character)o).charValue());
        }
        if (o instanceof Double || o instanceof Float) {
            return AwkFloat.valueOf(((Number)o).doubleValue());
        }
        if (o instanceof BigInteger) {
            return AwkInteger.valueOf((BigInteger)o);
        }
        if (o instanceof BigDecimal) {
            return AwkFloat.valueOf(((BigDecimal)o).doubleValue());
        }
        if (o instanceof Boolean) {
            return AwkInteger.valueOf(o.equals(Boolean.TRUE) ? 1 : 0);
        }
        if (!nest && o instanceof Map) {
            AwkArray a = new AwkArray();
            for (Map.Entry t : ((Map)o).entrySet()) {
                a.putArray(t.getKey().toString(), AwkScriptContext.toAwkValue(t.getValue(), true));
            }
            return a;
        }
        if (!nest && o instanceof List) {
            AwkArray a = new AwkArray();
            List l = (List)o;
            int k = 1;
            while (k <= l.size()) {
                a.putArray(String.valueOf(k), AwkScriptContext.toAwkValue(l.get(k - 1), true));
                ++k;
            }
            return a;
        }
        if (!nest && o.getClass().isArray()) {
            AwkArray a = new AwkArray();
            int k = 1;
            while (k <= Array.getLength(o)) {
                a.putArray(String.valueOf(k), AwkScriptContext.toAwkValue(Array.get(o, k - 1), true));
                ++k;
            }
            return a;
        }
        return AwkString.valueOf(o.toString());
    }

    public static AwkValue toAwkValue(Object o) {
        return AwkScriptContext.toAwkValue(o, false);
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        AwkNamespace e = this._scope(scope);
        for (Map.Entry t : bindings.entrySet()) {
            e.assign((String)t.getKey(), AwkScriptContext.toAwkValue(t.getValue()));
        }
    }

    @Override
    public Bindings getBindings(int scope) {
        SimpleBindings b = new SimpleBindings();
        AwkNamespace e = this._scope(scope);
        for (Map.Entry<String, AwkValue> t : e.getValueMap().entrySet()) {
            b.put(t.getKey(), t.getValue().toObject());
        }
        return b;
    }

    @Override
    public void setAttribute(String name, Object value, int scope) {
        AwkNamespace e = this._scope(scope);
        e.assign(name, AwkScriptContext.toAwkValue(value));
    }

    @Override
    public Object getAttribute(String name, int scope) {
        AwkNamespace e = this._scope(scope);
        AwkValue v = e.get(name);
        return v != null ? v.toObject() : null;
    }

    @Override
    public Object removeAttribute(String name, int scope) {
        AwkNamespace e = this._scope(scope);
        AwkValue v = e.remove(name);
        return v != null ? v.toObject() : null;
    }

    @Override
    public Object getAttribute(String name) {
        AwkValue v = this.engine.find(name);
        return v != null ? v.toObject() : null;
    }

    @Override
    public int getAttributesScope(String name) {
        if (this.engine.get(name) != null) {
            return 100;
        }
        if (this.global.get(name) != null) {
            return 200;
        }
        return -1;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public Writer getErrorWriter() {
        return this.errwriter;
    }

    @Override
    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void setErrorWriter(Writer writer) {
        this.errwriter = writer;
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public List<Integer> getScopes() {
        return Arrays.asList(100, 200);
    }
}

