/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.util.logging.Logger;
import net.morilib.lisp.nano.Atom;
import net.morilib.lisp.nano.Cons;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.Nil;
import net.morilib.lisp.nano.Subr;
import net.morilib.lisp.nano.Symbol;
import net.morilib.lisp.nano.SymbolName;
import net.morilib.lisp.nano.Syntax;

final class IntLispUtils {
    private IntLispUtils() {
    }

    static void bindLocal(Datum prms, Datum bcdr, Environment env, LispMessage mesg) {
        block7: {
            while (true) {
                if (prms == Nil.NIL) {
                    if (bcdr != Nil.NIL) {
                        throw mesg.getError("err.parameter.insufficient");
                    }
                    break block7;
                }
                if (prms instanceof Atom) {
                    if (!(prms instanceof Symbol)) {
                        throw mesg.getError("err.symbol", prms);
                    }
                    env.bindDatum(prms, bcdr);
                    break block7;
                }
                if (!(bcdr instanceof Cons)) {
                    throw mesg.getError("err.parameter.insufficient");
                }
                if (!(prms instanceof Cons)) break;
                Datum a1 = ((Cons)prms).getCar();
                Datum a2 = ((Cons)bcdr).getCar();
                if (!(a1 instanceof SymbolName)) {
                    throw mesg.getError("err.symbol", a1);
                }
                env.bindDatum(a1, a2);
                prms = ((Cons)prms).getCdr();
                bcdr = ((Cons)bcdr).getCdr();
            }
            throw mesg.getError("err.type.insufficient");
        }
    }

    static void timelog(Logger _log, String str, long bef) {
        long dt = System.currentTimeMillis() - bef;
        String msec = "000" + dt % 1000L;
        msec = msec.substring(msec.length() - 3);
        _log.fine(String.valueOf(str) + dt / 1000L + "." + msec + "sec");
    }

    static void timelogFiner(Logger _log, String str, long bef) {
        long dt = System.currentTimeMillis() - bef;
        String msec = "000" + dt % 1000L;
        msec = msec.substring(msec.length() - 3);
        _log.finer(String.valueOf(str) + dt / 1000L + "." + msec + "sec");
    }

    static void loadJavaSubr(Environment env, Symbol k, String v) {
        env.bindDatum(k, IntLispUtils.getJavaSubr(k, v));
    }

    static Datum getJavaSubr(Symbol k, String v) {
        try {
            Class<?> cls = Class.forName(v);
            Datum ins = (Datum)cls.newInstance();
            if (ins instanceof Subr) {
                ((Subr)ins).symbolName = k.getName();
            } else if (ins instanceof Syntax) {
                ((Syntax)ins).symbolName = k.getName();
            }
            return ins;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static void loadJavaSubr(Environment env, Symbol k, String v, ClassLoader loader) {
        env.bindDatum(k, IntLispUtils.getJavaSubr(k, v, loader));
    }

    static Datum getJavaSubr(Symbol k, String v, ClassLoader loader) {
        try {
            Class<?> cls = loader.loadClass(v);
            Datum ins = (Datum)cls.newInstance();
            if (ins instanceof Subr) {
                ((Subr)ins).symbolName = k.getName();
            } else if (ins instanceof Syntax) {
                ((Syntax)ins).symbolName = k.getName();
            }
            return ins;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

