/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.morilib.lisp.nano.Cons;
import net.morilib.lisp.nano.ConsListBuilder;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.LispBoolean;
import net.morilib.lisp.nano.LispCharacter;
import net.morilib.lisp.nano.LispDouble;
import net.morilib.lisp.nano.LispExactReal;
import net.morilib.lisp.nano.LispInteger;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.LispRational;
import net.morilib.lisp.nano.LispString;
import net.morilib.lisp.nano.NanoParser;
import net.morilib.lisp.nano.Nil;
import net.morilib.lisp.nano.Scheme;
import net.morilib.lisp.nano.Symbol;
import net.morilib.lisp.nano.SynBegin;
import net.morilib.lisp.nano.SynDefine;
import net.morilib.lisp.nano.SynIf;
import net.morilib.lisp.nano.SynLambda;
import net.morilib.lisp.nano.SynQuote;
import net.morilib.lisp.nano.exlib.DisplayObject;
import net.morilib.lisp.nano.exlib.StringBuf;
import net.morilib.lisp.nano.exlib.WriteObject;
import net.morilib.lisp.nano.subr.Add;
import net.morilib.lisp.nano.subr.Car;
import net.morilib.lisp.nano.subr.Cdr;
import net.morilib.lisp.nano.subr.IsEq;
import net.morilib.lisp.nano.subr.IsEqv;
import net.morilib.lisp.nano.subr.IsNull;
import net.morilib.lisp.nano.subr.IsPair;
import net.morilib.lisp.nano.subr.IsVector;
import net.morilib.lisp.nano.subr.MakeCons;
import net.morilib.lisp.nano.subr.VectorLength;
import net.morilib.lisp.nano.subr.VectorRef;

public final class LispUtils {
    private static final String DI2 = "/net/morilib/lisp/nano/display.scm";
    static final Scheme DISP;

    static {
        Environment e = new Environment();
        LispUtils._bind(e, "if", new SynIf());
        LispUtils._bind(e, "lambda", new SynLambda());
        LispUtils._bind(e, "define", new SynDefine());
        LispUtils._bind(e, "quote", new SynQuote());
        LispUtils._bind(e, "begin", new SynBegin());
        LispUtils._bind(e, "cons", new MakeCons());
        LispUtils._bind(e, "car", new Car());
        LispUtils._bind(e, "cdr", new Cdr());
        LispUtils._bind(e, "null?", new IsNull());
        LispUtils._bind(e, "pair?", new IsPair());
        LispUtils._bind(e, "eq?", new IsEq());
        LispUtils._bind(e, "eqv?", new IsEqv());
        LispUtils._bind(e, "+", new Add());
        LispUtils._bind(e, "vector?", new IsVector());
        LispUtils._bind(e, "vector-ref", new VectorRef());
        LispUtils._bind(e, "vector-length", new VectorLength());
        LispUtils._bind(e, "display-object", new DisplayObject());
        LispUtils._bind(e, "write-object", new WriteObject());
        DISP = new Scheme(e, LispMessage.getInstance());
        try {
            NanoParser.read(DISP, LispUtils.class.getResourceAsStream(DI2));
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
    }

    private static void _bind(Environment e, String s, Datum d) {
        e.bindDatum(Symbol.getSymbol(s), d);
    }

    private LispUtils() {
    }

    public static String toDisplay(Datum d) {
        StringBuf b = new StringBuf();
        try {
            DISP.call("display-all", b, d);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return b.toDisplay();
    }

    public static String toWrite(Datum d) {
        StringBuf b = new StringBuf();
        try {
            DISP.call("write-all", b, d);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return b.toDisplay();
    }

    public static String toWriteWithoutSS(Datum d) {
        StringBuf b = new StringBuf();
        try {
            DISP.call("write-all", b, d);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return b.toDisplay();
    }

    public static Datum listToCons(Collection<? extends Datum> d, Datum dot) {
        Cons res = null;
        Cons c2 = null;
        for (Datum datum : d) {
            if (res == null) {
                res = c2 = new Cons();
                c2.setCar(datum);
                continue;
            }
            Cons c3 = new Cons(datum, Nil.NIL);
            c2.setCdr(c3);
            c2 = c3;
        }
        if (res == null) {
            return dot;
        }
        c2.setCdr(dot);
        return res;
    }

    public static Datum listToCons(Collection<? extends Datum> d) {
        return LispUtils.listToCons(d, Nil.NIL);
    }

    public static List<Datum> consToList(Datum d, LispMessage mesg) {
        ArrayList<Datum> res = new ArrayList<Datum>();
        Datum dd = d;
        while (dd != Nil.NIL) {
            if (dd instanceof Cons) {
                res.add(((Cons)dd).getCar());
                dd = ((Cons)dd).getCdr();
                continue;
            }
            throw mesg.getError("err.list");
        }
        return res;
    }

    public static List<Datum> consToListIgnoreDot(Datum d) {
        ArrayList<Datum> res = new ArrayList<Datum>();
        Datum dd = d;
        while (dd != Nil.NIL) {
            if (!(dd instanceof Cons)) break;
            res.add(((Cons)dd).getCar());
            dd = ((Cons)dd).getCdr();
        }
        return res;
    }

    public static Datum toConsList(Object[] arr, Object cdr) {
        ConsListBuilder lst = new ConsListBuilder();
        Object[] objectArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            lst.append(LispUtils.toDatum(o));
            ++n2;
        }
        return lst.get(LispUtils.toDatum(cdr));
    }

    public static Datum toConsList(Object[] arr) {
        return LispUtils.toConsList(arr, Nil.NIL);
    }

    public static LispExactReal bigDecimalToRational(BigDecimal v) {
        BigInteger n = v.unscaledValue();
        if (v.scale() > 0) {
            BigInteger d = BigInteger.TEN.pow(v.scale());
            return LispRational.newRational(n, d);
        }
        if (v.scale() < 0) {
            BigInteger d = BigInteger.TEN.pow(-v.scale());
            return LispInteger.valueOf(n.multiply(d));
        }
        return LispInteger.valueOf(n);
    }

    public static Datum toDatum(Object o) {
        Class<?> cl;
        Class<?> clazz = cl = o == null ? null : o.getClass();
        if (o instanceof Datum) {
            return (Datum)o;
        }
        if (o instanceof Byte) {
            return LispInteger.valueOf(((Byte)o).intValue());
        }
        if (o instanceof Short) {
            return LispInteger.valueOf(((Short)o).intValue());
        }
        if (o instanceof Integer) {
            return LispInteger.valueOf((Integer)o);
        }
        if (o instanceof Long) {
            return LispInteger.valueOf((Long)o);
        }
        if (o instanceof BigInteger) {
            return LispInteger.valueOf((BigInteger)o);
        }
        if (o instanceof BigDecimal) {
            return LispUtils.bigDecimalToRational((BigDecimal)o);
        }
        if (o instanceof Float) {
            return new LispDouble(((Float)o).doubleValue());
        }
        if (o instanceof Double) {
            return new LispDouble((Double)o);
        }
        if (o instanceof String) {
            return new LispString((String)o);
        }
        if (o instanceof Character) {
            return new LispCharacter(((Character)o).charValue());
        }
        if (o instanceof Boolean) {
            return LispBoolean.getInstance((Boolean)o);
        }
        if (cl.isArray()) {
            ConsListBuilder bld = new ConsListBuilder();
            int len = Array.getLength(o);
            int i = 0;
            while (i < len) {
                bld.append(LispUtils.toDatum(Array.get(o, i)));
                ++i;
            }
            return bld.get();
        }
        throw new ClassCastException();
    }

    public static Datum listDot(Datum d, Datum ... lst) {
        ConsListBuilder b = new ConsListBuilder();
        Datum[] datumArray = lst;
        int n = lst.length;
        int n2 = 0;
        while (n2 < n) {
            Datum o = datumArray[n2];
            b.append(o);
            ++n2;
        }
        return b.get(d);
    }

    public static Datum list(Datum ... lst) {
        return LispUtils.listDot(Nil.NIL, lst);
    }

    public static boolean isReservedCharacter(char c) {
        return c == '(' || c == '[' || c == ')' || c == ']' || c == '#' || Character.isWhitespace(c);
    }

    public static BigInteger toIntegerExact(double number) {
        block3: {
            try {
                if (!Double.isInfinite(number) && !Double.isNaN(number)) break block3;
                return null;
            }
            catch (ArithmeticException e) {
                return null;
            }
        }
        BigDecimal dec = new BigDecimal(number);
        return dec.toBigIntegerExact();
    }

    public static Integer toIntExact(BigInteger i) {
        int r = i.intValue();
        if (i.equals(BigInteger.valueOf(r))) {
            return new Integer(r);
        }
        return null;
    }

    public static File getFile(Environment env, String s) throws IOException {
        File f = new File(s.replaceFirst("^~/", String.valueOf(System.getProperty("user.home")) + "/"));
        if (f.isAbsolute()) {
            return f;
        }
        return new File(System.getProperty("user.dir"), s).getCanonicalFile();
    }
}

