/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.nina.LRObject;
import net.morilib.nina.Nina;
import net.morilib.nina.NinaEvent;
import net.morilib.nina.NinaException;
import net.morilib.nina.NinaLanguageOption;
import net.morilib.nina.VersionNumber;
import net.morilib.nina.lint.LintCells;

public class Quadro
implements NinaEvent {
    private static final String LOPT = "targetLanguage";
    private static final String EOG = "-- end of grammar --";
    private static final Pattern PTN1 = Pattern.compile("--[ \t]+(.+)[ \t]+--");
    private static final Pattern PTN2 = Pattern.compile("%.*\\{");
    private static final Pattern PTN3 = Pattern.compile("grammar:[ \t]*--[ \t]+(.+)[ \t]+--");
    private static final Pattern PTN4 = Pattern.compile("import:[ \t]*(.+)[ \t]+as[ \t]+(.+)[ \t]*");
    private static final Pattern PTN5 = Pattern.compile("import-grammar:[ \t]*(.+)[ \t]+as[ \t]+(.+)[ \t]*");
    private static final Pattern CDLM = Pattern.compile("-+");
    private static boolean iswarning = false;
    private static String tabs = "    ";
    public static PrintStream errst = null;
    static final int EQ_TO_LEFT = -1;
    static final int BLANKX = -2;
    static final int BLANKY = -3;
    static final int E2 = -100;
    static final int W2 = -101;
    static final int N2 = -102;
    static final int S2 = -103;
    static final int E3 = -200;
    static final int W3 = -201;
    static final int N3 = -202;
    static final int S3 = -203;
    static final int DONE = -300;
    static final int ENTRY = -301;
    static final int WARP2 = -400;
    static final int WARP3 = -402;
    static final int FRAME_N = -501;
    static final int FRAME_A = -502;
    static final int BRANCH = -5000000;
    static final int BRANCH_N = 1000;
    static final int BRANCH_E = 100;
    static final int BRANCH_S = 10;
    static final int BRANCH_W = 1;
    Map<String, String> aliases = new HashMap<String, String>();
    Map<String, String> options;
    Map<String, StringBuffer> buffers = new HashMap<String, StringBuffer>();
    List<String> imports = new ArrayList<String>();
    String fragment;
    String type;
    String lexer;
    String ltype;
    private int[][] quadro;
    private Object[][] scratch;
    private Object[][] scratch2;
    private String[][] labels;
    private String[][] ltypes;
    private String[][] visited;
    private String[][] visiting;
    private int curx = 0;
    private int cury = 0;
    private Object edge;
    private Map<String, Quadro> subquadro;
    private Map<String, LRObject> lrobjects;
    private LintCells lint;
    private List<String[]> ids;
    List<String[]> requires = new ArrayList<String[]>();
    Map<String, String> labelalias = new HashMap<String, String>();
    Map<String, String> defines = new HashMap<String, String>();
    Map<String, Integer> consts = new HashMap<String, Integer>();
    StringWriter license = new StringWriter();
    String rootResource;
    String rootPackage;
    String name;
    String valtype;
    String description;
    private NinaLanguageOption langopt = null;

    Quadro(String n, List<int[]> q, String f, Map<String, Quadro> sub, Map<String, LRObject> lros, Map<String, String> opts) {
        this.options = opts;
        this.name = n;
        this.fragment = f;
        this.quadro = new int[q.size()][];
        this.scratch = new Object[q.size()][];
        this.scratch2 = new Object[q.size()][];
        this.labels = new String[q.size()][];
        this.ltypes = new String[q.size()][];
        this.visited = new String[q.size()][];
        this.visiting = new String[q.size()][];
        this.subquadro = sub;
        this.lrobjects = lros;
        int i = 0;
        while (i < q.size()) {
            this.quadro[i] = q.get(i);
            this.scratch[i] = new Object[q.get(i).length];
            this.scratch2[i] = new Object[q.get(i).length];
            this.labels[i] = new String[q.get(i).length];
            this.ltypes[i] = new String[q.get(i).length];
            this.visited[i] = new String[q.get(i).length];
            this.visiting[i] = new String[q.get(i).length];
            ++i;
        }
        this.lint = new LintCells(0, q);
    }

    Quadro(String n, int[][] q, String f, Map<String, Quadro> sub, Map<String, LRObject> lros, Map<String, String> opts) {
        this.options = opts;
        this.name = n;
        this.fragment = f;
        this.quadro = new int[q.length][];
        this.scratch = new Object[q.length][];
        this.scratch2 = new Object[q.length][];
        this.labels = new String[q.length][];
        this.ltypes = new String[q.length][];
        this.visited = new String[q.length][];
        this.visiting = new String[q.length][];
        this.subquadro = sub;
        this.lrobjects = lros;
        int i = 0;
        while (i < q.length) {
            this.quadro[i] = new int[q[i].length];
            this.scratch[i] = new Object[q[i].length];
            this.scratch2[i] = new Object[q[i].length];
            this.labels[i] = new String[q[i].length];
            this.ltypes[i] = new String[q[i].length];
            this.visited[i] = new String[q[i].length];
            this.visiting[i] = new String[q[i].length];
            int j = 0;
            while (j < q[i].length) {
                this.quadro[i][j] = q[i][j];
                ++j;
            }
            ++i;
        }
        this.lint = new LintCells(0, q);
    }

    Quadro(String n, List<int[]> q, String f, Map<String, LRObject> lros, Map<String, String> opts) {
        this(n, q, f, null, lros, opts);
    }

    public Quadro(Map<String, String> options) {
        this.options = options;
    }

    public static void setTab(int x) {
        StringBuffer b = new StringBuffer();
        if (x <= 0) {
            return;
        }
        int k = 0;
        while (k < x) {
            b.append(' ');
            ++k;
        }
        tabs = b.toString();
    }

    @Override
    public String getRootResource() {
        return this.rootResource;
    }

    @Override
    public String getRootPackage() {
        return this.rootPackage;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setRootResource(String x) {
        this.rootResource = x;
    }

    public void setRootPackage(String x) {
        this.rootPackage = x;
    }

    @Override
    public Object getEdge() {
        return this.edge;
    }

    @Override
    public void setEdge(Object edge) {
        this.edge = edge;
    }

    public boolean isInBounds() {
        return this.cury >= 0 && this.cury < this.quadro.length && this.curx >= 0 && this.curx < this.quadro[this.cury].length;
    }

    @Override
    public int get() {
        if (this.cury < 0 || this.cury >= this.quadro.length) {
            return -3;
        }
        if (this.curx < 0 || this.curx >= this.quadro[this.cury].length) {
            return -2;
        }
        return this.quadro[this.cury][this.curx];
    }

    @Override
    public Object getScratch() {
        if (this.cury < 0 || this.cury >= this.quadro.length) {
            return null;
        }
        if (this.curx < 0 || this.curx >= this.quadro[this.cury].length) {
            return null;
        }
        return this.scratch[this.cury][this.curx];
    }

    public Object getScratch2() {
        if (this.cury < 0 || this.cury >= this.quadro.length) {
            return null;
        }
        if (this.curx < 0 || this.curx >= this.quadro[this.cury].length) {
            return null;
        }
        return this.scratch2[this.cury][this.curx];
    }

    public boolean isBlankX() {
        return this.get() == -2;
    }

    public boolean isBlankY() {
        return this.get() == -3;
    }

    public boolean isLetter() {
        int c = this.get();
        return c >= 0 && Character.isLetter(c);
    }

    public boolean isDigit() {
        int c = this.get();
        return c >= 0 && Character.isDigit(c);
    }

    public boolean isArrow() {
        return "^><v".indexOf(this.get()) >= 0;
    }

    public boolean isEntry() {
        return this.get() == -301;
    }

    public boolean isDone() {
        return this.get() == -300;
    }

    public boolean isFrameBefore() {
        return "*@=&".indexOf(this.get()) >= 0;
    }

    public void transformFrame() {
        if (this.get() == 64 || this.get() == 38) {
            this.set(-502);
        } else if (this.get() == 42 || this.get() == 61) {
            this.set(-501);
        }
    }

    public boolean isFrame() {
        return this.get() == -501 || this.get() == -502;
    }

    public boolean isArrow2() {
        return this.get() <= -100 && this.get() >= -103;
    }

    public boolean isArrow3() {
        return this.get() <= -200 && this.get() >= -203;
    }

    public boolean isBranch() {
        int x = this.get();
        return x == 43 || x < -5000000;
    }

    public boolean isBranchN() {
        int x = this.get();
        if (x == 43) {
            return true;
        }
        if ((x = -(x - -5000000)) > 0) {
            return x / 1000 % 10 != 1;
        }
        return false;
    }

    public boolean isBranchE() {
        int x = this.get();
        if (x == 43) {
            return true;
        }
        if ((x = -(x - -5000000)) > 0) {
            return x / 100 % 10 != 1;
        }
        return false;
    }

    public boolean isBranchS() {
        int x = this.get();
        if (x == 43) {
            return true;
        }
        if ((x = -(x - -5000000)) > 0) {
            return x / 10 % 10 != 1;
        }
        return false;
    }

    public boolean isBranchW() {
        int x = this.get();
        if (x == 43) {
            return true;
        }
        if ((x = -(x - -5000000)) > 0) {
            return x / 1 % 10 != 1;
        }
        return false;
    }

    public boolean isWedgeN() {
        int x = this.get();
        return x < -5000000 && -(x - -5000000) / 1000 % 10 == 1;
    }

    public boolean isWedgeE() {
        int x = this.get();
        return x < -5000000 && -(x - -5000000) / 100 % 10 == 1;
    }

    public boolean isWedgeS() {
        int x = this.get();
        return x < -5000000 && -(x - -5000000) / 10 % 10 == 1;
    }

    public boolean isWedgeW() {
        int x = this.get();
        return x < -5000000 && -(x - -5000000) / 1 % 10 == 1;
    }

    public boolean isWhitespace() {
        return Character.isWhitespace(this.get());
    }

    public void set(int a) {
        if (this.isInBounds()) {
            this.quadro[this.cury][this.curx] = a;
        }
    }

    @Override
    public void setScratch(Object a) {
        if (this.isInBounds()) {
            this.scratch[this.cury][this.curx] = a;
        }
    }

    public void setScratch2(Object a) {
        if (this.isInBounds()) {
            this.scratch2[this.cury][this.curx] = a;
        }
    }

    public Quadro move(Direction d) {
        switch (d) {
            case WEST: {
                this.curx = this.curx < 0 ? this.curx : this.curx - 1;
                return this;
            }
            case EAST: {
                this.curx = this.cury < 0 || this.cury >= this.quadro.length || this.curx > this.quadro[this.cury].length ? this.curx : this.curx + 1;
                return this;
            }
            case NORTH: {
                this.cury = this.cury < 0 ? this.cury : this.cury - 1;
                return this;
            }
            case SOUTH: {
                this.cury = this.cury > this.quadro.length ? this.cury : this.cury + 1;
                return this;
            }
            case CR: {
                this.curx = 0;
                this.cury = this.cury > this.quadro.length ? this.cury : this.cury + 1;
                return this;
            }
        }
        throw new RuntimeException();
    }

    public Quadro move(int x, int y) {
        if (this.cury + y < 0) {
            this.cury = -1;
        } else if (this.cury + y > this.quadro.length) {
            this.cury = this.quadro.length;
        }
        if (this.curx + x < 0) {
            this.curx = -1;
        } else if (this.curx + x > this.quadro[this.cury].length) {
            this.curx = this.quadro[this.cury].length;
        }
        return this;
    }

    public Quadro west() {
        return this.move(Direction.WEST);
    }

    public Quadro east() {
        return this.move(Direction.EAST);
    }

    public Quadro north() {
        return this.move(Direction.NORTH);
    }

    public Quadro south() {
        return this.move(Direction.SOUTH);
    }

    public Quadro cr() {
        return this.move(Direction.CR);
    }

    public Quadro getSubQuadro(String name) {
        return this.subquadro != null ? this.subquadro.get(name) : null;
    }

    public Map<String, Quadro> getSubQuadros() {
        return this.subquadro != null ? Collections.unmodifiableMap(this.subquadro) : Collections.emptyMap();
    }

    public LRObject getLRObject(String name) {
        return this.lrobjects != null ? this.lrobjects.get(name) : null;
    }

    public Map<String, LRObject> getLRObjects() {
        return this.lrobjects != null ? Collections.unmodifiableMap(this.lrobjects) : Collections.emptyMap();
    }

    public Quadro prototype(Quadro q) {
        return new Quadro(this.name, this.quadro, this.fragment, q.getSubQuadros(), this.lrobjects, q.options);
    }

    public String getLabel() {
        if (this.cury < 0 || this.cury >= this.quadro.length) {
            return null;
        }
        if (this.curx < 0 || this.curx >= this.quadro[this.cury].length) {
            return null;
        }
        return this.labels[this.cury][this.curx];
    }

    public void setLabel(String a) {
        if (this.isInBounds()) {
            this.labels[this.cury][this.curx] = a;
        }
    }

    public String getLabelType() {
        if (this.cury < 0 || this.cury >= this.quadro.length) {
            return null;
        }
        if (this.curx < 0 || this.curx >= this.quadro[this.cury].length) {
            return null;
        }
        return this.ltypes[this.cury][this.curx];
    }

    public void setLabelType(String a) {
        if (this.isInBounds()) {
            this.ltypes[this.cury][this.curx] = a;
        }
    }

    public boolean isVisited(String l) {
        if (this.cury < 0 || this.cury >= this.quadro.length) {
            return false;
        }
        if (this.curx < 0 || this.curx >= this.quadro[this.cury].length) {
            return false;
        }
        if (this.visited[this.cury][this.curx] == null) {
            return false;
        }
        return this.visited[this.cury][this.curx].indexOf("(" + l + ")") >= 0;
    }

    public void addVisited(String l) {
        if (this.isInBounds()) {
            if (this.visited[this.cury][this.curx] == null) {
                this.visited[this.cury][this.curx] = "(" + l + ")";
            } else {
                String[] stringArray = this.visited[this.cury];
                int n = this.curx;
                stringArray[n] = String.valueOf(stringArray[n]) + "(" + l + ")";
            }
        }
    }

    public String getVisiting() {
        if (this.cury < 0 || this.cury >= this.quadro.length) {
            return null;
        }
        if (this.curx < 0 || this.curx >= this.quadro[this.cury].length) {
            return null;
        }
        return this.visiting[this.cury][this.curx];
    }

    public void setVisiting(String a) {
        if (this.isInBounds()) {
            this.visiting[this.cury][this.curx] = a;
        }
    }

    public Object getStateByLabel(String l) {
        int y = 0;
        while (y < this.labels.length) {
            int x = 0;
            while (x < this.labels[y].length) {
                if (l.equals(this.labels[y][x])) {
                    return this.scratch[y][x];
                }
                ++x;
            }
            ++y;
        }
        return null;
    }

    public Object getDeadState() {
        return this.getStateByLabel("D");
    }

    static int putWedgeN(int x) {
        if (x == 43) {
            return -5001000;
        }
        if (x < -5000000) {
            return x - 1000;
        }
        throw new RuntimeException();
    }

    static int putWedgeE(int x) {
        if (x == 43) {
            return -5000100;
        }
        if (x < -5000000) {
            return x - 100;
        }
        throw new RuntimeException();
    }

    static int putWedgeS(int x) {
        if (x == 43) {
            return -5000010;
        }
        if (x < -5000000) {
            return x - 10;
        }
        throw new RuntimeException();
    }

    static int putWedgeW(int x) {
        if (x == 43) {
            return -5000001;
        }
        if (x < -5000000) {
            return x - 1;
        }
        throw new RuntimeException();
    }

    public static Quadro readResource(String name, List<String> l) throws IOException {
        try (InputStream in = null;){
            in = Quadro.class.getResourceAsStream(name);
            InputStreamReader rd = new InputStreamReader(in);
            Quadro quadro = Quadro.read(name, rd, l);
            return quadro;
        }
    }

    public static Quadro read(String name, String s, List<String> l) {
        try {
            StringReader r = new StringReader(s);
            return Quadro.read(name, r, l);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Quadro putquadro(Map<String, Quadro> q, String x, List<int[]> l, Map<String, String> m, int y) {
        Quadro v = new Quadro(x, l, "", null, m);
        q.put(x, v);
        v.lint.setYOffset(y);
        iswarning = v.lint.validate(errst) | iswarning;
        return v;
    }

    private static List<int[]> setquadro(Map<String, Quadro> q, Map<String, String> m, String x, int y, List<int[]> z, List<int[]> l) {
        if (z == null) {
            return l;
        }
        if (x != null) {
            Quadro.putquadro(q, x, l, m, y);
        }
        return z;
    }

    private static LRObject readlr(String fn, List<String> libs) throws IOException {
        try (Reader rd = null;){
            InputStream in = Nina.findLib(fn, libs);
            if (in == null) {
                throw new NinaException("filenotfound", fn);
            }
            rd = new InputStreamReader(in);
            LRObject lRObject = LRObject.parse(rd);
            return lRObject;
        }
    }

    public static Quadro read(String name, Reader rd, List<String> libs) throws IOException {
        String s;
        HashMap<String, LRObject> f = new HashMap<String, LRObject>();
        HashMap<String, Quadro> q = new HashMap<String, Quadro>();
        HashMap<String, String> m = new HashMap<String, String>();
        ArrayList<Object> l = new ArrayList<int[]>();
        List<int[]> z = null;
        ArrayList<String[]> d = new ArrayList<String[]>();
        BufferedReader br = new BufferedReader(rd);
        ArrayList<String> sl = new ArrayList<String>();
        String x = null;
        String desc = "";
        boolean b = false;
        boolean b2 = true;
        StringWriter sw = null;
        PrintWriter pw = null;
        int y = 0;
        int p = 0;
        while (!((s = br.readLine()) == null || sw == null && s.equals("%%"))) {
            s = s.replaceAll("\t", tabs);
            s = s.replaceAll("\u3000", "  ");
            if (sw != null) {
                if (!b2) {
                    b2 = CDLM.matcher(s).matches();
                    if (b2) {
                        desc = sw.toString();
                        sw = null;
                    } else {
                        pw.println(s);
                    }
                } else if (s.equals(EOG)) {
                    LRObject lr = LRObject.parse(new StringReader(sw.toString()));
                    f.put(x, lr);
                    sw = null;
                    x = null;
                } else {
                    pw.println(s);
                }
            } else if (!s.equals("")) {
                if (CDLM.matcher(s).matches()) {
                    b2 = false;
                    sw = new StringWriter();
                    pw = new PrintWriter((Writer)sw, true);
                } else {
                    Matcher h = PTN1.matcher(s);
                    if (h.matches()) {
                        z = Quadro.setquadro(q, m, x, y, z, l);
                        y = p + 1;
                        x = h.group(1);
                        l = new ArrayList();
                        for (String t : sl) {
                            l.add(Nina.toiarray(t));
                        }
                    } else {
                        h = PTN3.matcher(s);
                        if (h.matches()) {
                            z = Quadro.setquadro(q, m, x, y, z, l);
                            x = h.group(1);
                            sw = new StringWriter();
                            pw = new PrintWriter((Writer)sw, true);
                        } else {
                            String[] a;
                            h = PTN4.matcher(s);
                            if (h.matches()) {
                                z = Quadro.setquadro(q, m, x, y, z, l);
                                a = Nina.readHeader(h.group(1), libs);
                                Quadro.putquadro(q, h.group(2), Nina.readImport(h.group(1), libs, a[2]), m, y);
                                if (a[0] != null) {
                                    d.add(a);
                                }
                                x = null;
                            } else {
                                h = PTN5.matcher(s);
                                if (h.matches()) {
                                    z = Quadro.setquadro(q, m, x, y, z, l);
                                    a = Nina.readHeader(h.group(1), libs);
                                    f.put(h.group(2), Quadro.readlr(h.group(1), libs));
                                    if (a[0] != null) {
                                        d.add(a);
                                    }
                                    x = null;
                                } else if (z == null || x != null) {
                                    if (!b && z == null && s.charAt(0) == '#') {
                                        sl.add(s);
                                        l.add(Nina.toiarray(s));
                                    } else if (!b && PTN2.matcher(s).lookingAt()) {
                                        b = true;
                                        l.add(Nina.toiarray(s));
                                    } else if (b && s.startsWith("%}")) {
                                        b = false;
                                        l.add(Nina.toiarray(s));
                                    } else {
                                        l.add(Nina.toiarray(s));
                                    }
                                }
                            }
                        }
                    }
                }
            }
            ++p;
        }
        if (sw != null) {
            throw new NinaException("unexpectedeof", new Object[0]);
        }
        z = Quadro.setquadro(q, m, x, y, z, l);
        sw = new StringWriter();
        pw = new PrintWriter((Writer)sw, true);
        while ((s = br.readLine()) != null) {
            pw.println(s);
        }
        Quadro v = new Quadro(name, z, sw.toString(), q, f, new HashMap<String, String>());
        v.lint.setYOffset(0);
        v.ids = d;
        v.description = desc;
        iswarning = v.lint.validate(errst) | iswarning;
        return v;
    }

    @Override
    public String getOption(String s) {
        return this.options.get(s);
    }

    public String getDescription() {
        return this.description;
    }

    public String getLicense() {
        return this.license.toString();
    }

    public String getOptionNvl(String s, String n) {
        String x = this.options.get(s);
        return x != null ? x : n;
    }

    public int getOptionInt(String s, int x) {
        try {
            return Integer.parseInt(this.options.get(s));
        }
        catch (NumberFormatException e) {
            return x;
        }
    }

    public boolean isOptionDefined(String s) {
        return this.options.get(s) != null;
    }

    @Override
    public boolean getOptionBoolean(String s) {
        String x = this.options.get(s);
        if (x == null) {
            return false;
        }
        return x.equalsIgnoreCase("true") || x.equalsIgnoreCase("yes") || x.equalsIgnoreCase("on") || x.equalsIgnoreCase("oui");
    }

    public String getAlias(String s) {
        return this.aliases.get(s);
    }

    @Override
    public String getCharset() {
        String s = this.options.get("charset");
        return s != null ? s : "UTF-8";
    }

    public String getType() {
        return this.type;
    }

    public List<String> getImports() {
        return Collections.unmodifiableList(this.imports);
    }

    void addImports(String s) {
        this.imports.add(s);
    }

    public String getFragment() {
        return this.fragment != null ? this.fragment : "";
    }

    public String getDefinition() {
        return this.getFragmentByName("");
    }

    public String getFragmentByName(String s) {
        StringBuffer b = this.buffers.get(s);
        return b != null ? b.toString() : "";
    }

    public String getFragmentField() {
        String n = System.getProperty("line.separator");
        StringBuffer b = new StringBuffer();
        StringBuffer a = this.buffers.get("field");
        if (a != null) {
            b.append(a);
        }
        if ((a = this.buffers.get("member")) != null) {
            if (b.length() > 0) {
                b.append(n);
            }
            b.append(a);
        }
        return b.toString();
    }

    public void printTrace(PrintStream pr) {
        pr.println(this.toString());
    }

    @Override
    public NinaLanguageOption getLanguageOption() {
        if (this.langopt == null) {
            String s = this.options.get(LOPT);
            s = s != null ? s : "Java";
            this.langopt = (NinaLanguageOption)Nina.prendClasse(String.valueOf(NinaLanguageOption.class.getName()) + s);
        }
        return this.langopt;
    }

    public static boolean isWarning() {
        return iswarning;
    }

    public Map<String, Integer> getConstantMap() {
        return Collections.unmodifiableMap(this.consts);
    }

    @Override
    public boolean isGrammar(String t) {
        return this.lrobjects.containsKey(t);
    }

    public String getLexer() {
        return this.lexer;
    }

    public String getLexerType() {
        return this.ltype;
    }

    private void checkRequire1(String[] a) {
        if (this.ids != null) {
            for (String[] b : this.ids) {
                VersionNumber g;
                if (!a[0].equals(b[0])) continue;
                if (a[1] == null) {
                    return;
                }
                if (b[1] == null) {
                    throw new NinaException("requireversion", a[0]);
                }
                try {
                    g = new VersionNumber(b[1]);
                }
                catch (NumberFormatException e) {
                    throw new NinaException("invalidversion", b[1]);
                }
                try {
                    VersionNumber f;
                    if (a[1].charAt(0) == '>' ? !g.isUpperThan(f = new VersionNumber(a[1].substring(1))) : (a[1].charAt(0) == '=' ? !g.isIncluded(f = new VersionNumber(a[1].substring(1))) : (a[1].charAt(0) == '<' ? !g.isLowerThan(f = new VersionNumber(a[1].substring(1))) : !g.isUpperThan(f = new VersionNumber(a[1]))))) {
                        throw new NinaException("requireversion", a[0]);
                    }
                    return;
                }
                catch (NumberFormatException e) {
                    throw new NinaException("invalidversion", a[1]);
                }
            }
        }
        throw new NinaException("packagenotfound", a[0]);
    }

    void checkRequire() {
        for (String[] a : this.requires) {
            this.checkRequire1(a);
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < this.quadro.length) {
            int j = 0;
            while (j < this.quadro[i].length) {
                if (this.cury == i && this.curx == j) {
                    b.append('x');
                } else {
                    switch (this.quadro[i][j]) {
                        case -1: {
                            break;
                        }
                        case -2: {
                            b.append('$');
                            break;
                        }
                        case -3: {
                            b.append('#');
                            break;
                        }
                        case -102: {
                            b.append('^');
                            break;
                        }
                        case -100: {
                            b.append('>');
                            break;
                        }
                        case -103: {
                            b.append('v');
                            break;
                        }
                        case -101: {
                            b.append('<');
                            break;
                        }
                        case -202: {
                            b.append('A');
                            break;
                        }
                        case -200: {
                            b.append(')');
                            break;
                        }
                        case -203: {
                            b.append('w');
                            break;
                        }
                        case -201: {
                            b.append('(');
                            break;
                        }
                        case -300: {
                            b.append('0');
                            break;
                        }
                        default: {
                            if (this.quadro[i][j] >= 0) {
                                b.append((char)this.quadro[i][j]);
                                break;
                            }
                            b.append('.');
                        }
                    }
                }
                ++j;
            }
            b.append('\n');
            ++i;
        }
        return b.toString();
    }

    public static enum Direction {
        WEST,
        EAST,
        NORTH,
        SOUTH,
        CR;

    }
}

