/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.nfa;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import net.morilib.automata.NFAState;
import net.morilib.automata.TextBound;
import net.morilib.automata.nfa.NFAObject;
import net.morilib.range.Range;

public abstract class SingleAlphabetNFA<T, A, B>
extends NFAObject<T, A, B> {
    final NFAState beginState = new NFAObject.IntStateObject(this, 0);
    final NFAState endState = new NFAObject.IntStateObject(this, 1);

    public abstract boolean contains(T var1);

    public abstract Range getObject();

    @Override
    void addStates(Set<NFAState> res, NFAState state, T alphabet) {
        if (state.equals(this.beginState) && this.contains(alphabet)) {
            res.add(this.endState);
        }
    }

    @Override
    void addStates(Set<NFAState> res, NFAState state, Range a) {
        if (state.equals(this.beginState) && a.in(this.getObject())) {
            res.add(this.endState);
        }
    }

    @Override
    void addStatesBound(Set<NFAState> res, NFAState state, EnumSet<TextBound> b) {
    }

    @Override
    void addInitialStates(Set<NFAState> res) {
        res.add(this.beginState);
    }

    @Override
    void addStatesEpsilon(Set<NFAState> res, NFAState state) {
    }

    @Override
    public boolean isState(NFAState o) {
        if (o instanceof NFAObject.IntStateObject) {
            NFAObject.IntStateObject s = (NFAObject.IntStateObject)o;
            return s.equals(this.beginState) || s.equals(this.endState);
        }
        return false;
    }

    @Override
    public boolean isInitialState(NFAState o) {
        return this.beginState.equals(o);
    }

    @Override
    public boolean isFinal(NFAState o) {
        return this.endState.equals(o);
    }

    @Override
    public Set<NFAState> getAcceptedStates() {
        return Collections.singleton(this.endState);
    }

    @Override
    public Set<B> getMatchTag(NFAState state) {
        return Collections.emptySet();
    }

    @Override
    public Set<B> getMatchTagEnd(NFAState state) {
        return Collections.emptySet();
    }

    @Override
    public Set<A> getAccept(NFAState state) {
        return Collections.emptySet();
    }
}

