/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.nfa.op;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.morilib.automata.DFA;
import net.morilib.automata.DFAState;
import net.morilib.automata.NFA;
import net.morilib.automata.NFAEdges;
import net.morilib.automata.NFAState;
import net.morilib.automata.TextBound;
import net.morilib.automata.dfa.DFAs;
import net.morilib.automata.nfa.op.EpsilonEdge;
import net.morilib.range.Interval;
import net.morilib.range.Range;
import net.morilib.util.IntervalMap;

public class DFAWrappedNFA<T, A, B>
implements NFA<T, A, B> {
    private final NFAEdges<T> eedg = new EpsilonEdge(null);
    private Set<DFAState<T, A, B>> allStates;
    private DFA<T, A, B> dfa;

    public DFAWrappedNFA(DFA<T, A, B> dfa) {
        this.dfa = dfa;
        this.allStates = new HashSet<DFAState<T, A, B>>(DFAs.allStates(dfa));
    }

    @Override
    public boolean isState(NFAState o) {
        return this.allStates.contains(o);
    }

    @Override
    public Set<NFAState> getStates(NFAState state, T alphabet) {
        if (this.isState(state)) {
            DFAState s = (DFAState)state;
            return Collections.singleton(s.go(alphabet));
        }
        return Collections.emptySet();
    }

    @Override
    public Set<NFAState> getStates(NFAState state, Range rng) {
        if (this.isState(state)) {
            DFAState s = (DFAState)state;
            HashSet<NFAState> r = new HashSet<NFAState>();
            for (Interval t : s.getAlphabetRanges()) {
                if (t.independentOf(rng)) continue;
                if (t.isInfimumClosed()) {
                    r.add(s.go(t.getInfimumBound()));
                    continue;
                }
                if (t.isSupremumClosed()) {
                    r.add(s.go(t.getSupremumBound()));
                    continue;
                }
                throw new RuntimeException();
            }
            return r;
        }
        return Collections.emptySet();
    }

    @Override
    public Set<NFAState> getStates(NFAState state, EnumSet<TextBound> bound) {
        if (this.isState(state)) {
            DFAState s = (DFAState)state;
            HashSet<NFAState> r = new HashSet<NFAState>();
            for (TextBound x : bound) {
                r.add(s.goBound(x));
            }
            return r;
        }
        return Collections.emptySet();
    }

    @Override
    public Set<NFAState> getStatesEpsilon(NFAState state) {
        return Collections.emptySet();
    }

    @Override
    public Set<NFAState> getStatesBound(NFAState state, EnumSet<TextBound> bound) {
        return this.getStates(state, bound);
    }

    @Override
    public Set<NFAState> getInitialStates() {
        return Collections.singleton(this.dfa.getInitialState());
    }

    @Override
    public boolean isInitialState(NFAState o) {
        return this.dfa.getInitialState().equals(o);
    }

    @Override
    public boolean isFinal(NFAState state) {
        return this.allStates.contains(state) && ((DFAState)state).isAccepted();
    }

    @Override
    public boolean isFinalAny(Set<NFAState> states) {
        for (NFAState s : states) {
            if (!this.isFinal(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public NFAEdges<T> getEdges(NFAState state) {
        if (!this.isState(state)) {
            return this.eedg;
        }
        final DFAState s = (DFAState)state;
        return new NFAEdges<T>(){

            @Override
            public Set<NFAState> goNext(T alphabet) {
                return Collections.singleton(s.go(alphabet));
            }

            @Override
            public Set<NFAState> goNext(int alphabet) {
                return this.goNext(alphabet);
            }

            @Override
            public Set<NFAState> goNext(char alphabet) {
                return this.goNext((int)alphabet);
            }

            @Override
            public Set<NFAState> goNextEpsilon() {
                return Collections.emptySet();
            }

            @Override
            public Set<? extends Range> nextAlphabets() {
                HashSet<Interval> r = new HashSet<Interval>();
                for (Interval v : s.getAlphabetRanges()) {
                    r.add(v);
                }
                return r;
            }

            @Override
            public boolean isNextEpsilon() {
                return false;
            }
        };
    }

    @Override
    public Set<Interval> nextAlphabets(NFAState state) {
        if (this.isState(state)) {
            DFAState s = (DFAState)state;
            HashSet<Interval> r = new HashSet<Interval>();
            for (Interval v : s.getAlphabetRanges()) {
                r.add(v);
            }
            return r;
        }
        return Collections.emptySet();
    }

    @Override
    public Iterable<Interval> nextAlphabets(Set<NFAState> states) {
        IntervalMap m = new IntervalMap();
        for (NFAState s : states) {
            for (Interval v : this.nextAlphabets(s)) {
                m.put(v, null);
            }
        }
        return m.keySet();
    }

    @Override
    public Set<T> nextDiscreteAlphabets(NFAState state) {
        if (this.isState(state)) {
            DFAState s = (DFAState)state;
            return new HashSet(s.getAlphabets());
        }
        return Collections.emptySet();
    }

    @Override
    public Iterable<T> nextDiscreteAlphabets(Set<NFAState> states) {
        HashSet<T> m = new HashSet<T>();
        for (NFAState s : states) {
            m.addAll(this.nextDiscreteAlphabets(s));
        }
        return m;
    }

    @Override
    public Set<NFAState> getAcceptedStates() {
        HashSet<NFAState> r = new HashSet<NFAState>();
        for (DFAState<T, A, B> d : this.allStates) {
            if (!d.isAccepted()) continue;
            r.add(d);
        }
        return r;
    }

    @Override
    public Set<B> getMatchTag(NFAState state) {
        return Collections.emptySet();
    }

    @Override
    public Set<B> getMatchTagEnd(NFAState state) {
        return Collections.emptySet();
    }

    @Override
    public Set<A> getAccept(NFAState state) {
        if (this.isState(state)) {
            DFAState s = (DFAState)state;
            return new HashSet(s.getAccepted());
        }
        return Collections.emptySet();
    }

    @Override
    public boolean isAccepted(NFAState state) {
        if (this.isState(state)) {
            DFAState s = (DFAState)state;
            return s.isAccepted();
        }
        return false;
    }
}

