/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.nfa.op;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.morilib.automata.NFA;
import net.morilib.automata.NFAEdges;
import net.morilib.automata.NFAState;
import net.morilib.automata.TextBound;
import net.morilib.automata.nfa.op.EpsilonEdge;
import net.morilib.range.Interval;
import net.morilib.range.Range;
import net.morilib.util.IntervalMap;

public class JoinNFA<T, A, B>
implements NFA<T, A, B> {
    private final NFAEdges<T> eedg = new EpsilonEdge(null);
    private final NFAState bgst = new NFAState(){};
    private final NFAState edst = new NFAState(){};
    private NFA<T, A, B> nfa1;
    private NFA<T, A, B> nfa2;
    private A end;

    @Override
    public boolean isState(NFAState o) {
        return o == this.bgst || o == this.edst || this.nfa1.isState(o) || this.nfa2.isState(o);
    }

    @Override
    public Set<NFAState> getStates(NFAState state, T alphabet) {
        HashSet<NFAState> r = new HashSet<NFAState>();
        if (state != this.bgst && state != this.edst) {
            if (this.nfa1.isState(state)) {
                r.addAll(this.nfa1.getStates(state, alphabet));
                if (this.nfa1.isFinal(state)) {
                    r.add(this.edst);
                }
            } else if (this.nfa2.isState(state)) {
                r.addAll(this.nfa2.getStates(state, alphabet));
                if (this.nfa2.isFinal(state)) {
                    r.add(this.edst);
                }
            }
        }
        return r;
    }

    @Override
    public Set<NFAState> getStates(NFAState state, Range rng) {
        HashSet<NFAState> r = new HashSet<NFAState>();
        if (state != this.bgst && state != this.edst) {
            if (this.nfa1.isState(state)) {
                r.addAll(this.nfa1.getStates(state, rng));
            } else if (this.nfa2.isState(state)) {
                r.addAll(this.nfa2.getStates(state, rng));
            }
        }
        return r;
    }

    @Override
    public Set<NFAState> getStates(NFAState state, EnumSet<TextBound> bound) {
        HashSet<NFAState> r = new HashSet<NFAState>();
        if (state != this.bgst && state != this.edst) {
            if (this.nfa1.isState(state)) {
                r.addAll(this.nfa1.getStates(state, bound));
            } else if (this.nfa2.isState(state)) {
                r.addAll(this.nfa2.getStates(state, bound));
            }
        }
        return r;
    }

    @Override
    public Set<NFAState> getStatesEpsilon(NFAState state) {
        HashSet<NFAState> r = new HashSet<NFAState>();
        if (state == this.bgst) {
            r.addAll(this.nfa1.getInitialStates());
            r.addAll(this.nfa2.getInitialStates());
        } else if (state != this.edst) {
            if (this.nfa1.isState(state)) {
                r.addAll(this.nfa1.getStatesEpsilon(state));
                if (this.nfa1.isFinal(state)) {
                    r.add(this.edst);
                }
            } else if (this.nfa2.isState(state)) {
                r.addAll(this.nfa2.getStatesEpsilon(state));
                if (this.nfa2.isFinal(state)) {
                    r.add(this.edst);
                }
            }
        }
        return r;
    }

    @Override
    public Set<NFAState> getStatesBound(NFAState state, EnumSet<TextBound> bound) {
        HashSet<NFAState> r = new HashSet<NFAState>();
        if (state != this.bgst && state != this.edst) {
            if (this.nfa1.isState(state)) {
                r.addAll(this.nfa1.getStatesBound(state, bound));
            } else if (this.nfa2.isState(state)) {
                r.addAll(this.nfa2.getStatesBound(state, bound));
            }
        }
        return r;
    }

    @Override
    public Set<NFAState> getInitialStates() {
        return Collections.singleton(this.bgst);
    }

    @Override
    public boolean isInitialState(NFAState o) {
        return o == this.bgst;
    }

    @Override
    public boolean isFinal(NFAState state) {
        return state == this.edst;
    }

    @Override
    public boolean isFinalAny(Set<NFAState> states) {
        for (NFAState s : states) {
            if (!this.isFinal(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public NFAEdges<T> getEdges(NFAState state) {
        if (state == this.bgst) {
            return new EpsilonEdge(this.getStatesEpsilon(state));
        }
        if (state == this.edst) {
            return this.eedg;
        }
        if (this.nfa1.isState(state)) {
            return this.nfa1.getEdges(state);
        }
        if (this.nfa2.isState(state)) {
            return this.nfa2.getEdges(state);
        }
        return this.eedg;
    }

    @Override
    public Set<Interval> nextAlphabets(NFAState state) {
        if (state == this.bgst) {
            return Collections.emptySet();
        }
        if (state == this.edst) {
            return Collections.emptySet();
        }
        if (this.nfa1.isState(state)) {
            return this.nfa1.nextAlphabets(state);
        }
        if (this.nfa2.isState(state)) {
            return this.nfa2.nextAlphabets(state);
        }
        return Collections.emptySet();
    }

    @Override
    public Iterable<Interval> nextAlphabets(Set<NFAState> states) {
        IntervalMap m = new IntervalMap();
        for (NFAState s : states) {
            for (Interval v : this.nextAlphabets(s)) {
                m.put(v, null);
            }
        }
        return m.keySet();
    }

    @Override
    public Set<T> nextDiscreteAlphabets(NFAState state) {
        if (state == this.bgst) {
            return Collections.emptySet();
        }
        if (state == this.edst) {
            return Collections.emptySet();
        }
        if (this.nfa1.isState(state)) {
            return this.nfa1.nextDiscreteAlphabets(state);
        }
        if (this.nfa2.isState(state)) {
            return this.nfa2.nextDiscreteAlphabets(state);
        }
        return Collections.emptySet();
    }

    @Override
    public Iterable<T> nextDiscreteAlphabets(Set<NFAState> states) {
        HashSet<T> m = new HashSet<T>();
        for (NFAState s : states) {
            m.addAll(this.nextDiscreteAlphabets(s));
        }
        return m;
    }

    @Override
    public Set<NFAState> getAcceptedStates() {
        return Collections.singleton(this.edst);
    }

    @Override
    public Set<B> getMatchTag(NFAState state) {
        if (state == this.bgst) {
            return Collections.emptySet();
        }
        if (state == this.edst) {
            return Collections.emptySet();
        }
        if (this.nfa1.isState(state)) {
            return this.nfa1.getMatchTag(state);
        }
        if (this.nfa2.isState(state)) {
            return this.nfa2.getMatchTag(state);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<B> getMatchTagEnd(NFAState state) {
        if (state == this.bgst) {
            return Collections.emptySet();
        }
        if (state == this.edst) {
            return Collections.emptySet();
        }
        if (this.nfa1.isState(state)) {
            return this.nfa1.getMatchTagEnd(state);
        }
        if (this.nfa2.isState(state)) {
            return this.nfa2.getMatchTagEnd(state);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<A> getAccept(NFAState state) {
        if (state == this.edst) {
            return Collections.singleton(this.end);
        }
        return Collections.emptySet();
    }

    @Override
    public boolean isAccepted(NFAState state) {
        return !this.getAccept(state).isEmpty();
    }
}

