/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.nano.expr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.morilib.awk.nano.AwkLocation;
import net.morilib.awk.nano.expr.AwkExpression;
import net.morilib.awk.nano.io.AwkFiles;
import net.morilib.awk.nano.namespace.AwkClosureNamespace;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.value.AwkFunction;
import net.morilib.awk.nano.value.AwkUserFunction;
import net.morilib.awk.nano.value.AwkValue;

public class AwkFunctionPrototype
extends AwkExpression {
    private AwkExpression function;
    private List<String> argnames;
    private AwkLocation name;
    private transient AwkFunction memo = null;

    public AwkFunctionPrototype(AwkLocation name, AwkExpression function, Collection<String> argnames) {
        this.name = name;
        this.function = function;
        this.argnames = new ArrayList<String>(argnames);
    }

    public AwkFunctionPrototype(AwkExpression function, Collection<String> argnames) {
        this.name = null;
        this.function = function;
        this.argnames = new ArrayList<String>(argnames);
    }

    public AwkExpression getFunction() {
        return this.function;
    }

    public List<String> getArgnames() {
        return Collections.unmodifiableList(this.argnames);
    }

    public String getName() {
        return this.name.getName();
    }

    @Override
    public AwkValue eval(AwkNamespace ns, AwkFiles f) {
        if (this.memo == null) {
            this.memo = new AwkUserFunction(this.name != null ? this.name.getName() : "<anonymous>", new AwkClosureNamespace(ns), this.function, this.argnames);
        }
        return this.memo;
    }

    public void defun(AwkNamespace ns, boolean useClosure) {
        AwkNamespace s2 = ns;
        int i = 0;
        while (i < this.name.sizeOfPath() - 1) {
            s2 = s2.subnamespace(this.name.getPathOf(i));
            ++i;
        }
        AwkClosureNamespace ev = useClosure ? new AwkClosureNamespace(s2) : null;
        s2.bindFunction(this.name.getName(), new AwkUserFunction(this, (AwkNamespace)ev));
    }
}

