/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.morilib.lisp.nano.LispComplexImpl;
import net.morilib.lisp.nano.LispDouble;
import net.morilib.lisp.nano.LispNumber;
import net.morilib.lisp.nano.LispReal;
import net.morilib.lisp.nano.LispString;
import net.morilib.lisp.nano.LispUtils;

public abstract class LispComplex
extends LispNumber {
    public static LispComplex newComplex(LispReal r, LispReal i) {
        if (r.isNaN() || i.isNaN()) {
            return LispDouble.NaN;
        }
        if (i.isExact() && i.signum() == 0) {
            return r;
        }
        if (r.isExact() && i.isExact()) {
            return new LispComplexImpl(r, i);
        }
        return new LispComplexImpl(r.toInexact(), i.toInexact());
    }

    public static LispComplex newComplex(double r, double i) {
        if (Double.isNaN(r) || Double.isNaN(i)) {
            return LispDouble.NaN;
        }
        return new LispComplexImpl(new LispDouble(r), new LispDouble(i));
    }

    public static LispComplex newPolar(double r, double a) {
        if (Double.isNaN(r) || Double.isNaN(a) || Double.isInfinite(a)) {
            return LispDouble.NaN;
        }
        if (r == 0.0) {
            return LispDouble.ZERO;
        }
        double x = Math.IEEEremainder(a, Math.PI * 2);
        x = x > Math.PI ? x - Math.PI * 2 : x;
        return LispComplex.newComplex(new LispDouble(r), new LispDouble(x));
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean isRational() {
        return false;
    }

    @Override
    public boolean isReal() {
        return false;
    }

    @Override
    public boolean isNaN() {
        return this.getReal().isNaN() || this.getImag().isNaN();
    }

    @Override
    public boolean isOne() {
        return this.getReal().isOne() && this.getImag().isZero();
    }

    @Override
    public BigInteger getBigInteger() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger getDenominator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal getBigDecimal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger getNumerator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract LispComplex uminus();

    @Override
    public abstract LispComplex toExact();

    @Override
    public abstract LispComplex toInexact();

    @Override
    public abstract LispComplex conjugate();

    public abstract LispReal angle();

    @Override
    public LispReal[] getImags() {
        return new LispReal[]{this.getImag()};
    }

    @Override
    public double[] getImagsDouble() {
        return new double[]{this.getImagDouble()};
    }

    @Override
    public LispString toLispString(int radix) {
        if (radix < 2 || radix > 36) {
            throw new IndexOutOfBoundsException("radix is out of range");
        }
        if (radix != 10) {
            throw new IllegalArgumentException("radix except 10 is not supported");
        }
        if (this.getImag().signum() < 0 || this.getImag().isInfinity()) {
            return new LispString(String.valueOf(LispUtils.toWrite(this.getReal())) + LispUtils.toWrite(this.getImag()) + "i");
        }
        return new LispString(String.valueOf(LispUtils.toWrite(this.getReal())) + "+" + LispUtils.toWrite(this.getImag()) + "i");
    }

    @Override
    public LispString toLispString(int radix, int precision) {
        if (radix < 2 || radix > 36) {
            throw new IndexOutOfBoundsException("radix is out of range");
        }
        if (radix != 10) {
            throw new IllegalArgumentException("radix except 10 is not supported");
        }
        String rs = this.getReal().toLispString(radix, precision).getString();
        String is = this.getImag().toLispString(radix, precision).getString();
        if (this.getImag().signum() < 0 && !this.getImag().isInfinity()) {
            return new LispString(String.valueOf(rs) + is + "i");
        }
        return new LispString(String.valueOf(rs) + "+" + is + "i");
    }

    @Override
    public boolean isEqualTo(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return this.getReal().isEqualTo(c.getReal()) && this.getImag().isEqualTo(c.getImag());
        }
        return false;
    }

    @Override
    public LispNumber add(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex((LispReal)this.getReal().add(c.getReal()), (LispReal)this.getImag().add(c.getImag()));
        }
        if (x instanceof LispReal) {
            return LispComplex.newComplex((LispReal)this.getReal().add(x.getReal()), this.getImag());
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber sub(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex((LispReal)this.getReal().sub(c.getReal()), (LispReal)this.getImag().sub(c.getImag()));
        }
        if (x instanceof LispReal) {
            return LispComplex.newComplex((LispReal)this.getReal().sub(x.getReal()), this.getImag());
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber mul(LispNumber x) {
        if (x instanceof LispComplex) {
            LispReal xr = ((LispComplex)x).getReal();
            LispReal xi = ((LispComplex)x).getImag();
            if (xr.signum() == 0) {
                return LispComplex.newComplex((LispReal)this.getImag().uminus().mul(xi), (LispReal)this.getReal().mul(xi));
            }
            return LispComplex.newComplex((LispReal)this.getReal().mul(xr).sub(this.getImag().mul(xi)), (LispReal)this.getImag().mul(xr).add(this.getReal().mul(xi)));
        }
        if (x instanceof LispReal) {
            LispReal r = x.getReal();
            return LispComplex.newComplex((LispReal)this.getReal().mul(r), (LispReal)this.getImag().mul(r));
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber div(LispNumber x) {
        if (x instanceof LispComplex) {
            LispReal xr = ((LispComplex)x).getReal();
            LispReal xi = ((LispComplex)x).getImag();
            if (xr.signum() == 0) {
                return LispComplex.newComplex((LispReal)this.getImag().div(xi), (LispReal)this.getReal().uminus().div(xi));
            }
            LispReal nr = (LispReal)xr.mul(xr).add(xi.mul(xi));
            LispReal x1 = (LispReal)this.getReal().mul(xr).add(this.getImag().mul(xi));
            LispReal x2 = (LispReal)this.getImag().mul(xr).sub(this.getReal().mul(xi));
            return LispComplex.newComplex((LispReal)x1.div(nr), (LispReal)x2.div(nr));
        }
        if (x instanceof LispReal) {
            LispReal r = x.getReal();
            return LispComplex.newComplex((LispReal)this.getReal().div(r), (LispReal)this.getImag().div(r));
        }
        throw new IllegalArgumentException(x.toString());
    }
}

