/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.util.List;
import net.morilib.lisp.nano.ClosureClass;
import net.morilib.lisp.nano.CodeExecutor;
import net.morilib.lisp.nano.CompiledCode;
import net.morilib.lisp.nano.Cons;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.IntStack;
import net.morilib.lisp.nano.LispCompiler;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.Nil;
import net.morilib.lisp.nano.SymbolName;
import net.morilib.lisp.nano.Syntax;
import net.morilib.lisp.nano.Undef;

public class SynSetS
extends Syntax {
    private Datum getSetval(Datum bcdr, LispMessage mesg) {
        if (bcdr instanceof Cons) {
            Cons c1 = (Cons)bcdr;
            if (c1.getCdr() != Nil.NIL) {
                throw mesg.getError("err.set.malform");
            }
            return c1.getCar();
        }
        throw mesg.getError("err.set.malform");
    }

    @Override
    void compile(Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist, CodeExecutor exec, IntStack memento) {
        Datum bcdr;
        Datum bcar;
        if (body instanceof Cons) {
            bcar = ((Cons)body).getCar();
            bcdr = ((Cons)body).getCdr();
            if (!(bcar instanceof SymbolName)) {
                throw mesg.getError("err.set.name");
            }
        } else {
            throw mesg.getError("err.set.malform");
        }
        CompiledCode.Builder mbuild = new CompiledCode.Builder();
        Environment menv = new Environment(env);
        comp.compile(this.getSetval(bcdr, mesg), menv, mbuild, callsym, false, symlist, exec, memento);
        mbuild.addReturnOp();
        ClosureClass cl = new ClosureClass(Nil.NIL, mbuild.getCodeRef());
        build.addPush(cl);
        build.addBeginList();
        build.addEndList();
        build.addCall();
        build.addSet(bcar);
        build.addPop();
        build.addPush(Undef.UNDEF);
    }
}

