/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano.subr;

import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.LispDouble;
import net.morilib.lisp.nano.LispInteger;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.LispNotSupportedException;
import net.morilib.lisp.nano.LispNumber;
import net.morilib.lisp.nano.subr.UnaryArgs;

public class Numerator
extends UnaryArgs {
    @Override
    protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
        if (c1a instanceof LispNumber) {
            LispNumber n1 = (LispNumber)c1a;
            if (!n1.isReal()) {
                throw mesg.getError("err.require.real", n1);
            }
            if (n1.isExact()) {
                return LispInteger.valueOf(n1.getReal().getNumerator());
            }
            try {
                return new LispDouble(n1.getReal().getNumerator().doubleValue());
            }
            catch (LispNotSupportedException e) {
                throw mesg.getError(e.getMessage(), c1a);
            }
        }
        throw mesg.getError("err.require.real", c1a);
    }
}

