/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

public class PeekableReader
extends Reader {
    public static final PeekableReader in = new PeekableReader(new InputStreamReader(System.in));
    private Reader rd;
    private int peek = -1;
    private int unget = -1;
    private boolean _notinit = true;

    public PeekableReader(Reader rd) {
        this.rd = rd;
    }

    private void _read() throws IOException {
        this.peek = this.rd.read();
    }

    private void _init() throws IOException {
        if (this._notinit) {
            this._read();
            this._notinit = false;
        }
    }

    @Override
    public int read() throws IOException {
        this._init();
        int r = this.unget;
        if (r >= 0) {
            this.unget = -1;
        } else {
            r = this.peek;
            if (r >= 0) {
                r = this.peek;
                this._notinit = true;
            }
        }
        return r;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int o = off;
        int l = len;
        this._init();
        if (l-- <= 0 || this.unget < 0) {
            return 0;
        }
        cbuf[o++] = (char)this.unget;
        this.unget = -1;
        if (l-- > 0 && this.peek >= 0) {
            cbuf[o++] = (char)this.peek;
            int r = this.rd.read(cbuf, o, l) + (o - off);
            this._read();
            return r;
        }
        return o - off;
    }

    public int peek() throws IOException {
        this._init();
        return this.unget >= 0 ? this.unget : this.peek;
    }

    public void unget(int c) {
        this.unget = c;
    }

    @Override
    public void close() throws IOException {
        this.rd.close();
    }
}

