/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import net.morilib.automata.NFA;
import net.morilib.automata.NFAEdges;
import net.morilib.automata.NFAState;
import net.morilib.automata.TextBound;
import net.morilib.range.Interval;
import net.morilib.range.Range;

public class NFAEpsilonLink<T, B>
implements NFA<T, NFAState, B> {
    private NFA<T, NFAState, B> nfa;
    private NFAState end;

    public NFAEpsilonLink(NFA<T, NFAState, B> nfa, NFAState e) {
        this.nfa = nfa;
        this.end = e;
    }

    @Override
    public boolean isState(NFAState o) {
        return this.nfa.isState(o) || this.end.equals(o);
    }

    @Override
    public Set<NFAState> getStates(NFAState state, T alphabet) {
        return this.nfa.getStates(state, alphabet);
    }

    @Override
    public Set<NFAState> getStates(NFAState state, Range rng) {
        return this.nfa.getStates(state, rng);
    }

    @Override
    public Set<NFAState> getStates(NFAState state, EnumSet<TextBound> bound) {
        return this.nfa.getStates(state, bound);
    }

    @Override
    public Set<NFAState> getStatesEpsilon(NFAState state) {
        if (this.nfa.isAccepted(state)) {
            return Collections.singleton(this.end);
        }
        return this.nfa.getStatesEpsilon(state);
    }

    @Override
    public Set<NFAState> getStatesBound(NFAState state, EnumSet<TextBound> bound) {
        return this.nfa.getStatesBound(state, bound);
    }

    @Override
    public Set<NFAState> getInitialStates() {
        return this.nfa.getInitialStates();
    }

    @Override
    public boolean isInitialState(NFAState o) {
        return this.nfa.isInitialState(o);
    }

    @Override
    public boolean isFinal(NFAState state) {
        return this.end.equals(state);
    }

    @Override
    public boolean isFinalAny(Set<NFAState> states) {
        return states.contains(this.end);
    }

    @Override
    public NFAEdges<T> getEdges(NFAState state) {
        return this.nfa.getEdges(state);
    }

    @Override
    public Set<Interval> nextAlphabets(NFAState state) {
        return this.nfa.nextAlphabets(state);
    }

    @Override
    public Iterable<Interval> nextAlphabets(Set<NFAState> states) {
        return this.nfa.nextAlphabets(states);
    }

    @Override
    public Set<T> nextDiscreteAlphabets(NFAState state) {
        return this.nfa.nextDiscreteAlphabets(state);
    }

    @Override
    public Iterable<T> nextDiscreteAlphabets(Set<NFAState> states) {
        return this.nfa.nextDiscreteAlphabets(states);
    }

    @Override
    public Set<NFAState> getAcceptedStates() {
        return Collections.singleton(this.end);
    }

    @Override
    public Set<B> getMatchTag(NFAState state) {
        return this.nfa.getMatchTag(state);
    }

    @Override
    public Set<B> getMatchTagEnd(NFAState state) {
        return this.nfa.getMatchTagEnd(state);
    }

    @Override
    public Set<NFAState> getAccept(NFAState state) {
        return Collections.singleton(this.end);
    }

    @Override
    public boolean isAccepted(NFAState state) {
        return this.end.equals(state);
    }
}

