/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.nio.charset.Charset;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShProcessNumber;
import net.morilib.sh.ShRuntimeException;
import net.morilib.sh.ShSignal;
import net.morilib.sh.ShTree;

public class ShRootShellEnvironment
implements ShEnvironment {
    private ShEnvironment env;
    private Map<String, String> map;
    private Map<String, ShTree> functions;
    private Map<String, Void> flags;
    private Map<String, ShEnvironment.Attributes> attrs;
    private EnumMap<ShSignal, String> traps;

    public ShRootShellEnvironment(ShEnvironment env) {
        if (env == null) {
            throw new NullPointerException();
        }
        this.env = env;
        this.map = new HashMap<String, String>();
        this.functions = new HashMap<String, ShTree>();
        this.flags = new HashMap<String, Void>();
        this.attrs = new HashMap<String, ShEnvironment.Attributes>();
        this.traps = new EnumMap(ShSignal.class);
    }

    @Override
    public String find(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.equals("RANDOM")) {
            return String.valueOf((int)(Math.random() * 32768.0));
        }
        if (name.equals("$") && !this.contains("$")) {
            String v = String.valueOf(ShProcessNumber.getNumber());
            this.put("$", v);
            return v;
        }
        String v = this.map.get(name);
        if (v != null) {
            return v;
        }
        if (this.env.contains(name)) {
            return this.env.find(name);
        }
        if (this.isSet("nounset")) {
            throw new ShRuntimeException();
        }
        return "";
    }

    @Override
    public void bind(String name, String value) {
        if (this.isReadonly(name)) {
            throw new ShRuntimeException();
        }
        if (this.map.containsKey(name) || !this.env.contains(name)) {
            this.map.put(name, value);
        } else {
            this.env.put(name, value);
        }
    }

    @Override
    public void put(String name, String value) {
        this.map.put(name, value);
    }

    @Override
    public ShEnvironment getEnvironment() {
        return this.env;
    }

    @Override
    public boolean contains(String name) {
        return this.map.containsKey(name) || this.env.contains(name);
    }

    @Override
    public boolean isEnvironment() {
        return false;
    }

    @Override
    public List<String> getPath() {
        return this.env.getPath();
    }

    @Override
    public void bind(String name, ShTree function) {
        this.functions.put(name, function);
    }

    @Override
    public void put(String name, ShTree function) {
        this.functions.put(name, function);
    }

    @Override
    public ShTree findFunction(String name) {
        return this.functions.get(name);
    }

    @Override
    public void export(String name) {
        if (this.map.containsKey(name)) {
            this.env.bind(name, this.map.get(name));
            this.map.remove(name);
        } else if (!this.env.contains(name)) {
            this.env.bind(name, "");
        }
    }

    @Override
    public boolean isSet(String name) {
        return this.flags.containsKey(name);
    }

    @Override
    public void set(String name) {
        this.flags.put(name, null);
    }

    @Override
    public void reset(String name) {
        this.flags.remove(name);
    }

    @Override
    public void set(String name, boolean value) {
        if (value) {
            this.flags.put(name, null);
        } else {
            this.flags.remove(name);
        }
    }

    @Override
    public void unbind(String name) {
        if (this.map.containsKey(name)) {
            this.map.remove(name);
        } else {
            this.env.unbind(name);
        }
    }

    @Override
    public boolean isReadonly(String name) {
        ShEnvironment.Attributes a;
        return this.isSystem(name) || this.map.containsKey(name) && (a = this.attrs.get(name)) != null && a.isReadonly() || !this.map.containsKey(name) && this.env.isReadonly(name);
    }

    @Override
    public boolean isSystem(String name) {
        return name.matches("[0-9]+") || name.equals("@") || name.equals("*") || name.equals("$");
    }

    @Override
    public void setReadonly(String name) {
        if (this.map.containsKey(name)) {
            this.attrs.put(name, READONLY);
        } else {
            this.env.setReadonly(name);
        }
    }

    @Override
    public Properties toProperties() {
        Properties p = this.env.toProperties();
        for (Map.Entry<String, String> e : this.map.entrySet()) {
            p.setProperty(e.getKey(), e.getValue());
        }
        return p;
    }

    @Override
    public String getTrap(ShSignal signal) {
        return this.traps.get((Object)signal);
    }

    @Override
    public void setTrap(ShSignal signal, String cmd) {
        this.traps.put(signal, cmd);
    }

    @Override
    public Charset getCharset() {
        return this.env.getCharset();
    }

    @Override
    public Locale getLocale() {
        return this.env.getLocale();
    }
}

