/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShRuntime;
import net.morilib.sh.ShRuntimeException;
import net.morilib.sh.ShSyntaxException;
import net.morilib.sh.ShToken;
import net.morilib.sh.arith.ShExprLexer;
import net.morilib.sh.arith.ShExprParser;
import net.morilib.sh.arith.ShExprSyntaxException;
import net.morilib.sh.misc.XtraceStream;
import net.morilib.unix.glob.Wildcard;

public class ShString
extends ShToken {
    private static final InputStream NULL_INS = new InputStream(){

        @Override
        public int read() {
            return -1;
        }

        @Override
        public void close() {
        }

        @Override
        public int read(byte[] b, int off, int len) {
            return -1;
        }

        @Override
        public int read(byte[] b) {
            return -1;
        }

        @Override
        public long skip(long n) {
            return 0L;
        }
    };
    private static final PrintStream NULL_OUS = new PrintStream(new OutputStream(){

        @Override
        public void write(int b) {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }

        @Override
        public void write(byte[] b) {
        }
    });
    private static final String D_MSG = "parameter null or not set";
    private static final Pattern PTN_SLICE = Pattern.compile("(.+):([0-9]+):([0-9]+)");
    private String value;

    public ShString(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public List<ShToken> replaceBracket() {
        return Collections.singletonList(this);
    }

    @Override
    public ShToken replaceTilde(ShEnvironment env) {
        return new ShString(ShToken.replaceTilde(env, this.value));
    }

    private int getargnum(ShEnvironment env) {
        try {
            return Integer.parseInt(env.find("#"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    /*
     * Unable to fully structure code
     */
    private StringBuffer setvar(ShEnvironment env, String ifs, PrintStream err, StringBuffer b, List<ShToken> l, String q, String s) {
        block23: {
            block26: {
                block25: {
                    block24: {
                        block22: {
                            d = "";
                            if (!s.equals("*")) break block22;
                            m = this.getargnum(env);
                            k = 1;
                            while (k < m) {
                                b.append(d).append(env.find(String.valueOf(k)));
                                if (d.equals("")) {
                                    d = ifs.substring(0, 1);
                                }
                                ++k;
                            }
                            break block23;
                        }
                        if (!s.equals("@")) break block24;
                        m = this.getargnum(env);
                        k = 1;
                        while (k < m) {
                            if (k > 1) {
                                b = new StringBuffer(q);
                            }
                            b.append(env.find(String.valueOf(k)));
                            if (k < m - 1) {
                                l.add(new ShString(b.append(q).toString()));
                            }
                            ++k;
                        }
                        break block23;
                    }
                    x = s.indexOf(":-");
                    if (x <= 0) break block25;
                    v = env.find(s.substring(0, x));
                    v = v == null || v.equals("") != false ? s.substring(x + 2) : v;
                    b.append(v);
                    break block23;
                }
                x = s.indexOf(":=");
                if (x <= 0) break block26;
                v = env.find(s.substring(0, x));
                if (v == null || v.equals("")) {
                    v = s.substring(x + 2);
                    env.bind(s.substring(0, x), v);
                }
                b.append(v);
                break block23;
            }
            x = s.indexOf(":?");
            if (x <= 0) ** GOTO lbl59
            v = env.find(s.substring(0, x));
            if (v != null && !v.equals("")) {
                b.append(v);
            } else {
                err.print(s.substring(0, x));
                err.print(": ");
                v = s.substring(x + 2);
                err.println(v.equals("") != false ? "parameter null or not set" : v);
                throw new ShRuntimeException();
lbl59:
                // 1 sources

                x = s.indexOf(":+");
                if (x > 0) {
                    v = env.find(s.substring(0, x));
                    v = v == null || v.equals("") != false ? "" : s.substring(x + 2);
                    b.append(v);
                } else {
                    t = ShString.PTN_SLICE.matcher(s);
                    if (t.matches()) {
                        v = env.find(t.group(1));
                        x = Integer.parseInt(t.group(2));
                        y = Integer.parseInt(t.group(3));
                        if (x >= v.length()) {
                            return b;
                        }
                        if (y + x >= v.length()) {
                            y = v.length() - x;
                        }
                        b.append(v.substring(x, x + y));
                    } else {
                        x = s.indexOf("##");
                        if (x > 0) {
                            v = env.find(s.substring(0, x));
                            y = Wildcard.compile(s.substring(x + 2)).lookingAtLongest(v, 0);
                            b.append(y < 0 ? v : v.substring(y));
                        } else {
                            x = s.indexOf(35);
                            if (x > 0) {
                                v = env.find(s.substring(0, x));
                                y = Wildcard.compile(s.substring(x + 1)).lookingAtShortest(v, 0);
                                b.append(y < 0 ? v : v.substring(y));
                            } else {
                                x = s.indexOf("%%");
                                if (x > 0) {
                                    v = env.find(s.substring(0, x));
                                    y = Wildcard.compile(s.substring(x + 2)).lastLookingAtLongest(v);
                                    b.append(y < 0 ? v : v.substring(0, y));
                                } else {
                                    x = s.indexOf(37);
                                    if (x > 0) {
                                        v = env.find(s.substring(0, x));
                                        y = Wildcard.compile(s.substring(x + 1)).lastLookingAtShortest(v);
                                        b.append(y < 0 ? v : v.substring(0, y));
                                    } else {
                                        v = env.find(s);
                                        b.append(v != null ? v : "");
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return b;
    }

    @Override
    public List<ShToken> replaceParameter(ShEnvironment env, PrintStream err) {
        ArrayList<ShToken> l = new ArrayList<ShToken>();
        StringBuffer b = new StringBuffer();
        StringBuffer n = null;
        String ifs = env.find("IFS");
        S1 stat = S1.INIT;
        int i = 0;
        while (i < this.value.length()) {
            char c = this.value.charAt(i);
            switch (stat) {
                case INIT: {
                    if (c == '\'') {
                        b.append(c);
                        stat = S1.SQUT;
                        break;
                    }
                    if (c == '\"') {
                        b.append(c);
                        stat = S1.DQUT;
                        break;
                    }
                    if (c == '$') {
                        stat = S1.DOLR;
                        break;
                    }
                    b.append(c);
                    if (c != '\\') break;
                    stat = S1.ESC1;
                    break;
                }
                case ESC1: {
                    b.append(c);
                    stat = S1.INIT;
                    break;
                }
                case SQUT: {
                    b.append(c);
                    if (c != '\'') break;
                    stat = S1.INIT;
                    break;
                }
                case DOLR: {
                    if (c == '{') {
                        n = new StringBuffer();
                        stat = S1.PRAM;
                        break;
                    }
                    b.append('$').append(c);
                    stat = S1.INIT;
                    break;
                }
                case PRAM: {
                    if (c == '}') {
                        b = this.setvar(env, ifs, err, b, l, "", n.toString());
                        stat = S1.INIT;
                        break;
                    }
                    n.append(c);
                    break;
                }
                case DQUT: {
                    if (c == '$') {
                        stat = S1.DDLR;
                        break;
                    }
                    b.append(c);
                    if (c == '\"') {
                        stat = S1.INIT;
                    }
                    if (c != '\\') break;
                    stat = S1.ESC2;
                    break;
                }
                case ESC2: {
                    b.append(c);
                    stat = S1.DQUT;
                    break;
                }
                case DDLR: {
                    if (c == '{') {
                        n = new StringBuffer();
                        stat = S1.DPRM;
                        break;
                    }
                    b.append('$').append(c);
                    stat = S1.DQUT;
                    break;
                }
                case DPRM: {
                    if (c == '}') {
                        b = this.setvar(env, ifs, err, b, l, "\"", n.toString());
                        stat = S1.INIT;
                        break;
                    }
                    n.append(c);
                }
            }
            ++i;
        }
        if (stat.equals((Object)S1.PRAM)) {
            b.append("${").append(n.toString());
        }
        if (b.length() > 0) {
            l.add(new ShString(b.toString()));
        }
        return l;
    }

    private void appendcommand(ShEnvironment env, ShFileSystem fs, ShRuntime run, XtraceStream prompt, StringBuffer b, String n) throws IOException, ShSyntaxException {
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        prompt.upLevel();
        run.eval(env, fs, NULL_INS, new PrintStream(stdout), NULL_OUS, prompt, n);
        prompt.downLevel();
        byte[] a = stdout.toByteArray();
        int k = a.length;
        while (--k >= 0 && (a[k] == 10 || a[k] == 13)) {
        }
        b.append(new String(stdout.toByteArray(), 0, k + 1, env.getCharset()));
    }

    @Override
    public ShToken replaceCommand(ShEnvironment env, ShFileSystem fs, ShRuntime run, XtraceStream p) throws IOException, ShSyntaxException {
        StringBuffer n = null;
        S2 stat = S2.INIT;
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < this.value.length()) {
            char c = this.value.charAt(i);
            switch (stat) {
                case INIT: {
                    if (c == '\'') {
                        b.append(c);
                        stat = S2.SQUT;
                        break;
                    }
                    if (c == '$') {
                        stat = S2.DOLR;
                        break;
                    }
                    b.append(c);
                    if (c != '\\') break;
                    stat = S2.ESC1;
                    break;
                }
                case ESC1: {
                    b.append(c);
                    stat = S2.INIT;
                    break;
                }
                case SQUT: {
                    b.append(c);
                    if (c != '\'') break;
                    stat = S2.INIT;
                    break;
                }
                case DOLR: {
                    if (c == '(') {
                        n = new StringBuffer();
                        stat = S2.COMD;
                        break;
                    }
                    b.append('$').append(c);
                    stat = S2.INIT;
                    break;
                }
                case COMD: {
                    if (c == '(') {
                        b.append("$((");
                        stat = S2.NUM1;
                        break;
                    }
                    if (c == ')') {
                        stat = S2.INIT;
                        break;
                    }
                    n.append(c);
                    stat = S2.CMD2;
                    break;
                }
                case CMD2: {
                    if (c == ')') {
                        this.appendcommand(env, fs, run, p, b, n.toString());
                        stat = S2.INIT;
                        break;
                    }
                    n.append(c);
                    break;
                }
                case NUM1: {
                    if (c == ')') {
                        b.append(')');
                        stat = S2.NUM2;
                        break;
                    }
                    if (c == '$') {
                        stat = S2.NUM3;
                        break;
                    }
                    b.append(c);
                    break;
                }
                case NUM2: {
                    if (c == ')') {
                        b.append(')');
                        stat = S2.INIT;
                        break;
                    }
                    if (c == '$') {
                        stat = S2.NUM3;
                        break;
                    }
                    b.append(c);
                    stat = S2.INIT;
                    break;
                }
                case NUM3: {
                    if (c == '(') {
                        n = new StringBuffer();
                        stat = S2.NUM4;
                        break;
                    }
                    b.append('$').append(c);
                    stat = S2.NUM1;
                    break;
                }
                case NUM4: {
                    if (c == ')') {
                        this.appendcommand(env, fs, run, p, b, n.toString());
                        stat = S2.NUM1;
                        break;
                    }
                    n.append(c);
                }
            }
            ++i;
        }
        if (stat.equals((Object)S2.COMD) || stat.equals((Object)S2.CMD2)) {
            b.append("$(").append(n.toString());
        }
        return new ShString(b.toString());
    }

    @Override
    public ShToken replaceArithmetic(ShEnvironment env) throws ShSyntaxException {
        StringBuffer b = new StringBuffer();
        StringBuffer n = null;
        S4 stat = S4.INIT;
        try {
            int i = 0;
            while (i < this.value.length()) {
                char c = this.value.charAt(i);
                switch (stat) {
                    case INIT: {
                        if (c == '\'') {
                            b.append(c);
                            stat = S4.SQUT;
                            break;
                        }
                        if (c == '$') {
                            stat = S4.DOLR;
                            break;
                        }
                        b.append(c);
                        if (c != '\\') break;
                        stat = S4.ESC1;
                        break;
                    }
                    case ESC1: {
                        b.append(c);
                        stat = S4.INIT;
                        break;
                    }
                    case SQUT: {
                        b.append(c);
                        if (c != '\'') break;
                        stat = S4.INIT;
                        break;
                    }
                    case DOLR: {
                        if (c == '(') {
                            n = new StringBuffer();
                            stat = S4.DLR2;
                            break;
                        }
                        b.append('$').append(c);
                        stat = S4.INIT;
                        break;
                    }
                    case DLR2: {
                        if (c == '(') {
                            n = new StringBuffer();
                            stat = S4.ARIT;
                            break;
                        }
                        b.append('$').append('(').append(c);
                        stat = S4.INIT;
                        break;
                    }
                    case ARIT: {
                        if (c == ')') {
                            stat = S4.ARI2;
                            break;
                        }
                        n.append(c);
                        break;
                    }
                    case ARI2: {
                        if (c == ')') {
                            ShExprLexer r = new ShExprLexer(new StringReader(n.toString()));
                            b.append(ShExprParser.parseExpression(env, r).toString());
                            stat = S4.INIT;
                            break;
                        }
                        n.append(')').append(c);
                        stat = S4.ARIT;
                    }
                }
                ++i;
            }
            return new ShString(b.toString());
        }
        catch (ShExprSyntaxException e) {
            throw new ShSyntaxException();
        }
        catch (IOException e) {
            throw new ShSyntaxException();
        }
    }

    @Override
    public List<String> splitWord(String ifs) {
        S3 stat = S3.INIT;
        if (ifs.length() > 0) {
            StringBuffer b = new StringBuffer();
            ArrayList<String> l = new ArrayList<String>();
            int i = 0;
            while (i < this.value.length()) {
                char c = this.value.charAt(i);
                switch (stat) {
                    case INIT: {
                        if (ifs.indexOf(c) >= 0) break;
                        b.append(c);
                        if (c == '\'') {
                            stat = S3.SQUT;
                            break;
                        }
                        if (c == '\"') {
                            stat = S3.DQUT;
                            break;
                        }
                        if (c == '\\') {
                            stat = S3.ESC1;
                            break;
                        }
                        stat = S3.SPLT;
                        break;
                    }
                    case SPLT: {
                        if (ifs.indexOf(c) >= 0) {
                            l.add(b.toString());
                            b = new StringBuffer();
                            stat = S3.INIT;
                            break;
                        }
                        b.append(c);
                        if (c == '\'') {
                            stat = S3.SQUT;
                            break;
                        }
                        if (c == '\"') {
                            stat = S3.DQUT;
                            break;
                        }
                        if (c != '\\') break;
                        stat = S3.ESC1;
                        break;
                    }
                    case ESC1: {
                        b.append(c);
                        stat = S3.SPLT;
                        break;
                    }
                    case SQUT: {
                        b.append(c);
                        if (c != '\'') break;
                        stat = S3.SPLT;
                        break;
                    }
                    case DQUT: {
                        b.append(c);
                        if (c == '\"') {
                            stat = S3.SPLT;
                            break;
                        }
                        if (c != '\\') break;
                        stat = S3.ESC2;
                        break;
                    }
                    case ESC2: {
                        b.append(c);
                        stat = S3.DQUT;
                    }
                }
                ++i;
            }
            if (b.length() > 0) {
                l.add(b.toString());
            }
            return l;
        }
        return Collections.singletonList(this.value);
    }

    @Override
    public boolean isWildcard() {
        return ShToken.isWildcard(this.value);
    }

    @Override
    public boolean isBind() {
        return ShToken.isBind(this.value);
    }

    @Override
    public void bindVariable(ShEnvironment env, ShFileSystem fs, ShRuntime run, PrintStream err, XtraceStream p) throws IOException, ShSyntaxException {
        ShToken.bindVariable(env, fs, run, err, p, this.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof ShString && this.value.equals(((ShString)o).value);
    }

    public String toString() {
        return this.value;
    }

    private static enum S1 {
        INIT,
        ESC1,
        SQUT,
        DOLR,
        PRAM,
        DQUT,
        ESC2,
        DDLR,
        DPRM;

    }

    private static enum S2 {
        INIT,
        ESC1,
        SQUT,
        DOLR,
        COMD,
        CMD2,
        NUM1,
        NUM2,
        NUM3,
        NUM4;

    }

    private static enum S3 {
        INIT,
        ESC1,
        SQUT,
        DQUT,
        ESC2,
        SPLT;

    }

    private static enum S4 {
        INIT,
        ESC1,
        SQUT,
        DOLR,
        DLR2,
        ARIT,
        ARI2;

    }
}

