/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.morilib.sh.AbstractShEnvironment;
import net.morilib.sh.ShEnvironment;

public class ShSubEnvironment
extends AbstractShEnvironment {
    private ShEnvironment env;
    private Map<String, String> map;
    private Map<String, ShEnvironment.Attributes> attrs;

    public ShSubEnvironment(ShEnvironment env) {
        if (env == null) {
            throw new NullPointerException();
        }
        this.env = env;
        this.map = new HashMap<String, String>();
        this.attrs = new HashMap<String, ShEnvironment.Attributes>();
    }

    @Override
    public void bind(String name, String value) {
        this.map.put(name, value);
        this.setpath();
    }

    @Override
    public boolean contains(String name) {
        return this.map.containsKey(name) || this.env.contains(name);
    }

    @Override
    public void export(String name) {
        if (!this.env.contains(name)) {
            this.map.put(name, "");
        }
    }

    @Override
    public String find(String name) {
        return this.map.containsKey(name) ? this.map.get(name) : this.env.find(name);
    }

    @Override
    public ShEnvironment getEnvironment() {
        return this;
    }

    @Override
    public boolean isReadonly(String name) {
        ShEnvironment.Attributes a = this.attrs.get(name);
        return a != null ? a.isReadonly() : this.env.isReadonly(name);
    }

    @Override
    public void put(String name, String value) {
        this.map.put(name, value);
    }

    @Override
    public void setReadonly(String name) {
        if (this.map.containsKey(name)) {
            this.attrs.put(name, READONLY);
        } else {
            this.env.setReadonly(name);
        }
    }

    @Override
    public Properties toProperties() {
        Properties p = this.env.toProperties();
        for (Map.Entry<String, String> e : this.map.entrySet()) {
            p.setProperty(e.getKey(), e.getValue());
        }
        return p;
    }

    @Override
    public void unbind(String name) {
        if (this.map.containsKey(name)) {
            this.map.remove(name);
        } else {
            this.env.unbind(name);
        }
    }
}

