/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.unix.misc;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class Tr {
    private static final T1 DF = new T1(){

        @Override
        public int indexOf(String s, int c) {
            return Tr.indexOf(s, c);
        }
    };
    private static final T1 CF = new T1(){

        @Override
        public int indexOf(String s, int c) {
            return Tr.complementIndexOf(s, c);
        }
    };
    private static final T1 ALNUM = new T1(){

        @Override
        public int indexOf(String s, int c) {
            return ALPHA.indexOf(s, c) < 0 ? DIGIT.indexOf(s, c) : 0;
        }
    };
    private static final T1 ALPHA = new T1(){

        @Override
        public int indexOf(String s, int c) {
            return UPPER.indexOf(s, c) < 0 ? LOWER.indexOf(s, c) : 0;
        }
    };
    private static final T1 BLANK = new T1(){

        @Override
        public int indexOf(String s, int c) {
            return " \t\u3000".indexOf(c) >= 0 ? 0 : -1;
        }
    };
    private static final T1 CNTRL = new T1(){

        @Override
        public int indexOf(String s, int c) {
            return Character.isISOControl(c) ? 0 : -1;
        }
    };
    private static final T1 DIGIT = new T1(){

        @Override
        public int indexOf(String s, int c) {
            return Character.isDigit(c) ? 0 : -1;
        }
    };
    private static final T1 GRAPH = new T1(){

        @Override
        public int indexOf(String s, int c) {
            return Character.isISOControl(c) ? -1 : BLANKC.indexOf(s, c);
        }
    };
    private static final T1 LOWER = new T1(){

        @Override
        public int indexOf(String s, int c) {
            return Character.isLowerCase(c) ? 0 : -1;
        }
    };
    private static final T1 PRINT = new T1(){

        @Override
        public int indexOf(String s, int c) {
            return Character.isISOControl(c) ? -1 : 0;
        }
    };
    private static final String PNCT = "!\"#$%&'()=-~^|\\[]{}*+_?.><,@`;:";
    private static final String PNCTF = "\uff01\u201d\uff03\uff04\uff05\uff06\u2019\uff08\uff09\uff1d\u30fc\uff3e\u301c\uffe5\uff20\uff40\uff5c\uff5b\uff5d\uff3b\uff3d\uff1a\uff0a\uff1b\uff0b\uff3f\uff1f\uff0f\uff0e\uff0c\uff0e\u300c\u300d\u3002\u3001\u30fb";
    private static final T1 PUNCT = new T1(){

        @Override
        public int indexOf(String s, int c) {
            if (Tr.PNCT.indexOf(c) >= 0 || Tr.PNCTF.indexOf(c) >= 0) {
                return 0;
            }
            return -1;
        }
    };
    private static final T1 SPACE = new T1(){

        @Override
        public int indexOf(String s, int c) {
            return Character.isWhitespace(c) ? 0 : -1;
        }
    };
    private static final T1 UPPER = new T1(){

        @Override
        public int indexOf(String s, int c) {
            return Character.isUpperCase(c) ? 0 : -1;
        }
    };
    private static final T1 XDIGIT = new T1(){

        @Override
        public int indexOf(String s, int c) {
            return "0123456789ABCDEFabcdef".indexOf(c) >= 0 ? 0 : -1;
        }
    };
    private static final T1 ALNUMC = new T1(){

        @Override
        public int indexOf(String s, int c) {
            return ALNUM.indexOf(s, c) < 0 ? 0 : -1;
        }
    };
    private static final T1 ALPHAC = new T1(){

        @Override
        public int indexOf(String s, int c) {
            return ALPHA.indexOf(s, c) < 0 ? 0 : -1;
        }
    };
    private static final T1 BLANKC = new T1(){

        @Override
        public int indexOf(String s, int c) {
            return BLANK.indexOf(s, c) < 0 ? 0 : -1;
        }
    };
    private static final T1 CNTRLC = new T1(){

        @Override
        public int indexOf(String s, int c) {
            return CNTRL.indexOf(s, c) < 0 ? 0 : -1;
        }
    };
    private static final T1 DIGITC = new T1(){

        @Override
        public int indexOf(String s, int c) {
            return DIGIT.indexOf(s, c) < 0 ? 0 : -1;
        }
    };
    private static final T1 GRAPHC = new T1(){

        @Override
        public int indexOf(String s, int c) {
            return GRAPH.indexOf(s, c) < 0 ? 0 : -1;
        }
    };
    private static final T1 LOWERC = new T1(){

        @Override
        public int indexOf(String s, int c) {
            return LOWER.indexOf(s, c) < 0 ? 0 : -1;
        }
    };
    private static final T1 PRINTC = new T1(){

        @Override
        public int indexOf(String s, int c) {
            return PRINT.indexOf(s, c) < 0 ? 0 : -1;
        }
    };
    private static final T1 PUNCTC = new T1(){

        @Override
        public int indexOf(String s, int c) {
            return PUNCT.indexOf(s, c) < 0 ? 0 : -1;
        }
    };
    private static final T1 SPACEC = new T1(){

        @Override
        public int indexOf(String s, int c) {
            return SPACE.indexOf(s, c) < 0 ? 0 : -1;
        }
    };
    private static final T1 UPPERC = new T1(){

        @Override
        public int indexOf(String s, int c) {
            return UPPER.indexOf(s, c) < 0 ? 0 : -1;
        }
    };
    private static final T1 XDIGITC = new T1(){

        @Override
        public int indexOf(String s, int c) {
            return XDIGIT.indexOf(s, c) < 0 ? 0 : -1;
        }
    };
    private static Map<String, T1> classe = new HashMap<String, T1>();
    private static Map<String, T1> classec;

    static {
        classe.put("[:alnum:]", ALNUM);
        classe.put("[:alpha:]", ALPHA);
        classe.put("[:blank:]", BLANK);
        classe.put("[:cntrl:]", CNTRL);
        classe.put("[:digit:]", DIGIT);
        classe.put("[:graph:]", GRAPH);
        classe.put("[:lower:]", LOWER);
        classe.put("[:print:]", PRINT);
        classe.put("[:punct:]", PUNCT);
        classe.put("[:space:]", SPACE);
        classe.put("[:upper:]", UPPER);
        classe.put("[:xdigit:]", XDIGIT);
        classec = new HashMap<String, T1>();
        classec.put("[:alnum:]", ALNUMC);
        classec.put("[:alpha:]", ALPHAC);
        classec.put("[:blank:]", BLANKC);
        classec.put("[:cntrl:]", CNTRLC);
        classec.put("[:digit:]", DIGITC);
        classec.put("[:graph:]", GRAPHC);
        classec.put("[:lower:]", LOWERC);
        classec.put("[:print:]", PRINTC);
        classec.put("[:punct:]", PUNCTC);
        classec.put("[:space:]", SPACEC);
        classec.put("[:upper:]", UPPERC);
        classec.put("[:xdigit:]", XDIGITC);
    }

    static int _get16(String s, int[] i) {
        if (i[0] >= s.length()) {
            return -1;
        }
        int n = i[0];
        i[0] = n + 1;
        char y = s.charAt(n);
        if (y >= '0' && y <= '9') {
            return y - 48;
        }
        if (y >= 'a' && y <= 'f') {
            return y - 97 + 10;
        }
        if (y >= 'A' && y <= 'F') {
            return y - 65 + 10;
        }
        i[0] = i[0] - 1;
        return -1;
    }

    static int _add16(int dgts, String s, int[] i) {
        int r = 0;
        if (i[0] >= s.length()) {
            return -1;
        }
        int j = 0;
        while (j < dgts) {
            int x = Tr._get16(s, i);
            if (x < 0) {
                return r;
            }
            r = r * 16 + x;
            ++j;
        }
        return r;
    }

    static int _get8(String s, int[] i) {
        if (i[0] >= s.length()) {
            return -1;
        }
        int n = i[0];
        i[0] = n + 1;
        char y = s.charAt(n);
        if (y >= '0' && y <= '7') {
            return y - 48;
        }
        i[0] = i[0] - 1;
        return -1;
    }

    static int _add8(int dgts, String s, int[] i) {
        int r = 0;
        if (i[0] >= s.length()) {
            return -1;
        }
        int j = 0;
        while (j < dgts) {
            int x = Tr._get8(s, i);
            if (x < 0) {
                return r;
            }
            r = r * 8 + x;
            ++j;
        }
        return r;
    }

    static int _getch(String s, int[] i) {
        int x = s.codePointAt(i[0]);
        i[0] = i[0] + (x > 65535 ? 2 : 1);
        if (x == 92 && i[0] < s.length()) {
            int n = i[0];
            i[0] = n + 1;
            char c = s.charAt(n);
            x = c;
            switch (c) {
                case 'a': {
                    return 7;
                }
                case 'b': {
                    return 8;
                }
                case 'f': {
                    return 11;
                }
                case 'n': {
                    return 10;
                }
                case 'r': {
                    return 13;
                }
                case 't': {
                    return 9;
                }
                case 'v': {
                    return 11;
                }
                case '\\': {
                    return 92;
                }
                case 'u': {
                    i[0] = i[0] + 1;
                    x = Tr._add16(4, s, i);
                    return x < 0 ? 117 : x;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    x = Tr._add8(3, s, i);
                    return x < 0 ? 48 : x;
                }
            }
            return x;
        }
        return x;
    }

    static int indexOf(String s, int c) {
        int[] i = new int[]{0};
        int j = 0;
        while (i[0] < s.length()) {
            int x = Tr._getch(s, i);
            if (c == x) {
                return j;
            }
            if (i[0] < s.length() && s.codePointAt(i[0]) == 45) {
                i[0] = i[0] + 1;
                int y = s.codePointAt(i[0]);
                if (c <= y && c > x) {
                    return j + c - x;
                }
                i[0] = i[0] + (y > 65535 ? 2 : 1);
                j += y - x;
            }
            ++j;
        }
        return -1;
    }

    static int complementIndexOf(String s, int c) {
        int y;
        int x;
        TreeSet<P1> l = new TreeSet<P1>();
        int[] i = new int[]{0};
        while (i[0] < s.length()) {
            x = Tr._getch(s, i);
            if (i[0] < s.length() && s.codePointAt(i[0]) == 45) {
                i[0] = i[0] + 1;
                y = s.codePointAt(i[0]);
                i[0] = i[0] + (y > 65535 ? 2 : 1);
                l.add(new P1(x, y));
                continue;
            }
            l.add(new P1(x, x));
        }
        y = 0;
        x = 0;
        for (P1 p : l) {
            if (c < p.bgn) {
                return y + c - x;
            }
            if (c <= p.end) {
                return -1;
            }
            y = p.bgn < x ? y : y + p.bgn - x;
            x = p.end + 1;
        }
        return y + c - x;
    }

    static int codePointAt(String s, int index) {
        int[] i = new int[]{0};
        int j = 0;
        while (i[0] < s.length()) {
            int x = Tr._getch(s, i);
            if (index == j) {
                return x;
            }
            if (i[0] < s.length() && s.codePointAt(i[0]) == 45) {
                i[0] = i[0] + 1;
                int y = s.codePointAt(i[0]);
                if (index - j <= y - x) {
                    return x + index - j;
                }
                i[0] = i[0] + (y > 65535 ? 2 : 1);
                j += y - x;
            }
            ++j;
        }
        return -1;
    }

    static int length(String s) {
        int[] i = new int[1];
        int j = 0;
        i[0] = 0;
        while (i[0] < s.length()) {
            int x = Tr._getch(s, i);
            if (i[0] < s.length() && s.codePointAt(i[0]) == 45) {
                i[0] = i[0] + 1;
                int y = s.codePointAt(i[0]);
                i[0] = i[0] + (y > 65535 ? 2 : 1);
                j += y - x;
            }
            ++j;
        }
        return j;
    }

    static int tr(T1 t1, String source, String dest, int c, boolean trunc) {
        if (source.length() == 0) {
            return c;
        }
        if (dest.length() == 0) {
            return c;
        }
        int x = t1.indexOf(source, c);
        if (x < 0 || trunc && x >= Tr.length(dest)) {
            return c;
        }
        int d = Tr.codePointAt(dest, x);
        if (d >= 0) {
            return d;
        }
        return Tr.codePointAt(dest, Tr.length(dest) - 1);
    }

    static String tr(T1 t1, String source, String dest, String s, boolean tranc) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            int c = s.codePointAt(i);
            b.appendCodePoint(Tr.tr(t1, source, dest, c, tranc));
            i += c > 65535 ? 2 : 1;
        }
        return b.toString();
    }

    public static int tr(String source, String dest, int c, boolean cmp, boolean trunc) {
        Map<String, T1> m;
        Map<String, T1> map = m = cmp ? classec : classe;
        if (source.equals(dest)) {
            return c;
        }
        if (source.equals("[:upper:]") && dest.equals("[:lower:]")) {
            return Character.toLowerCase(c);
        }
        if (source.equals("[:lower:]") && dest.equals("[:upper:]")) {
            return Character.toUpperCase(c);
        }
        T1 t = m.get(source);
        if (t != null) {
            return Tr.tr(t, source, dest, c, trunc);
        }
        if (cmp) {
            return Tr.tr(CF, source, dest, c, trunc);
        }
        return Tr.tr(DF, source, dest, c, trunc);
    }

    public static String tr(String source, String dest, String s, boolean cmp, boolean trunc) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            int c = s.codePointAt(i);
            b.appendCodePoint(Tr.tr(source, dest, c, cmp, trunc));
            i += c > 65535 ? 2 : 1;
        }
        return b.toString();
    }

    public static String tr(String source, String dest, String s) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            int c = s.codePointAt(i);
            b.appendCodePoint(Tr.tr(DF, source, dest, c, false));
            i += c > 65535 ? 2 : 1;
        }
        return b.toString();
    }

    public static int indexOf(String source, int c, boolean cmp) {
        Map<String, T1> m = cmp ? classec : classe;
        T1 t = m.get(source);
        if (t == null) {
            t = cmp ? CF : DF;
        }
        return t.indexOf(source, c);
    }

    private static class P1
    implements Comparable<P1> {
        int bgn;
        int end;

        P1(int b, int e) {
            this.bgn = b;
            this.end = e;
        }

        public int hashCode() {
            return this.bgn;
        }

        public boolean equals(Object o) {
            if (o instanceof P1) {
                return this.bgn == ((P1)o).bgn && this.end == ((P1)o).end;
            }
            return false;
        }

        @Override
        public int compareTo(P1 p) {
            if (this.bgn < p.bgn) {
                return -1;
            }
            if (this.bgn > p.bgn) {
                return 1;
            }
            if (this.end < p.end) {
                return -1;
            }
            if (this.end > p.end) {
                return 1;
            }
            return 0;
        }
    }

    private static abstract class T1 {
        private T1() {
        }

        abstract int indexOf(String var1, int var2);
    }
}

