/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.unix.misc;

import java.io.IOException;
import java.io.Reader;
import net.morilib.unix.misc.Tr;

public class TrReader
extends Reader {
    private Reader in;
    private String source;
    private String dest;
    private String squeeze;
    private boolean complement;
    private boolean truncate;
    private int pback = -1;

    public TrReader(Reader in, String source, String dest, String squeeze, boolean complement, boolean truncate) {
        this.in = in;
        this.source = source;
        this.dest = dest;
        this.squeeze = squeeze;
        this.complement = complement;
        this.truncate = truncate;
    }

    private int _read() throws IOException {
        int c;
        if (this.pback >= 0) {
            c = this.pback;
            this.pback = -1;
        } else {
            c = this.in.read();
            if (c < 0) {
                return -1;
            }
            if (this.source == null) {
                return c;
            }
            if (this.dest != null) {
                c = Tr.tr(this.source, this.dest, c, this.complement, this.truncate);
            } else {
                while (Tr.indexOf(this.source, c, this.complement) >= 0 && (c = this.in.read()) >= 0) {
                }
            }
        }
        return c;
    }

    @Override
    public int read() throws IOException {
        int c = this._read();
        if (this.squeeze != null) {
            int d;
            while ((d = this._read()) >= 0 && c == d && Tr.indexOf(this.squeeze, d, this.complement) >= 0) {
            }
            this.pback = d;
        }
        return c;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int i = 0;
        while (i < len) {
            int c = this.read();
            if (c < 0) {
                return i > 0 ? i : -1;
            }
            cbuf[i + off] = (char)c;
            ++i;
        }
        return len;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

