/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.nano.builtin;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import net.morilib.awk.nano.io.AwkFiles;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.value.AwkFunction;
import net.morilib.awk.nano.value.AwkString;
import net.morilib.awk.nano.value.AwkValue;

/**
 * 組み込み関数subの記述です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class AwkSub extends AwkFunction {

	/**
	 * 
	 */
	public AwkSub() {
		super("sub", null);
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o,
			List<AwkValue> args) {
		StringBuffer b = new StringBuffer();
		Pattern p;
		Matcher m;
		String s, t;
		int i = 0;

		s = args.size() < 2 ? "" : args.get(1).toString(ns);
		t = (args.size() < 3 ?
				ns.referField(0) : args.get(2)).toString(ns);
		if(args.size() < 1) {
			return AwkString.valueOf("");
		} else {
			p = args.get(0).toRegex(ns);
			m = p.matcher(t);
			if(m.find()) {
				b.append(t, i, m.start());
				b.append(AwkGsub.rep1(s, m));
				i = m.end();
			}
			t = b.append(t, i, t.length()).toString();
			return AwkString.valueOf(t);
		}
	}

}
