/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.nano.parser;

/**
 * 演算子のシンボルです。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03/09
 */
public class AwkOperator extends AwkToken
implements Comparable<AwkOperator> {

	/**
	 * 加算演算子(+)です。
	 */
	public static final AwkOperator ADD = new AwkOperator("+", 24);

	/**
	 * 減算演算子(-)です。
	 */
	public static final AwkOperator SUB = new AwkOperator("-", 24);

	/**
	 * 乗算演算子(*)です。
	 */
	public static final AwkOperator MUL = new AwkOperator("*", 22);

	/**
	 * 除算演算子(/)です。
	 */
	public static final AwkOperator DIV = new AwkOperator("/", 22);

	/**
	 * 剰余演算子(%)です。
	 */
	public static final AwkOperator MOD = new AwkOperator("%", 22);

	/**
	 * べき乗演算子(^)です。
	 */
	public static final AwkOperator POW = new AwkOperator("^", 16);
//	public static final AwkOperator B_AND = new AwkOperator("&");

	/**
	 * in演算子です。
	 */
	public static final AwkOperator IN = new AwkOperator("in", 35);

	/**
	 * 論理積演算子(&&)です。
	 */
	public static final AwkOperator L_AND = new AwkOperator("&&", 36);

	/**
	 * 論理和演算子(||)です。
	 */
	public static final AwkOperator L_OR  = new AwkOperator("||", 38);

	/**
	 * 論理否定演算子(!)です。
	 */
	public static final AwkOperator L_NOT = new AwkOperator("!", 20);

	/**
	 * 条件演算子の1つ(?)です。
	 */
	public static final AwkOperator TRI1 = new AwkOperator("?", 40);

	/**
	 * 条件演算子の2つ目(:)です。
	 */
	public static final AwkOperator TRI2 = new AwkOperator(":", 40);

	/**
	 * 左括弧です。
	 */
	public static final AwkOperator LPAREN = new AwkOperator("(", 1);

	/**
	 * 右括弧です。
	 */
	public static final AwkOperator RPAREN = new AwkOperator(")", 1);

	/**
	 * インクリメント演算子です。
	 */
	public static final AwkOperator INC = new AwkOperator("++", 18);

	/**
	 * デクリメント演算子です。
	 */
	public static final AwkOperator DEC = new AwkOperator("--", 18);

	/**
	 * マッチ演算子(~)です。
	 */
	public static final AwkOperator MATCH = new AwkOperator("~", 32);

	/**
	 * 非マッチ演算子(!~)です。
	 */
	public static final AwkOperator NMATCH = new AwkOperator("!~", 32);

	/**
	 * フィールド演算子($)です。
	 */
	public static final AwkOperator FIELD = new AwkOperator("$", 12);

	/**
	 * 名前空間の区切りです。
	 */
	public static final AwkOperator NAME = new AwkOperator(".", 12);

	/**
	 * カンマ(演算子)です。
	 */
	public static final AwkOperator COMMA = new AwkOperator(",", 99);

	/**
	 * 左ブラケットです。
	 */
	public static final AwkOperator LBRAKET = new AwkOperator("[", 7);

	/**
	 * 右ブラケットです。
	 */
	public static final AwkOperator RBRAKET = new AwkOperator("]", 7);

	/**
	 * 関数空間参照演算子(@)です。
	 */
	public static final AwkOperator REFFN = new AwkOperator("@", 9);

	private int pr;

	AwkOperator(String desc, int priority) {
		super(desc);
		pr = priority;
	}

	public int compareTo(AwkOperator o) {
		return pr > o.pr ? -1 : pr < o.pr ? 1 : 0;
	}

}
