/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.nano.parser;

import java.util.HashMap;
import java.util.Map;

/**
 * awkiumシンボルをあらわします。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class AwkSymbol extends AwkToken {

	private String name;

	private static Map<String, AwkSymbol> vars =
		new HashMap<String, AwkSymbol>();

	private AwkSymbol(String name) {
		super("variable: " + name);
		this.name = name;
	}

	/**
	 * シンボルを取得します。
	 * 
	 * @param name シンボル名
	 * @return シンボル
	 */
	public static AwkSymbol getInstance(String name) {
		AwkSymbol v;

		if((v = vars.get(name)) == null) {
			vars.put(name, v = new AwkSymbol(name));
		}
		return v;
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.parser.AwkToken#getString()
	 */
	public String getString() {
		return name;
	}

}
