/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.nano.pattern;

import net.morilib.awk.nano.io.AwkFiles;
import net.morilib.awk.nano.namespace.AwkNamespace;

/**
 * 論理否定のパターン中間表現です。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class AwkNotPattern implements AwkPattern {

	private AwkPattern e1;

	/**
	 * 中間表現を生成します。
	 * 
	 * @param e1 パターン
	 */
	public AwkNotPattern(AwkPattern e1) {
		this.e1 = e1;
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.pattern.AwkPattern#isBegin()
	 */
	public boolean isBegin() {
		return false;
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.pattern.AwkPattern#isEnd()
	 */
	public boolean isEnd() {
		return false;
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.pattern.AwkPattern#match(net.morilib.awk.namespace.AwkNamespace, net.morilib.awk.io.AwkFiles, java.lang.String, net.morilib.awk.pattern.AwkMatchState)
	 */
	public AwkMatchState match(AwkNamespace ns, AwkFiles fs,
			String s, AwkMatchState stat) {
		boolean e;

		e = e1.match(ns, fs, s, stat).isNotMatched();
		return  e ? AwkMatchState.MATCHED : AwkMatchState.NO_MATCH;
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.pattern.AwkPattern#isRanged()
	 */
	public boolean isRanged() {
		return false;
	}

}
