/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.nano.statement;

import net.morilib.awk.nano.expr.AwkExpression;
import net.morilib.awk.nano.io.AwkFiles;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.value.AwkUndefined;
import net.morilib.awk.nano.value.AwkValue;

/**
 * if文の中間表現です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/14
 */
public class AwkIf extends AwkExpression {

	private AwkExpression cond, ifBlock, elseBlock;

	/**
	 * 中間表現を生成します。
	 * 
	 * @param cond 条件式の中間表現
	 * @param ifBlock   if部の中間表現
	 * @param elseBlock else部の中間表現
	 */
	public AwkIf(AwkExpression cond, AwkExpression ifBlock,
			AwkExpression elseBlock) {
		this.cond = cond;
		this.ifBlock = ifBlock;
		this.elseBlock = elseBlock;
	}

	@Override
	public AwkValue eval(AwkNamespace s, AwkFiles f) {
		if(cond.eval(s, f).toBoolean(s)) {
			return ifBlock.eval(s, f);
		} else if(elseBlock != null) {
			return elseBlock.eval(s, f);
		} else {
			return AwkUndefined.UNDEF;
		}
	}

	public void compileInternally(AwkExpressionMachine.Builder b,
			Object brk, Object cnt) {
		Object l1 = new Object(), l2 = new Object();

		cond.compileInternally(b, brk, cnt);
		b.addJmpZ(l1);
		ifBlock.compileInternally(b, brk, cnt);
		if(elseBlock != null) {
			b.addJmp(l2);
			b.addLabel(l1);
			elseBlock.compileInternally(b, brk, cnt);
			b.addLabel(l2);
		} else {
			b.addLabel(l1);
		}
	}

}
