/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.nano.strftime;

import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;

public class StrftimeUuAction implements StrftimeAction {

	public void action(Writer writer, Date date) throws IOException {
		Calendar c, d, e;
		int w, v;

		c = Calendar.getInstance();
		d = Calendar.getInstance();
		c.setTime(date);  d.setTime(date);
		c.set(Calendar.DAY_OF_YEAR, 1);
		w = (8 - c.get(Calendar.DAY_OF_WEEK)) % 7;
		v = d.get(Calendar.DAY_OF_YEAR);
		if(v <= w) {
			e = Calendar.getInstance();
			c.roll(Calendar.YEAR, -1);
			w = (8 - c.get(Calendar.DAY_OF_WEEK)) % 7;
			e.setTime(date);
			e.set(Calendar.DAY_OF_YEAR, 1);
			e.roll(Calendar.DAY_OF_YEAR, -1);
			v = v + e.get(Calendar.DAY_OF_YEAR);
		}
		writer.append(String.format("%02d", (v - w) / 7));
	}

}
