/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.nano.java6;

import java.util.Arrays;
import java.util.List;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;

import net.morilib.awk.nano.Awk;
import net.morilib.awk.nano.namespace.AwkNamespace;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2014/02/19
 */
public class AwkScriptEngineFactory implements ScriptEngineFactory {

	private static final AwkNamespace GLOBAL =
			Awk.newNamespace("<script>");

	/* (non-Javadoc)
	 * @see javax.script.ScriptEngineFactory#getEngineName()
	 */
	@Override
	public String getEngineName() {
		return "awkium morilib awk Engine";
	}

	/* (non-Javadoc)
	 * @see javax.script.ScriptEngineFactory#getEngineVersion()
	 */
	@Override
	public String getEngineVersion() {
		return Awk.VERSION;
	}

	/* (non-Javadoc)
	 * @see javax.script.ScriptEngineFactory#getExtensions()
	 */
	@Override
	public List<String> getExtensions() {
		return Arrays.asList("awk");
	}

	/* (non-Javadoc)
	 * @see javax.script.ScriptEngineFactory#getMimeTypes()
	 */
	@Override
	public List<String> getMimeTypes() {
		return Arrays.asList("application/x-awkium");
	}

	/* (non-Javadoc)
	 * @see javax.script.ScriptEngineFactory#getNames()
	 */
	@Override
	public List<String> getNames() {
		return Arrays.asList("awk", "awkium");
	}

	/* (non-Javadoc)
	 * @see javax.script.ScriptEngineFactory#getLanguageName()
	 */
	@Override
	public String getLanguageName() {
		return "awk";
	}

	/* (non-Javadoc)
	 * @see javax.script.ScriptEngineFactory#getLanguageVersion()
	 */
	@Override
	public String getLanguageVersion() {
		return "awkium " + Awk.VERSION;
	}

	/* (non-Javadoc)
	 * @see javax.script.ScriptEngineFactory#getParameter(java.lang.String)
	 */
	@Override
	public Object getParameter(String key) {
		if(key == null) {
			return null;
		} else if(key.equals(ScriptEngine.ENGINE)) {
			return getEngineName();
		} else if(key.equals(ScriptEngine.ENGINE_VERSION)) {
			return getEngineVersion();
		} else if(key.equals(ScriptEngine.NAME)) {
			return "awk";
		} else if(key.equals(ScriptEngine.LANGUAGE)) {
			return getLanguageName();
		} else if(key.equals(ScriptEngine.LANGUAGE_VERSION)) {
			return getLanguageVersion();
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see javax.script.ScriptEngineFactory#getMethodCallSyntax(java.lang.String, java.lang.String, java.lang.String[])
	 */
	@Override
	public String getMethodCallSyntax(String obj, String m,
			String... args) {
		StringBuilder b = new StringBuilder();
		String d = "(";

		b.append(obj).append(".");
		for(String s : args) {
			b.append(d).append(s);
			d = ",";
		}
		b.append(")");
		return b.toString();
	}

	/* (non-Javadoc)
	 * @see javax.script.ScriptEngineFactory#getOutputStatement(java.lang.String)
	 */
	@Override
	public String getOutputStatement(String toDisplay) {
		return "printf(\"%s\", " + toDisplay + ");";
	}

	/* (non-Javadoc)
	 * @see javax.script.ScriptEngineFactory#getProgram(java.lang.String[])
	 */
	@Override
	public String getProgram(String... statements) {
		StringBuilder b = new StringBuilder();

		b.append("{");
		for(String s : statements) {
			b.append(s).append(";\n");
		}
		b.append("}");
		return b.toString();
	}

	/* (non-Javadoc)
	 * @see javax.script.ScriptEngineFactory#getScriptEngine()
	 */
	@Override
	public ScriptEngine getScriptEngine() {
		return new AwkScriptEngine(GLOBAL, this);
	}

}
