/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.automata.lr;

import java.util.Collection;
import java.util.Map;

/**
 * 
 * 
 * @author MORIGUCHI, Yuichiro 2006/07/08
 */
public interface LR1Table {

	/**
	 * 
	 * @return
	 */
	public int getSizeOfStates();

	/**
	 * 
	 * @param stateID
	 * @param terminal
	 * @return
	 */
	public LRAction action(int stateID, Terminal terminal);

	/**
	 * 
	 * @param stateID
	 * @return
	 */
	public Map<GrammarSymbol, LRAction> actions(int stateID);

	/**
	 * 
	 * @param stateID
	 * @param nonterminal
	 * @return
	 */
	public int goTo(int stateID, Nonterminal nonterminal);

	/**
	 * 
	 * @param stateID
	 * @return
	 */
	public Map<Nonterminal, Integer> goTos(int stateID);

	/**
	 * 
	 * @return
	 */
	public int getInitialStateID();

	/**
	 * 
	 * @return
	 */
	public Collection<LRConflict> getConflicts();

}
